/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;

public final class Utility {
    public static final Color BORDER_COLOR = ResourceManager.getColor("color.border.LookAndFeel");
    public static final Color LINK_COLOR = ResourceManager.getColor("color.link.LookAndFeel");
    public static final Color WARNING_COLOR = ResourceManager.getColor("color.warning.LookAndFeel");
    public static final Border TRIVIAL_LINE_BORDER = BorderFactory.createLineBorder(BORDER_COLOR);
    public static final Border BEVEL_BORDER = BorderFactory.createBevelBorder(1);
    public static final Border COLOR_CELL_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 10, 5, 10, new ImageIcon(ResourceManager.getImage("image.background.ColorCellRenderer"))), BorderFactory.createLineBorder(BORDER_COLOR));
    public static final Border DIALOG_BORDER = BorderFactory.createCompoundBorder(TRIVIAL_LINE_BORDER, Utility.blankBorder(10, 20, 10, 20));
    public static final Border ETCHED_BORDER = BorderFactory.createEtchedBorder();
    public static final Border PRODUCTION_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, BORDER_COLOR), Utility.blankBorder(2, 2, 2, 2));
    public static final Border PROGRESS_BORDER = BorderFactory.createLineBorder(new Color(122, 109, 82));
    public static final Border SIMPLE_LINE_BORDER = BorderFactory.createCompoundBorder(TRIVIAL_LINE_BORDER, Utility.blankBorder(5, 5, 5, 5));
    public static final Border TOPCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border CELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border LEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    public static final Border TOPLEFTCELLBORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, BORDER_COLOR), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    private static final int DEFAULT_TEXT_COLUMNS = 20;
    public static final Insets EMPTY_MARGIN = new Insets(0, 0, 0, 0);
    public static StyleContext STYLE_CONTEXT = null;

    public static void initStyleContext(Font font) {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        STYLE_CONTEXT = new StyleContext();
        Style regular = STYLE_CONTEXT.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(regular, font.getFamily());
        StyleConstants.setFontSize(regular, font.getSize());
        Style buttonStyle = STYLE_CONTEXT.addStyle("button", regular);
        StyleConstants.setForeground(buttonStyle, LINK_COLOR);
        Style right = STYLE_CONTEXT.addStyle("right", regular);
        StyleConstants.setAlignment(right, 2);
    }

    public static JButton getLinkButton(String text, Icon icon, String action) {
        JButton button = new JButton(text, icon);
        button.setMargin(EMPTY_MARGIN);
        button.setOpaque(false);
        button.setForeground(LINK_COLOR);
        button.setAlignmentY(0.8f);
        button.setBorder(Utility.blankBorder(0, 0, 0, 0));
        button.setActionCommand(action);
        button.setCursor(Cursor.getPredefinedCursor(12));
        return button;
    }

    public static JButton getMessageButton(String key, String val, Player player, FreeColGameObject source) {
        FreeColGameObject link = null;
        if ("%colony%".equals(key) || key.endsWith("Colony%")) {
            Settlement settlement = player.getGame().getSettlementByName(val);
            link = settlement == null ? null : (player.owns(settlement) ? settlement : settlement.getTile());
        } else if ("%europe%".equals(key) || "%market%".equals(key)) {
            link = player.getEurope();
        } else if ("%location%".equals(key) || key.endsWith("Location%")) {
            if (source instanceof Location) {
                link = source.getLinkTarget(player);
            }
        } else if (("%unit%".equals(key) || key.endsWith("Unit%")) && source instanceof Unit) {
            link = source.getLinkTarget(player);
        }
        return link == null ? null : Utility.getLinkButton(val, null, link.getId());
    }

    public static JTextArea createTextArea(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setOpaque(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        return textArea;
    }

    public static JTextArea getDefaultTextArea(String text) {
        return Utility.getDefaultTextArea(text, 20);
    }

    public static JTextArea getDefaultTextArea(String text, int columns) {
        JTextArea textArea = Utility.createTextArea(text);
        textArea.setColumns(columns);
        textArea.setSize(textArea.getPreferredSize());
        return textArea;
    }

    public static JTextArea getDefaultTextArea(String text, Dimension size) {
        JTextArea textArea = Utility.createTextArea(text);
        textArea.setPreferredSize(size);
        return textArea;
    }

    public static JTextPane getDefaultTextPane() {
        DefaultStyledDocument document = new DefaultStyledDocument(STYLE_CONTEXT);
        JTextPane textPane = new JTextPane(document);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        textPane.setLogicalStyle(STYLE_CONTEXT.getStyle("regular"));
        return textPane;
    }

    public static JTextPane getDefaultTextPane(String text) {
        JTextPane textPane = Utility.getDefaultTextPane();
        textPane.setText(text);
        return textPane;
    }

    public static Border blankBorder(int top, int left, int bottom, int right) {
        return BorderFactory.createEmptyBorder(top, left, bottom, right);
    }

    public static void padBorder(JComponent component, int top, int left, int bottom, int right) {
        component.setBorder(BorderFactory.createCompoundBorder(Utility.blankBorder(top, left, bottom, right), component.getBorder()));
    }

    public static void localizeBorder(JComponent component, StringTemplate template) {
        TitledBorder tb = (TitledBorder)component.getBorder();
        tb.setTitle(Messages.message(template));
    }

    public static TitledBorder localizedBorder(Named named) {
        return Utility.localizedBorder(named.getNameKey());
    }

    public static TitledBorder localizedBorder(String key) {
        return BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), Messages.message(key));
    }

    public static TitledBorder localizedBorder(String key, Color color) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(color, 1), Messages.message(key));
    }

    public static JButton localizedButton(String key) {
        return new JButton(Messages.message(key));
    }

    public static JButton localizedButton(StringTemplate template) {
        return new JButton(Messages.message(template));
    }

    public static JCheckBoxMenuItem localizedCheckBoxMenuItem(String key, boolean value) {
        return new JCheckBoxMenuItem(Messages.message(key), value);
    }

    public static JLabel localizedHeader(String key, boolean small) {
        JLabel header = Utility.localizedHeaderLabel(key, 0, small ? FontLibrary.FontSize.SMALL : FontLibrary.FontSize.BIG);
        header.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 0));
        return header;
    }

    public static JLabel localizedHeaderLabel(String key, int alignment, FontLibrary.FontSize size) {
        String text = Messages.message(key);
        JLabel header = new JLabel(text, alignment);
        header.setFont(FontLibrary.createCompatibleFont(text, FontLibrary.FontType.HEADER, size));
        header.setOpaque(false);
        return header;
    }

    public static JLabel localizedHeaderLabel(StringTemplate template, int alignment, FontLibrary.FontSize size) {
        String text = Messages.message(template);
        JLabel header = new JLabel(text, alignment);
        header.setFont(FontLibrary.createCompatibleFont(text, FontLibrary.FontType.HEADER, size));
        header.setOpaque(false);
        return header;
    }

    public static JLabel localizedHeaderLabel(Named named, FontLibrary.FontSize size) {
        return Utility.localizedHeaderLabel(named.getNameKey(), 10, size);
    }

    public static JLabel localizedLabel(Named named) {
        return Utility.localizedLabel(named.getNameKey());
    }

    public static JLabel localizedLabel(String key) {
        return Utility.localizedLabel(StringTemplate.key(key));
    }

    public static JLabel localizedLabel(StringTemplate template) {
        JLabel label = new JLabel(Messages.message(template));
        label.setOpaque(false);
        return label;
    }

    public static JLabel localizedLabel(StringTemplate template, Icon icon, int alignment) {
        JLabel label = new JLabel(Messages.message(template), icon, alignment);
        label.setOpaque(false);
        return label;
    }

    public static JMenu localizedMenu(String key) {
        return new JMenu(Messages.message(key));
    }

    public static JMenu localizedMenu(StringTemplate template) {
        return new JMenu(Messages.message(template));
    }

    public static JMenuItem localizedMenuItem(String key) {
        return Utility.localizedMenuItem(key, null);
    }

    public static JMenuItem localizedMenuItem(String key, Icon icon) {
        return new JMenuItem(Messages.message(key), icon);
    }

    public static JMenuItem localizedMenuItem(StringTemplate template) {
        return Utility.localizedMenuItem(template, null);
    }

    public static JMenuItem localizedMenuItem(StringTemplate template, Icon icon) {
        return new JMenuItem(Messages.message(template), icon);
    }

    public static JRadioButtonMenuItem localizedRadioButtonMenuItem(StringTemplate template, boolean value) {
        return new JRadioButtonMenuItem(Messages.message(template), value);
    }

    public static JTextArea localizedTextArea(String key) {
        return Utility.localizedTextArea(StringTemplate.key(key));
    }

    public static JTextArea localizedTextArea(String key, int columns) {
        return Utility.localizedTextArea(StringTemplate.key(key), columns);
    }

    public static JTextArea localizedTextArea(StringTemplate template) {
        return Utility.localizedTextArea(template, 20);
    }

    public static JTextArea localizedTextArea(StringTemplate template, int columns) {
        return Utility.getDefaultTextArea(Messages.message(template), columns);
    }

    public static JComponent localizeToolTip(JComponent comp, String key) {
        comp.setToolTipText(Messages.message(key));
        return comp;
    }

    public static JComponent localizeToolTip(JComponent comp, StringTemplate template) {
        comp.setToolTipText(Messages.message(template));
        return comp;
    }
}

