/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "tools.h"
#include"getput.h"
#include"datei.h"
#include "matrix.h"

/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE:  get_zentr.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ void get_zentr(B)
@ symbol_out *B;
@
@    Another function for the 'Datei' programm.
@    It reads matrices form the file 'B->fn' and 
@    stores them in 'B->zentr'.
@    Reads additionally a filename stated beyond the matrices
@    and stores it in B->fn.
@---------------------------------------------------------------------------
@
\**************************************************************************/
void get_zentr(B)
symbol_out *B;
{  

char *file_name;
boolean header = FALSE;
char  st;
char *fn,
     *old_fn;       /* the pointer fn is modified via fn++, old_fn
                       just makes it possible to free it */
FILE *infile;
int anz;
int k ;

file_name = B->fn;
B->fn = NULL;
	/*------------------------------------------------------------*\
	| Open input file											 |
	\*------------------------------------------------------------*/
if ( file_name == NULL )
	infile = stdin;
else
	if ( (infile = fopen (file_name, "r")) == NULL ) {
		fprintf (stderr, "get_zentr: Could not open input-file %s\n", file_name);
		exit (4);
		}
fscanf (infile, "%*[ \t\n\r]");
st = getc(infile);
if ( st != '#' ) {
	anz = 1;
	ungetc(st,infile);
	}
else
	fscanf (infile, "%u", &anz);
/*--------------------------------------------------------------------*\
|  read the matrices                                                   |
\*--------------------------------------------------------------------*/
if(anz != 0)
  B->grp->zentr = (matrix_TYP **)malloc(anz*sizeof(matrix_TYP *));
B->grp->zentr_no = anz;
for ( k = 0; k < anz; k++) {
	B->grp->zentr[k] = fget_mat(infile);
	}

	/*------------------------------------------------------------*\
	| read  file with other almost decomposable bravais-group      |
	\*------------------------------------------------------------*/
old_fn = fn = (char *) malloc(80 *sizeof(char));
fscanf (infile, "%[ \t\n]", fn);
fscanf (infile, "%[^\n]", fn);
while(fn != NULL && fn[0] == ' ')
  fn++;

/* added free(old_fn), tilman 7/5/97 */
if(fn[0] == '\n' ||
   fn[0] == '0'  ||
   fn[0] == EOF  ||
   fn[0] == '\t' ||
   fn[0] == '%'  ||
   fn[0] == '\f' ||
   fn[0] == '\r' ||
   fn[0] == '\v'){
   free(old_fn);
   fn = NULL;
}

if(fn != NULL)
  strtok (fn, "%");
if(fn != NULL)
{                               
  B->fn = calloc( 80 , sizeof(char) );
  strcat( B->fn, TABLES);
/***********************
  strcat( B->fn, TOPDIR "/lib/");
***********************/
  strcat(B->fn, fn);
  free ( fn );
}
	/*------------------------------------------------------------*\
	| Close input file												|
	\*------------------------------------------------------------*/
if ( infile != stdin )
	fclose (infile);

/* inserted tilman 7/5/97 */
if (file_name != NULL) free(file_name);

}
/*{{{}}}*/
