/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "matrix.h"
#include "tools.h"

/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: find_max_entry.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

static int max_abs( a, b )
int a, b;
{ 
int aa = abs(a), ab=abs(b);

  return ( aa >= ab ? aa : ab );

}

/*{{{}}}*/
/*{{{  find_max_entry*/


/**************************************************************************\
@---------------------------------------------------------------------------
@ int find_max_entry(mat)
@ matrix_TYP *mat;
@
@ calculates the maximal entry of mat->array.SZ
@ if mat->array.Z != 0 or mat->prime != 0 the functions return 0.
@---------------------------------------------------------------------------
@
\**************************************************************************/
int find_max_entry(mat)
matrix_TYP *mat;
{
int i,j;
int **Z, *S_i;
boolean flag;

  if( mat->prime != 0 || mat->array.N != NULL ) {
    return 0;
  }
  
  flag = 0;
  Z = mat->array.SZ;
  if(mat->flags.Diagonal) {
    if(mat->flags.Scalar) {
      return abs(Z[0][0]);
    } else {
      for (i = 0; i < mat->rows; i++) {
        flag = max_abs(flag,Z[i][i]);
      }     
      return flag;
    }
  }
  if(mat->flags.Symmetric) {
    for(i = 0; i < mat->rows; i++) {
      for(j = i; j < mat->cols; j++) {
        if(Z[i][j]) flag = max_abs(flag,Z[i][j]);
      }
    } 
    return flag;
  }
  
  for(i = 0; i < mat->rows; i++) {
    S_i = Z[i];
    for(j = 0; j < mat->cols; j++) {
      if(S_i[j]) {
        if(abs(S_i[j]) > flag) {
          flag = abs(S_i[j]);
        }
      }
    }  
  }
  return flag;
}

/*}}}  */

