/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "getput.h"
#include "matrix.h"


/**************************************************************************\
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@ FILE: put_order.c
@---------------------------------------------------------------------------
@---------------------------------------------------------------------------
@
\**************************************************************************/

/**************************************************************************\
@---------------------------------------------------------------------------
@ void fput_order(outfile, divisors, ord)
@ FILE *outfile;
@ int *divisors;
@ int ord;
@ A tools to print the order of a bravais_TYP
@---------------------------------------------------------------------------
@
\**************************************************************************/
void fput_order(outfile, divisors, ord)
FILE *outfile;
int *divisors;
int ord;
{
  int tester, i, j;
  if(divisors == NULL)
  {
     if(ord <= 0)
       fprintf(outfile, "%% order of the group unknown\n");
     else
       fprintf(outfile, " = %d %% order of the group\n", ord);
  }
  else
  {
    tester = FALSE;
    if(divisors[0] != 0)
       fprintf(outfile, "%% order of the group unknown\n");
    else
    {
      for(i=0; i<100 && tester == FALSE; i++)
        if(divisors[i] != 0)
           tester = TRUE;
      if(tester == FALSE && ord == 0)
       fprintf(outfile, "%% order of the group unknown\n");
      if(tester == TRUE)
      {
        j = 0;
        for(i=2; i<100; i++)
        {
          if(divisors[i] != 0)
          {
              if(j != 0)
                fprintf(outfile, "* ");
              fprintf(outfile, "%d^%d  ", i, divisors[i]);
              j = 1;
          }
        }
          if(ord != 0)
             fprintf(outfile, " = %d ", ord);
          fprintf(outfile, "%% order of the group\n");
      }
    }
  }
}


/*{{{}}}*/
