/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.AccessibleElementId;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.SplitCharacter;
import com.itextpdf.text.TabSplitCharacter;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.HyphenationEvent;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.draw.DrawInterface;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chunk
implements Element,
IAccessibleElement {
    public static final String OBJECT_REPLACEMENT_CHARACTER = "\ufffc";
    public static final Chunk NEWLINE = new Chunk("\n");
    public static final Chunk NEXTPAGE;
    public static final Chunk TABBING;
    public static final Chunk SPACETABBING;
    protected StringBuffer content = null;
    protected Font font = null;
    protected HashMap<String, Object> attributes = null;
    protected PdfName role = null;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    private AccessibleElementId id = null;
    public static final String SEPARATOR = "SEPARATOR";
    public static final String TAB = "TAB";
    public static final String TABSETTINGS = "TABSETTINGS";
    private String contentWithNoTabs = null;
    public static final String HSCALE = "HSCALE";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String SKEW = "SKEW";
    public static final String BACKGROUND = "BACKGROUND";
    public static final String TEXTRENDERMODE = "TEXTRENDERMODE";
    public static final String SPLITCHARACTER = "SPLITCHARACTER";
    public static final String HYPHENATION = "HYPHENATION";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String GENERICTAG = "GENERICTAG";
    public static final String LINEHEIGHT = "LINEHEIGHT";
    public static final String IMAGE = "IMAGE";
    public static final String ACTION = "ACTION";
    public static final String NEWPAGE = "NEWPAGE";
    public static final String PDFANNOTATION = "PDFANNOTATION";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String CHAR_SPACING = "CHAR_SPACING";
    public static final String WORD_SPACING = "WORD_SPACING";
    public static final String WHITESPACE = "WHITESPACE";

    public Chunk() {
        this.content = new StringBuffer();
        this.font = new Font();
        this.role = PdfName.SPAN;
    }

    public Chunk(Chunk ck) {
        if (ck.content != null) {
            this.content = new StringBuffer(ck.content.toString());
        }
        if (ck.font != null) {
            this.font = new Font(ck.font);
        }
        if (ck.attributes != null) {
            this.attributes = new HashMap<String, Object>(ck.attributes);
        }
        this.role = ck.role;
        if (ck.accessibleAttributes != null) {
            this.accessibleAttributes = new HashMap<PdfName, PdfObject>(ck.accessibleAttributes);
        }
        this.id = ck.getId();
    }

    public Chunk(String content, Font font) {
        this.content = new StringBuffer(content);
        this.font = font;
        this.role = PdfName.SPAN;
    }

    public Chunk(String content) {
        this(content, new Font());
    }

    public Chunk(char c, Font font) {
        this.content = new StringBuffer();
        this.content.append(c);
        this.font = font;
        this.role = PdfName.SPAN;
    }

    public Chunk(char c) {
        this(c, new Font());
    }

    public Chunk(Image image, float offsetX, float offsetY) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        Image copyImage = Image.getInstance(image);
        copyImage.setAbsolutePosition(Float.NaN, Float.NaN);
        this.setAttribute(IMAGE, new Object[]{copyImage, new Float(offsetX), new Float(offsetY), Boolean.FALSE});
        this.role = null;
    }

    public Chunk(DrawInterface separator) {
        this(separator, false);
    }

    public Chunk(DrawInterface separator, boolean vertical) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.setAttribute(SEPARATOR, new Object[]{separator, vertical});
        this.role = null;
    }

    @Deprecated
    public Chunk(DrawInterface separator, float tabPosition) {
        this(separator, tabPosition, false);
    }

    @Deprecated
    public Chunk(DrawInterface separator, float tabPosition, boolean newline) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        if (tabPosition < 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.tab.position.may.not.be.lower.than.0.yours.is.1", String.valueOf(tabPosition)));
        }
        this.setAttribute(TAB, new Object[]{separator, new Float(tabPosition), newline, new Float(0.0f)});
        this.role = PdfName.ARTIFACT;
    }

    private Chunk(Float tabInterval, boolean isWhitespace) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        if (tabInterval.floatValue() < 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("a.tab.position.may.not.be.lower.than.0.yours.is.1", String.valueOf(tabInterval)));
        }
        this.setAttribute(TAB, new Object[]{tabInterval, isWhitespace});
        this.setAttribute(SPLITCHARACTER, TabSplitCharacter.TAB);
        this.setAttribute(TABSETTINGS, null);
        this.role = PdfName.ARTIFACT;
    }

    public Chunk(Image image, float offsetX, float offsetY, boolean changeLeading) {
        this(OBJECT_REPLACEMENT_CHARACTER, new Font());
        this.setAttribute(IMAGE, new Object[]{image, new Float(offsetX), new Float(offsetY), changeLeading});
        this.role = PdfName.ARTIFACT;
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public int type() {
        return 10;
    }

    @Override
    public List<Chunk> getChunks() {
        ArrayList<Chunk> tmp = new ArrayList<Chunk>();
        tmp.add(this);
        return tmp;
    }

    public StringBuffer append(String string) {
        this.contentWithNoTabs = null;
        return this.content.append(string);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public String getContent() {
        if (this.contentWithNoTabs == null) {
            this.contentWithNoTabs = this.content.toString().replaceAll("\t", "");
        }
        return this.contentWithNoTabs;
    }

    @Override
    public String toString() {
        return this.getContent();
    }

    public boolean isEmpty() {
        return this.content.toString().trim().length() == 0 && this.content.toString().indexOf("\n") == -1 && this.attributes == null;
    }

    public float getWidthPoint() {
        if (this.getImage() != null) {
            return this.getImage().getScaledWidth();
        }
        return this.font.getCalculatedBaseFont(true).getWidthPoint(this.getContent(), this.font.getCalculatedSize()) * this.getHorizontalScaling();
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasAccessibleAttributes() {
        return this.accessibleAttributes != null && !this.accessibleAttributes.isEmpty();
    }

    public HashMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap<String, Object> attributes) {
        this.attributes = attributes;
    }

    private Chunk setAttribute(String name, Object obj) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, obj);
        return this;
    }

    public Chunk setHorizontalScaling(float scale) {
        return this.setAttribute(HSCALE, new Float(scale));
    }

    public float getHorizontalScaling() {
        if (this.attributes == null) {
            return 1.0f;
        }
        Float f = (Float)this.attributes.get(HSCALE);
        if (f == null) {
            return 1.0f;
        }
        return f.floatValue();
    }

    public Chunk setUnderline(float thickness, float yPosition) {
        return this.setUnderline(null, thickness, 0.0f, yPosition, 0.0f, 0);
    }

    public Chunk setUnderline(BaseColor color, float thickness, float thicknessMul, float yPosition, float yPositionMul, int cap) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        Object[] obj = new Object[]{color, new float[]{thickness, thicknessMul, yPosition, yPositionMul, cap}};
        Object[][] unders = Utilities.addToArray((Object[][])this.attributes.get(UNDERLINE), obj);
        return this.setAttribute(UNDERLINE, unders);
    }

    public Chunk setTextRise(float rise) {
        return this.setAttribute(SUBSUPSCRIPT, new Float(rise));
    }

    public float getTextRise() {
        if (this.attributes != null && this.attributes.containsKey(SUBSUPSCRIPT)) {
            Float f = (Float)this.attributes.get(SUBSUPSCRIPT);
            return f.floatValue();
        }
        return 0.0f;
    }

    public Chunk setSkew(float alpha, float beta) {
        alpha = (float)Math.tan((double)alpha * Math.PI / 180.0);
        beta = (float)Math.tan((double)beta * Math.PI / 180.0);
        return this.setAttribute(SKEW, new float[]{alpha, beta});
    }

    public Chunk setBackground(BaseColor color) {
        return this.setBackground(color, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Chunk setBackground(BaseColor color, float extraLeft, float extraBottom, float extraRight, float extraTop) {
        return this.setAttribute(BACKGROUND, new Object[]{color, new float[]{extraLeft, extraBottom, extraRight, extraTop}});
    }

    public Chunk setTextRenderMode(int mode, float strokeWidth, BaseColor strokeColor) {
        return this.setAttribute(TEXTRENDERMODE, new Object[]{mode, new Float(strokeWidth), strokeColor});
    }

    public Chunk setSplitCharacter(SplitCharacter splitCharacter) {
        return this.setAttribute(SPLITCHARACTER, splitCharacter);
    }

    public Chunk setHyphenation(HyphenationEvent hyphenation) {
        return this.setAttribute(HYPHENATION, hyphenation);
    }

    public Chunk setRemoteGoto(String filename, String name) {
        return this.setAttribute(REMOTEGOTO, new Object[]{filename, name});
    }

    public Chunk setRemoteGoto(String filename, int page) {
        return this.setAttribute(REMOTEGOTO, new Object[]{filename, page});
    }

    public Chunk setLocalGoto(String name) {
        return this.setAttribute(LOCALGOTO, name);
    }

    public Chunk setLocalDestination(String name) {
        return this.setAttribute(LOCALDESTINATION, name);
    }

    public Chunk setGenericTag(String text) {
        return this.setAttribute(GENERICTAG, text);
    }

    public Chunk setLineHeight(float lineheight) {
        return this.setAttribute(LINEHEIGHT, Float.valueOf(lineheight));
    }

    public Image getImage() {
        if (this.attributes == null) {
            return null;
        }
        Object[] obj = (Object[])this.attributes.get(IMAGE);
        if (obj == null) {
            return null;
        }
        return (Image)obj[0];
    }

    public Chunk setAction(PdfAction action) {
        this.setRole(PdfName.LINK);
        return this.setAttribute(ACTION, action);
    }

    public Chunk setAnchor(URL url) {
        this.setRole(PdfName.LINK);
        String urlStr = url.toExternalForm();
        this.setAccessibleAttribute(PdfName.ALT, new PdfString(urlStr));
        return this.setAttribute(ACTION, new PdfAction(urlStr));
    }

    public Chunk setAnchor(String url) {
        this.setRole(PdfName.LINK);
        this.setAccessibleAttribute(PdfName.ALT, new PdfString(url));
        return this.setAttribute(ACTION, new PdfAction(url));
    }

    public Chunk setNewPage() {
        return this.setAttribute(NEWPAGE, null);
    }

    public Chunk setAnnotation(PdfAnnotation annotation) {
        return this.setAttribute(PDFANNOTATION, annotation);
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public HyphenationEvent getHyphenation() {
        if (this.attributes == null) {
            return null;
        }
        return (HyphenationEvent)this.attributes.get(HYPHENATION);
    }

    public Chunk setCharacterSpacing(float charSpace) {
        return this.setAttribute(CHAR_SPACING, new Float(charSpace));
    }

    public float getCharacterSpacing() {
        if (this.attributes != null && this.attributes.containsKey(CHAR_SPACING)) {
            Float f = (Float)this.attributes.get(CHAR_SPACING);
            return f.floatValue();
        }
        return 0.0f;
    }

    public Chunk setWordSpacing(float wordSpace) {
        return this.setAttribute(WORD_SPACING, new Float(wordSpace));
    }

    public float getWordSpacing() {
        if (this.attributes != null && this.attributes.containsKey(WORD_SPACING)) {
            Float f = (Float)this.attributes.get(WORD_SPACING);
            return f.floatValue();
        }
        return 0.0f;
    }

    public static Chunk createWhitespace(String content) {
        return Chunk.createWhitespace(content, false);
    }

    public static Chunk createWhitespace(String content, boolean preserve) {
        Chunk whitespace = null;
        if (!preserve) {
            whitespace = new Chunk(' ');
            whitespace.setAttribute(WHITESPACE, content);
        } else {
            whitespace = new Chunk(content);
        }
        return whitespace;
    }

    public boolean isWhitespace() {
        return this.attributes != null && this.attributes.containsKey(WHITESPACE);
    }

    @Deprecated
    public static Chunk createTabspace() {
        return Chunk.createTabspace(60.0f);
    }

    @Deprecated
    public static Chunk createTabspace(float spacing) {
        Chunk tabspace = new Chunk(Float.valueOf(spacing), true);
        return tabspace;
    }

    @Deprecated
    public boolean isTabspace() {
        return this.attributes != null && this.attributes.containsKey(TAB);
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key) {
        if (this.getImage() != null) {
            return this.getImage().getAccessibleAttribute(key);
        }
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key, PdfObject value) {
        if (this.getImage() != null) {
            this.getImage().setAccessibleAttribute(key, value);
        } else {
            if (this.accessibleAttributes == null) {
                this.accessibleAttributes = new HashMap();
            }
            this.accessibleAttributes.put(key, value);
        }
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        if (this.getImage() != null) {
            return this.getImage().getAccessibleAttributes();
        }
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        if (this.getImage() != null) {
            return this.getImage().getRole();
        }
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        if (this.getImage() != null) {
            this.getImage().setRole(role);
        } else {
            this.role = role;
        }
    }

    @Override
    public AccessibleElementId getId() {
        if (this.id == null) {
            this.id = new AccessibleElementId();
        }
        return this.id;
    }

    @Override
    public void setId(AccessibleElementId id) {
        this.id = id;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public String getTextExpansion() {
        PdfObject o = this.getAccessibleAttribute(PdfName.E);
        if (o instanceof PdfString) {
            return ((PdfString)o).toUnicodeString();
        }
        return null;
    }

    public void setTextExpansion(String value) {
        this.setAccessibleAttribute(PdfName.E, new PdfString(value));
    }

    static {
        NEWLINE.setRole(PdfName.P);
        NEXTPAGE = new Chunk("");
        NEXTPAGE.setNewPage();
        TABBING = new Chunk(Float.valueOf(Float.NaN), false);
        SPACETABBING = new Chunk(Float.valueOf(Float.NaN), true);
    }
}

