/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileIterator;

public class DirectoryIterator
implements ClassFileIterator {
    private Stack enumStack = new Stack();
    private Enumeration currentEnum;

    public DirectoryIterator(File rootDirectory, boolean changeInto) throws IOException {
        Vector filesInRoot = this.getDirectoryEntries(rootDirectory);
        this.currentEnum = filesInRoot.elements();
    }

    private Vector getDirectoryEntries(File directory) {
        Vector<File> files = new Vector<File>();
        String[] filesInDir = directory.list();
        if (filesInDir != null) {
            int length = filesInDir.length;
            for (int i = 0; i < length; ++i) {
                files.addElement(new File(directory, filesInDir[i]));
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile getNextClassFile() {
        ClassFile nextElement = null;
        try {
            while (nextElement == null) {
                if (this.currentEnum.hasMoreElements()) {
                    File element = (File)this.currentEnum.nextElement();
                    if (element.isDirectory()) {
                        this.enumStack.push(this.currentEnum);
                        Vector files = this.getDirectoryEntries(element);
                        this.currentEnum = files.elements();
                        continue;
                    }
                    FileInputStream inFileStream = new FileInputStream(element);
                    try {
                        if (!element.getName().endsWith(".class")) continue;
                        ClassFile javaClass = new ClassFile();
                        javaClass.read(inFileStream);
                        nextElement = javaClass;
                        continue;
                    }
                    finally {
                        inFileStream.close();
                        continue;
                    }
                }
                if (!this.enumStack.empty()) {
                    this.currentEnum = (Enumeration)this.enumStack.pop();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            nextElement = null;
        }
        return nextElement;
    }
}

