/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.util.Log;

public class ErrorListDialog
extends EnhancedDialog {
    private JButton ok;
    private JButton pluginMgr;

    public ErrorListDialog(Frame frame, String string, String string2, Vector<ErrorEntry> vector, boolean bl) {
        super(frame, string, !bl);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string2);
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        JTextPaneSized jTextPaneSized = new JTextPaneSized();
        jTextPaneSized.setEditable(false);
        jTextPaneSized.setForeground(jEdit.getColorProperty("view.fgColor"));
        jTextPaneSized.setBackground(jEdit.getColorProperty("view.bgColor"));
        jTextPaneSized.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        jTextPaneSized.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        StyledDocument styledDocument = jTextPaneSized.getStyledDocument();
        Font font = new JLabel().getFont();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        SimpleAttributeSet simpleAttributeSet2 = (SimpleAttributeSet)simpleAttributeSet.clone();
        StyleConstants.setBold(simpleAttributeSet2, true);
        for (ErrorEntry object2 : vector) {
            try {
                styledDocument.insertString(styledDocument.getLength(), object2.path + ":\n", simpleAttributeSet2);
                for (String string3 : object2.messages) {
                    styledDocument.insertString(styledDocument.getLength(), string3 + "\n", simpleAttributeSet);
                }
            }
            catch (BadLocationException badLocationException) {
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jTextPaneSized);
        jPanel2.add("Center", jScrollPane);
        jPanel.add("Center", jPanel2);
        Box box2 = new Box(0);
        box2.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        if (bl) {
            this.pluginMgr = new JButton(jEdit.getProperty("error-list.plugin-manager"));
            this.pluginMgr.addActionListener(new ActionHandler());
            box2.add(this.pluginMgr);
            box2.add(Box.createHorizontalStrut(6));
        }
        box2.add(this.ok);
        box2.add(Box.createGlue());
        jPanel.add("South", box2);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ErrorListDialog.this.ok) {
                ErrorListDialog.this.dispose();
            } else if (actionEvent.getSource() == ErrorListDialog.this.pluginMgr) {
                PluginManager.showPluginManager(JOptionPane.getFrameForComponent(ErrorListDialog.this));
            }
        }
    }

    protected class JTextPaneSized
    extends JTextPane {
        protected JTextPaneSized() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 80 * fontMetrics.charWidth('X');
            int n2 = 25 * fontMetrics.getHeight();
            return new Dimension(n, n2);
        }
    }

    public static class ErrorEntry {
        String path;
        String[] messages;

        public ErrorEntry(String string, String string2, Object[] objectArray) {
            this(string, string2, objectArray, 9);
        }

        public ErrorEntry(String string, String string2, Object[] objectArray, int n) {
            this.path = string;
            String string3 = jEdit.getProperty(string2, objectArray);
            if (string3 == null) {
                string3 = "Undefined property: " + string2;
            }
            Log.log(n, this, string + ":");
            Log.log(n, this, string3);
            Vector<String> vector = new Vector<String>();
            int n2 = -1;
            for (int i = 0; i < string3.length(); ++i) {
                if (string3.charAt(i) != '\n') continue;
                vector.addElement(string3.substring(n2 + 1, i));
                n2 = i;
            }
            if (n2 != string3.length()) {
                vector.addElement(string3.substring(n2 + 1));
            }
            this.messages = new String[vector.size()];
            vector.copyInto(this.messages);
        }

        public boolean equals(Object object) {
            if (object instanceof ErrorEntry) {
                ErrorEntry errorEntry = (ErrorEntry)object;
                return errorEntry.path.equals(this.path);
            }
            return false;
        }

        public String toString() {
            return this.path + ":\n" + TextUtilities.join(Arrays.asList(this.messages), "\n");
        }
    }
}

