/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import org.openstreetmap.gui.jmapviewer.TileXY;

public class TileRange {
    protected int minX;
    protected int maxX;
    protected int minY;
    protected int maxY;
    protected int zoom;

    protected TileRange() {
    }

    public TileRange(TileXY t1, TileXY t2, int zoom) {
        this.minX = (int)Math.floor(Math.min(t1.getX(), t2.getX()));
        this.minY = (int)Math.floor(Math.min(t1.getY(), t2.getY()));
        this.maxX = (int)Math.ceil(Math.max(t1.getX(), t2.getX()));
        this.maxY = (int)Math.ceil(Math.max(t1.getY(), t2.getY()));
        this.zoom = zoom;
    }

    public TileRange(TileRange r) {
        this.minX = r.minX;
        this.minY = r.minY;
        this.maxX = r.maxX;
        this.maxY = r.maxY;
        this.zoom = r.zoom;
    }

    protected double tilesSpanned() {
        return Math.sqrt(1.0 * (double)this.size());
    }

    public int size() {
        int xSpan = this.maxX - this.minX + 1;
        int ySpan = this.maxY - this.minY + 1;
        return xSpan * ySpan;
    }
}

