/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;

public class NodeData
extends PrimitiveData
implements INode {
    private static final long serialVersionUID = 5626323599550908773L;
    private double lat = Double.NaN;
    private double lon = Double.NaN;

    public NodeData() {
    }

    public NodeData(long id) {
        super(id);
    }

    public NodeData(NodeData data) {
        super(data);
        this.setCoor(data.getCoor());
    }

    @Override
    public double lat() {
        return this.lat;
    }

    @Override
    public double lon() {
        return this.lon;
    }

    @Override
    public boolean isLatLonKnown() {
        return !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
    }

    @Override
    public LatLon getCoor() {
        return this.isLatLonKnown() ? new LatLon(this.lat, this.lon) : null;
    }

    @Override
    public final void setCoor(LatLon coor) {
        if (coor == null) {
            this.lat = Double.NaN;
            this.lon = Double.NaN;
        } else {
            this.lat = coor.lat();
            this.lon = coor.lon();
        }
    }

    @Override
    public void setEastNorth(EastNorth eastNorth) {
        this.setCoor(ProjectionRegistry.getProjection().eastNorth2latlon(eastNorth));
    }

    @Override
    public NodeData makeCopy() {
        return new NodeData(this);
    }

    @Override
    public String toString() {
        return super.toString() + " NODE " + this.getCoor();
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    @Override
    public void accept(PrimitiveVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BBox getBBox() {
        return new BBox(this.lon, this.lat);
    }

    @Override
    public boolean isReferredByWays(int n) {
        return false;
    }
}

