/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class CheckParameterUtil {
    private CheckParameterUtil() {
    }

    public static <T> void ensure(T obj, String parameterName, String conditionMsg, Predicate<T> condition) {
        CheckParameterUtil.ensureParameterNotNull(obj, parameterName);
        if (!condition.test(obj)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter value ''{0}'' of type {1} is invalid, violated condition: ''{2}'', got ''{3}''", parameterName, obj.getClass().getCanonicalName(), conditionMsg, obj));
        }
    }

    public static <T> void ensure(T obj, String parameterName, Predicate<T> condition) {
        CheckParameterUtil.ensureParameterNotNull(obj, parameterName);
        if (!condition.test(obj)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter value ''{0}'' of type {1} is invalid, got ''{2}''", parameterName, obj.getClass().getCanonicalName(), obj));
        }
    }

    public static void ensureParameterNotNull(Object value, String parameterName) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be null", parameterName));
        }
    }

    public static void ensureParameterNotNull(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
    }

    public static void ensureThat(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ensureThat(boolean condition, Supplier<String> messageSupplier) {
        if (!condition) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }
}

