/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.DetectedLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Languages;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.RuleMatchesAsJsonSerializer;
import org.languagetool.tools.Tools;

public class RuleMatchesAsJsonSerializerTest {
    private final RuleMatchesAsJsonSerializer serializer = new RuleMatchesAsJsonSerializer();
    private final List<RuleMatch> matches = Arrays.asList(new RuleMatch((Rule)new FakeRule(), new JLanguageTool(Languages.getLanguageForShortCode((String)"xx")).getAnalyzedSentence("This is an test sentence."), 1, 3, "My Message, use <suggestion>foo</suggestion> instead", "short message"));

    @Test
    public void testJson() {
        DetectedLanguage lang = new DetectedLanguage(Languages.getLanguageForShortCode((String)"xx-XX"), Languages.getLanguageForShortCode((String)"xx-XX"));
        String json = this.serializer.ruleMatchesToJson(this.matches, "This is an text.", 5, lang);
        this.assertContains("\"LanguageTool\"", json);
        this.assertContains("4.4", json);
        this.assertContains("\"Testlanguage\"", json);
        this.assertContains("\"xx-XX\"", json);
        this.assertContains("\"My Message, use \\\"foo\\\" instead\"", json);
        this.assertContains("\"My rule description\"", json);
        this.assertContains("\"FAKE_ID\"", json);
        this.assertContains("\"This is ...\"", json);
        this.assertContains("\"http://foobar.org/blah\"", json);
        this.assertContains("\"addition\"", json);
        this.assertContains("\"short message\"", json);
        this.assertContains("\"sentence\":\"This is an test sentence.\"", json);
    }

    private void assertContains(String expectedSubstring, String json) {
        Assert.assertTrue((String)("Did not find expected string '" + expectedSubstring + "' in JSON:\n" + json), (boolean)json.contains(expectedSubstring));
    }

    @Test
    public void testJsonWithUnixLinebreak() {
        DetectedLanguage lang = new DetectedLanguage(Languages.getLanguageForShortCode((String)"xx-XX"), Languages.getLanguageForShortCode((String)"xx-XX"));
        String json = this.serializer.ruleMatchesToJson(this.matches, "This\nis an text.", 5, lang);
        Assert.assertTrue((boolean)json.contains("This is ..."));
    }

    @Test
    public void testJsonWithWindowsLinebreak() {
        DetectedLanguage lang = new DetectedLanguage(Languages.getLanguageForShortCode((String)"xx-XX"), Languages.getLanguageForShortCode((String)"xx-XX"));
        String json = this.serializer.ruleMatchesToJson(this.matches, "This\ris an text.", 5, lang);
        Assert.assertTrue((boolean)json.contains("This\\ris ..."));
    }

    static class FakeRule
    extends Rule {
        FakeRule() {
            this.setLocQualityIssueType(ITSIssueType.Addition);
            this.setUrl(Tools.getUrl((String)"http://foobar.org/blah"));
        }

        public String getId() {
            return "FAKE_ID";
        }

        public String getDescription() {
            return "My rule description";
        }

        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new RuntimeException("not implemented");
        }
    }
}

