/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.resources;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.plus.resources.ResourceManager;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IncrementalChangesManager {
    private static final String URL = "http://download.osmand.net/check_live.php";
    private static final Log log = PlatformUtil.getLog(IncrementalChangesManager.class);
    private ResourceManager resourceManager;
    private final Map<String, RegionUpdateFiles> regions = new ConcurrentHashMap<String, RegionUpdateFiles>();

    public IncrementalChangesManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public List<File> collectChangesFiles(File dir, String ext, List<File> files) {
        if (dir.exists() && dir.canRead()) {
            File[] lf = dir.listFiles();
            if (lf == null || lf.length == 0) {
                return files;
            }
            HashSet<String> existingFiles = new HashSet<String>();
            for (File f : files) {
                if (f.getName().endsWith(".wiki.obf") || f.getName().endsWith(".srtm.obf")) continue;
                existingFiles.add(Algorithms.getFileNameWithoutExtension(f));
            }
            for (File f : lf) {
                String nm;
                String index;
                if (!f.getName().endsWith(ext) || (index = Algorithms.getFileNameWithoutExtension(f)).length() < 9 && index.charAt(index.length() - 9) == '_' || !existingFiles.contains(nm = index.substring(0, index.length() - 9))) continue;
                files.add(f);
            }
        }
        return files;
    }

    public void indexMainMap(File f, long dateCreated) {
        ArrayList<String> list;
        String nm = Algorithms.getFileNameWithoutExtension(f).toLowerCase();
        if (!this.regions.containsKey(nm)) {
            this.regions.put(nm, new RegionUpdateFiles(nm));
        }
        RegionUpdateFiles regionUpdateFiles = this.regions.get(nm);
        regionUpdateFiles.mainFile = f;
        regionUpdateFiles.mainFileInit = dateCreated;
        if (!regionUpdateFiles.monthUpdates.isEmpty()) {
            list = new ArrayList<String>(regionUpdateFiles.monthUpdates.keySet());
            for (String month : list) {
                RegionUpdate ru = regionUpdateFiles.monthUpdates.get(month);
                if (ru.obfCreated >= dateCreated) continue;
                log.info((Object)("Delete overlapping month update " + ru.file.getName()));
                this.resourceManager.closeFile(ru.file.getName());
                regionUpdateFiles.monthUpdates.remove(month);
                ru.file.delete();
                log.info((Object)("Delete overlapping month update " + ru.file.getName()));
            }
        }
        if (!regionUpdateFiles.dayUpdates.isEmpty()) {
            list = new ArrayList<String>(regionUpdateFiles.dayUpdates.keySet());
            for (String month : list) {
                Iterator<RegionUpdate> it = regionUpdateFiles.dayUpdates.get(month).iterator();
                RegionUpdate monthRu = regionUpdateFiles.monthUpdates.get(month);
                while (it.hasNext()) {
                    RegionUpdate ru = it.next();
                    if (ru.obfCreated >= dateCreated && (monthRu == null || ru.obfCreated >= monthRu.obfCreated)) continue;
                    log.info((Object)("Delete overlapping day update " + ru.file.getName()));
                    this.resourceManager.closeFile(ru.file.getName());
                    it.remove();
                    ru.file.delete();
                    log.info((Object)("Delete overlapping day update " + ru.file.getName()));
                }
            }
        }
    }

    public boolean index(File f, long dateCreated, BinaryMapIndexReader mapReader) {
        String index = Algorithms.getFileNameWithoutExtension(f).toLowerCase();
        if (index.length() <= 9 || index.charAt(index.length() - 9) != '_') {
            return false;
        }
        String nm = index.substring(0, index.length() - 9);
        String date = index.substring(index.length() - 9 + 1);
        if (!this.regions.containsKey(nm)) {
            this.regions.put(nm, new RegionUpdateFiles(nm));
        }
        RegionUpdateFiles regionUpdateFiles = this.regions.get(nm);
        return regionUpdateFiles.addUpdate(date, f, dateCreated);
    }

    protected static String formatSize(long vl) {
        return (float)(vl * 1000L / 0x100000L) / 1000.0f + "";
    }

    public static long calculateSize(List<IncrementalUpdate> list) {
        long l = 0L;
        for (IncrementalUpdate iu : list) {
            l += iu.containerSize;
        }
        return l;
    }

    private List<IncrementalUpdate> getIncrementalUpdates(String file, long timestamp) throws IOException, XmlPullParserException {
        String url = "http://download.osmand.net/check_live.php?timestamp=" + timestamp + "&file=" + URLEncoder.encode(file);
        HttpURLConnection conn = NetworkUtils.getHttpURLConnection(url);
        XmlPullParser parser = PlatformUtil.newXMLPullParser();
        parser.setInput(conn.getInputStream(), "UTF-8");
        ArrayList<IncrementalUpdate> lst = new ArrayList<IncrementalUpdate>();
        while (parser.next() != 1) {
            if (parser.getEventType() != 2 || !parser.getName().equals("update")) continue;
            IncrementalUpdate dt = new IncrementalUpdate();
            dt.date = parser.getAttributeValue("", "updateDate");
            dt.containerSize = Long.parseLong(parser.getAttributeValue("", "containerSize"));
            dt.contentSize = Long.parseLong(parser.getAttributeValue("", "contentSize"));
            dt.sizeText = parser.getAttributeValue("", "size");
            dt.timestamp = Long.parseLong(parser.getAttributeValue("", "timestamp"));
            dt.fileName = parser.getAttributeValue("", "name");
            lst.add(dt);
        }
        return lst;
    }

    public IncrementalUpdateList getUpdatesByMonth(String fileName) {
        RegionUpdateFiles ruf;
        IncrementalUpdateList iul = new IncrementalUpdateList();
        iul.updateFiles = ruf = this.regions.get(fileName.toLowerCase());
        if (ruf == null) {
            iul.errorMessage = "no_updates_available";
            return iul;
        }
        long timestamp = this.getTimestamp(ruf);
        try {
            List<IncrementalUpdate> lst = this.getIncrementalUpdates(fileName, timestamp);
            for (IncrementalUpdate iu : lst) {
                iul.addUpdate(iu);
            }
        }
        catch (Exception e) {
            iul.errorMessage = e.getMessage();
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return iul;
    }

    public long getUpdatesSize(String fileName) {
        RegionUpdateFiles ruf = this.regions.get(fileName.toLowerCase());
        if (ruf == null) {
            return 0L;
        }
        long size = 0L;
        for (List<RegionUpdate> regionUpdates : ruf.dayUpdates.values()) {
            for (RegionUpdate regionUpdate : regionUpdates) {
                size += regionUpdate.file.length();
            }
        }
        for (RegionUpdate regionUpdate : ruf.monthUpdates.values()) {
            size += regionUpdate.file.length();
        }
        return size;
    }

    public void deleteUpdates(String fileName) {
        RegionUpdateFiles ruf = this.regions.get(fileName.toLowerCase());
        if (ruf == null) {
            return;
        }
        for (List<RegionUpdate> regionUpdates : ruf.dayUpdates.values()) {
            for (RegionUpdate regionUpdate : regionUpdates) {
                boolean successful = Algorithms.removeAllFiles(regionUpdate.file);
                if (!successful) continue;
                this.resourceManager.closeFile(regionUpdate.file.getName());
            }
        }
        for (RegionUpdate regionUpdate : ruf.monthUpdates.values()) {
            boolean successful = Algorithms.removeAllFiles(regionUpdate.file);
            if (!successful) continue;
            this.resourceManager.closeFile(regionUpdate.file.getName());
        }
    }

    public long getTimestamp(String fileName) {
        RegionUpdateFiles ruf = this.regions.get(fileName.toLowerCase());
        if (ruf == null) {
            return System.currentTimeMillis();
        }
        return this.getTimestamp(ruf);
    }

    public long getMapTimestamp(String fileName) {
        RegionUpdateFiles ruf = this.regions.get(fileName.toLowerCase());
        if (ruf == null) {
            return System.currentTimeMillis();
        }
        return ruf.mainFileInit;
    }

    private long getTimestamp(RegionUpdateFiles ruf) {
        long timestamp = ruf.mainFileInit;
        for (RegionUpdate regionUpdate : ruf.monthUpdates.values()) {
            timestamp = Math.max(regionUpdate.obfCreated, timestamp);
        }
        for (List list : ruf.dayUpdates.values()) {
            for (RegionUpdate ru : list) {
                timestamp = Math.max(ru.obfCreated, timestamp);
            }
        }
        return timestamp;
    }

    public static class IncrementalUpdate {
        String date = "";
        public long timestamp;
        public String sizeText = "";
        public long containerSize;
        public long contentSize;
        public String fileName;

        public boolean isMonth() {
            return this.date.endsWith("00");
        }

        public String toString() {
            return "Update " + this.fileName + " " + this.sizeText + " MB " + this.date;
        }
    }

    protected static class IncrementalUpdateGroupByMonth {
        public final String monthYearPart;
        public List<IncrementalUpdate> dayUpdates = new ArrayList<IncrementalUpdate>();
        public IncrementalUpdate monthUpdate;

        public long calculateSizeMonthUpdates() {
            return IncrementalChangesManager.calculateSize(this.getMonthUpdate());
        }

        public long calculateSizeDayUpdates() {
            return IncrementalChangesManager.calculateSize(this.getDayUpdates());
        }

        public boolean isMonthUpdateApplicable() {
            return this.monthUpdate != null;
        }

        public boolean isDayUpdateApplicable() {
            boolean inLimits;
            boolean bl = inLimits = this.dayUpdates.size() > 0 && this.dayUpdates.size() < 4;
            return inLimits;
        }

        public List<IncrementalUpdate> getMonthUpdate() {
            ArrayList<IncrementalUpdate> ll = new ArrayList<IncrementalUpdate>();
            if (this.monthUpdate == null) {
                return ll;
            }
            ll.add(this.monthUpdate);
            for (IncrementalUpdate iu : this.dayUpdates) {
                if (iu.timestamp <= this.monthUpdate.timestamp) continue;
                ll.add(iu);
            }
            return ll;
        }

        public List<IncrementalUpdate> getDayUpdates() {
            return this.dayUpdates;
        }

        public IncrementalUpdateGroupByMonth(String monthYearPart) {
            this.monthYearPart = monthYearPart;
        }
    }

    public class IncrementalUpdateList {
        public TreeMap<String, IncrementalUpdateGroupByMonth> updateByMonth = new TreeMap();
        public String errorMessage;
        public RegionUpdateFiles updateFiles;

        public boolean isPreferrableLimitForDayUpdates(String monthYearPart, List<IncrementalUpdate> dayUpdates) {
            List<RegionUpdate> lst = this.updateFiles.dayUpdates.get(monthYearPart);
            return lst == null || lst.size() < 10;
        }

        public List<IncrementalUpdate> getItemsForUpdate() {
            Iterator<IncrementalUpdateGroupByMonth> it = this.updateByMonth.values().iterator();
            ArrayList<IncrementalUpdate> ll = new ArrayList<IncrementalUpdate>();
            while (it.hasNext()) {
                IncrementalUpdateGroupByMonth n = it.next();
                if (it.hasNext()) {
                    if (!n.isMonthUpdateApplicable()) {
                        return null;
                    }
                    ll.addAll(n.getMonthUpdate());
                    continue;
                }
                if (n.isDayUpdateApplicable() && this.isPreferrableLimitForDayUpdates(n.monthYearPart, n.getDayUpdates())) {
                    ll.addAll(n.getDayUpdates());
                    continue;
                }
                if (n.isMonthUpdateApplicable()) {
                    ll.addAll(n.getMonthUpdate());
                    continue;
                }
                return null;
            }
            return ll;
        }

        public void addUpdate(IncrementalUpdate iu) {
            String dtMonth = iu.date.substring(0, 5);
            if (!this.updateByMonth.containsKey(dtMonth)) {
                IncrementalUpdateGroupByMonth iubm = new IncrementalUpdateGroupByMonth(dtMonth);
                this.updateByMonth.put(dtMonth, iubm);
            }
            IncrementalUpdateGroupByMonth mm = this.updateByMonth.get(dtMonth);
            if (iu.isMonth()) {
                mm.monthUpdate = iu;
            } else {
                mm.dayUpdates.add(iu);
            }
        }
    }

    protected class RegionUpdateFiles {
        protected String nm;
        protected File mainFile;
        protected long mainFileInit;
        TreeMap<String, List<RegionUpdate>> dayUpdates = new TreeMap();
        TreeMap<String, RegionUpdate> monthUpdates = new TreeMap();

        public RegionUpdateFiles(String nm) {
            this.nm = nm;
        }

        public boolean addUpdate(String date, File file, long dateCreated) {
            String monthYear = date.substring(0, 5);
            RegionUpdate ru = new RegionUpdate();
            ru.date = date;
            ru.file = file;
            ru.obfCreated = dateCreated;
            if (date.endsWith("00")) {
                this.monthUpdates.put(monthYear, ru);
            } else {
                if (!this.dayUpdates.containsKey(monthYear)) {
                    this.dayUpdates.put(monthYear, new ArrayList());
                }
                this.dayUpdates.get(monthYear).add(ru);
            }
            return true;
        }
    }

    protected class RegionUpdate {
        protected File file;
        protected String date;
        protected long obfCreated;

        protected RegionUpdate() {
        }
    }
}

