/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc.mappers;

import java.io.File;
import java.nio.file.Path;
import sbt.internal.inc.Stamper$;
import sbt.internal.inc.mappers.MapperUtils;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import xsbti.compile.analysis.Stamp;

public final class MapperUtils$ {
    public static MapperUtils$ MODULE$;
    private final int MARKER_LENGTH;

    static {
        new MapperUtils$();
    }

    public File rebase(File target, Path from, Path to) {
        return to.resolve(from.relativize(target.toPath())).toFile();
    }

    private final String RELATIVE_MARKER() {
        return "\u2603\u2603\u2603";
    }

    private final int MARKER_LENGTH() {
        return this.MARKER_LENGTH;
    }

    private final String relativeReadError(String path) {
        return new StringBuilder(89).append("Unexpected path ").append(path).append(" was not written by a relative write mapper. Paths have to start with ").append("\u2603\u2603\u2603").toString();
    }

    public File makeRelative(File file, Path from) {
        Path relativePath = from.relativize(file.toPath());
        return new File(new StringBuilder(3).append("\u2603\u2603\u2603").append(relativePath).toString());
    }

    public File reconstructRelative(File file, Path from) {
        String filePath = ((Object)file.toPath()).toString();
        if (!filePath.startsWith("\u2603\u2603\u2603")) {
            throw new MapperUtils.RelativePathAssumptionBroken(this.relativeReadError(filePath));
        }
        String cleanPath = (String)new StringOps(Predef$.MODULE$.augmentString(filePath)).drop(this.MARKER_LENGTH());
        return from.resolve(cleanPath).toFile();
    }

    public Stamp recomputeModificationDate(File previouslyStampedFile) {
        return (Stamp)Stamper$.MODULE$.forLastModified().apply((Object)previouslyStampedFile);
    }

    private MapperUtils$() {
        MODULE$ = this;
        this.MARKER_LENGTH = "\u2603\u2603\u2603".length();
    }
}

