/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.KeyStroke;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.util.Utilities;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeanConverter {
    private Bean<? extends DataObject> bean;
    private Document document;

    public BeanConverter(Bean<? extends DataObject> bean, Document document) {
        this.document = document;
        this.bean = bean;
    }

    public Element createElement(String name) {
        Element root = this.document.createElement(name);
        for (PropertyDescriptor property : this.bean.getProperties()) {
            root.appendChild(this.convertProperty(property));
        }
        return root;
    }

    public void setValues(Element root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            this.setElementValue((Element)children.item(i));
        }
    }

    private Element convertProperty(PropertyDescriptor property) {
        Element elem = this.document.createElement("property");
        elem.setAttribute("name", property.getName());
        Object value = this.bean.getValue(property.getName());
        if (value instanceof String) {
            CDATASection cdata = this.document.createCDATASection((String)value);
            elem.appendChild(cdata);
        } else if (value instanceof String[]) {
            CDATASection cdata = this.document.createCDATASection(Utilities.join(";;", (String[])value));
            elem.appendChild(cdata);
        } else if (value instanceof Integer) {
            elem.setAttribute("value", value.toString());
        } else if (value instanceof Boolean) {
            elem.setAttribute("value", value.toString());
        } else if (value instanceof Font) {
            Font font = (Font)value;
            elem.setAttribute("family", font.getFamily());
            elem.setAttribute("style", String.valueOf(font.getStyle()));
            elem.setAttribute("size", String.valueOf(font.getSize()));
        } else if (value instanceof File) {
            elem.setAttribute("value", ((File)value).getAbsolutePath());
        } else if (value instanceof File[]) {
            ArrayList<String> strings = new ArrayList<String>();
            for (File file : (File[])value) {
                strings.add(file.getAbsolutePath());
            }
            CDATASection cdata = this.document.createCDATASection(Utilities.join(";;", strings.toArray(new String[strings.size()])));
            elem.appendChild(cdata);
        } else if (value instanceof KeyStroke) {
            elem.setAttribute("value", value.toString());
        } else if (value instanceof Color) {
            elem.setAttribute("value", "" + ((Color)value).getRGB());
        } else if (value instanceof Date) {
            elem.setAttribute("value", "" + ((Date)value).getTime());
        } else {
            throw new IllegalArgumentException("unknown property type: " + value.getClass().getName());
        }
        return elem;
    }

    private void setElementValue(Element element) {
        String name = element.getAttribute("name");
        PropertyDescriptor property = this.bean.getProperty(name);
        if (property == null) {
            System.err.println("Warning: " + name + " is not a property");
        } else {
            Object value = null;
            Class<?> type = property.getPropertyType();
            if (type.equals(String.class)) {
                value = element.getTextContent();
            } else if (type.equals(String[].class)) {
                String text = element.getTextContent();
                value = text.split(";;");
            } else if (type.equals(Integer.TYPE)) {
                value = BeanConverter.parseInt(element.getAttribute("value"));
            } else if (type.equals(Boolean.TYPE)) {
                value = BeanConverter.parseBool(element.getAttribute("value"));
            } else if (type.equals(Font.class)) {
                String family = element.getAttribute("family");
                int style = BeanConverter.parseInt(element.getAttribute("style"));
                int size = BeanConverter.parseInt(element.getAttribute("size"));
                if (size == 0) {
                    size = 12;
                }
                value = new Font(family, style, size);
            } else if (type.equals(File.class)) {
                String fileName = element.getAttribute("value");
                value = new File(fileName);
            } else if (type.equals(File[].class)) {
                String text = element.getTextContent().trim();
                if (text.length() == 0) {
                    value = new File[]{};
                } else {
                    String[] strings = element.getTextContent().split(";;");
                    File[] files = new File[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        files[i] = new File(strings[i]);
                    }
                    value = files;
                }
            } else if (type.equals(KeyStroke.class)) {
                String keyStrokeDescription = element.getAttribute("value");
                value = KeyStroke.getKeyStroke(keyStrokeDescription);
            } else if (type.equals(Color.class)) {
                String rgb = element.getAttribute("value");
                value = new Color(Integer.parseInt(rgb));
            } else if (type.equals(Date.class)) {
                String time = element.getAttribute("value");
                value = new Date(Long.parseLong(time));
            }
            if (value == null) {
                System.err.println("Warning: a value for property " + name + " could not be created");
            } else {
                this.bean.setValue(property, value);
            }
        }
    }

    private static int parseInt(String string) {
        int number = 0;
        try {
            number = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    private static boolean parseBool(String string) {
        boolean value = false;
        try {
            value = Boolean.valueOf(string);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return value;
    }
}

