/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.zeroc.IceGridGUI.LiveDeployment.ShowIceLogDialog;
import com.zeroc.IceGridGUI.LiveDeployment.ShowLogFileDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

class LogPrefsDialog
extends JDialog {
    LogPrefsDialog(final ShowLogFileDialog dialog) {
        super(dialog, "Preferences - IceGrid GUI", true);
        this.setDefaultCloseOperation(2);
        final JTextField maxLinesField = new JTextField(10);
        maxLinesField.setText(Integer.toString(dialog.getMaxLines()));
        maxLinesField.setToolTipText("Maximum number of lines in this dialog's buffer");
        final JTextField maxSizeField = new JTextField(10);
        maxSizeField.setText(Integer.toString(dialog.getMaxSize()));
        maxSizeField.setToolTipText("Maximum number of characters in this dialog's buffer");
        final JTextField initialLinesField = new JTextField(10);
        initialLinesField.setText(Integer.toString(dialog.getInitialLines()));
        initialLinesField.setToolTipText("Start by retrieving <num> lines from the server; -1 means retrieve all");
        final JTextField maxReadSizeField = new JTextField(10);
        maxReadSizeField.setText(Integer.toString(dialog.getMaxReadSize()));
        maxReadSizeField.setToolTipText("Maximum number of bytes read by each request");
        final JTextField periodField = new JTextField(10);
        periodField.setText(Float.toString((float)dialog.getPeriod() / 1000.0f));
        periodField.setToolTipText("After reaching EOF, check every <num> seconds for new output");
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int maxLines = LogPrefsDialog.this.parseInt(maxLinesField, "Max lines in buffer");
                    int maxSize = LogPrefsDialog.this.parseInt(maxSizeField, "Max characters in buffer");
                    int initialLines = LogPrefsDialog.this.parseInt(initialLinesField, "Number of lines retrieved initially");
                    int maxReadSize = LogPrefsDialog.this.parseInt(maxReadSizeField, "Max bytes read per request");
                    int period = (int)(LogPrefsDialog.this.parseFloat(periodField, "Poll period (seconds)") * 1000.0f);
                    dialog.setPrefs(maxLines, maxSize, initialLines, maxReadSize, period);
                    LogPrefsDialog.this.dispose();
                }
                catch (NumberFormatException ex) {
                    return;
                }
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPrefsDialog.this.dispose();
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("left:pref, 3dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border((Border)Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.append("Max lines in buffer", (Component)maxLinesField);
        builder.nextLine();
        builder.append("Max characters in buffer", (Component)maxSizeField);
        builder.nextLine();
        builder.append("Number of lines retrieved initially", (Component)initialLinesField);
        builder.nextLine();
        builder.append("Max bytes read per request", (Component)maxReadSizeField);
        builder.nextLine();
        builder.append("Poll period (seconds)", (Component)periodField);
        builder.nextLine();
        JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{okButton, cancelButton}).build();
        buttonBar.setBorder((Border)Borders.DIALOG);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    LogPrefsDialog(final ShowIceLogDialog dialog) {
        super(dialog, "Preferences - IceGrid GUI", true);
        this.setDefaultCloseOperation(2);
        final JTextField maxMessagesField = new JTextField(10);
        maxMessagesField.setText(Integer.toString(dialog.getMaxMessages()));
        maxMessagesField.setToolTipText("Maximum number of log messages to keep in this dialog's buffer");
        final JTextField initialMessagesField = new JTextField(10);
        initialMessagesField.setText(Integer.toString(dialog.getInitialMessages()));
        initialMessagesField.setToolTipText("Start by retrieving <num> log messages from the server; -1 means retrieve all");
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int maxMessages = LogPrefsDialog.this.parseInt(maxMessagesField, "Max log messages in buffer");
                    int initialMessages = LogPrefsDialog.this.parseInt(initialMessagesField, "Number of log messages retrieved initially");
                    dialog.setPrefs(maxMessages, initialMessages);
                    LogPrefsDialog.this.dispose();
                }
                catch (NumberFormatException ex) {
                    return;
                }
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogPrefsDialog.this.dispose();
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("left:pref, 3dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.border((Border)Borders.DIALOG);
        builder.rowGroupingEnabled(true);
        builder.lineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.append("Max log messages in buffer", (Component)maxMessagesField);
        builder.nextLine();
        builder.append("Number of log messages retrieved initially", (Component)initialMessagesField);
        builder.nextLine();
        JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{okButton, cancelButton}).build();
        buttonBar.setBorder((Border)Borders.DIALOG);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(dialog);
        this.setVisible(true);
    }

    private int parseInt(JTextField field, String label) throws NumberFormatException {
        try {
            return Integer.parseInt(field.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, label + " must be an integer", "Invalid entry", 0);
            throw e;
        }
    }

    private float parseFloat(JTextField field, String label) throws NumberFormatException {
        try {
            return Float.parseFloat(field.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, label + " must be a decimal number", "Invalid entry", 0);
            throw e;
        }
    }
}

