/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SharedGroupState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Link;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;

public class LinkState
extends LeafState {
    private int sharedGroup;
    private SymbolTableData sharedGroupSymbol;

    public LinkState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            SharedGroup sharedGroup = ((Link)this.node).getSharedGroup();
            this.sharedGroup = controller.getSymbolTable().addReference((SceneGraphObject)sharedGroup);
            this.sharedGroupSymbol = controller.getSymbolTable().getSymbol(this.sharedGroup);
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        if (this.sharedGroupSymbol.nodeState == null) {
            dataOutput.writeInt(-1);
            SharedGroup sharedGroup = ((Link)this.node).getSharedGroup();
            this.control.writeSharedGroup(dataOutput, sharedGroup, this.sharedGroupSymbol);
        } else {
            dataOutput.writeInt(this.sharedGroupSymbol.nodeID);
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.sharedGroup = dataInput.readInt();
        if (this.sharedGroup == -1) {
            this.sharedGroup = this.control.readSharedGroup(dataInput);
        }
    }

    public void buildGraph() {
        this.sharedGroupSymbol = this.control.getSymbolTable().getSymbol(this.sharedGroup);
        ((SharedGroupState)this.sharedGroupSymbol.nodeState).buildGraph();
        ((Link)this.node).setSharedGroup((SharedGroup)this.sharedGroupSymbol.j3dNode);
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Link();
    }
}

