/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.OBJMaterial;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

public class OBJWriter
extends FilterWriter {
    private final NumberFormat defaultNumberFormat = new DecimalFormat("0.#######", new DecimalFormatSymbols(Locale.US));
    private final NumberFormat numberFormat;
    private final String header;
    private boolean firstNode = true;
    private String mtlFileName;
    private int shapeIndex = 1;
    private Map<Point3f, Integer> vertexIndices = new HashMap<Point3f, Integer>();
    private Map<Vector3f, Integer> normalIndices = new HashMap<Vector3f, Integer>();
    private Map<TexCoord2f, Integer> textureCoordinatesIndices = new HashMap<TexCoord2f, Integer>();
    private Map<ComparableAppearance, String> appearances = new LinkedHashMap<ComparableAppearance, String>();
    private Map<Texture, File> textures = new HashMap<Texture, File>();
    private List<URL> copiedTextures = new ArrayList<URL>();

    public OBJWriter(File file) throws FileNotFoundException, IOException {
        this(file, null, -1);
    }

    public OBJWriter(File file, String string, int n) throws FileNotFoundException, IOException {
        this(file.toString(), string, n);
    }

    public OBJWriter(String string) throws FileNotFoundException, IOException {
        this(string, null, -1);
    }

    public OBJWriter(String string, String string2, int n) throws FileNotFoundException, IOException {
        this(new FileOutputStream(string), string2, n);
        this.mtlFileName = string.toLowerCase().endsWith(".obj") ? string.substring(0, string.length() - 4) + ".mtl" : string + ".mtl";
        this.mtlFileName = new File(new File(this.mtlFileName).getParent(), new File(this.mtlFileName).getName().replace(' ', '_')).toString();
        String string3 = new File(this.mtlFileName).getName();
        for (int i = 0; i < string3.length(); ++i) {
            if (string3.charAt(i) < '\u0080') continue;
            this.mtlFileName = new File(new File(this.mtlFileName).getParent(), "materials.mtl").toString();
            break;
        }
    }

    public OBJWriter(OutputStream outputStream) throws IOException {
        this(outputStream, null, -1);
    }

    public OBJWriter(OutputStream outputStream, String string, int n) throws IOException {
        this(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), "US-ASCII"), string, n);
    }

    public OBJWriter(Writer writer) throws IOException {
        this(writer, null, -1);
    }

    public OBJWriter(Writer writer, String string, int n) throws IOException {
        super(writer);
        if (n >= 0) {
            this.numberFormat = NumberFormat.getNumberInstance(Locale.US);
            this.numberFormat.setMinimumFractionDigits(0);
            this.numberFormat.setMaximumFractionDigits(n);
        } else {
            this.numberFormat = null;
        }
        this.header = string;
        this.writeHeader(this.out);
    }

    private void writeHeader(Writer writer) throws IOException {
        if (this.header != null) {
            if (!this.header.startsWith("#")) {
                writer.write("# ");
            }
            writer.write(this.header.replace("\n", "\n# "));
            writer.write("\n");
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write("# ");
        this.out.write(n);
        this.out.write("\n");
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.out.write("# ");
        this.out.write(cArray, n, n2);
        this.out.write("\n");
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        this.out.write("# ");
        this.out.write(string, n, n2);
        this.out.write("\n");
    }

    @Override
    public void write(String string) throws IOException {
        this.out.write("# ");
        this.out.write(string, 0, string.length());
        this.out.write("\n");
    }

    private void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            this.mtlFileName = null;
            throw new InterruptedIOException("Current thread interrupted");
        }
    }

    public void writeNode(Node node) throws IOException, InterruptedIOException {
        this.writeNode(node, null);
    }

    public void writeNode(Node node, String string) throws IOException, InterruptedIOException {
        if (this.firstNode) {
            if (this.mtlFileName != null) {
                this.out.write("mtllib " + new File(this.mtlFileName).getName() + "\n");
            }
            this.firstNode = false;
        }
        this.writeNode(node, string, new Transform3D());
    }

    private void writeNode(Node node, String string, Transform3D transform3D) throws IOException {
        block23: {
            RenderingAttributes renderingAttributes;
            block24: {
                block22: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block22;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.writeNode((Node)enumeration.nextElement(), string, transform3D);
                    }
                    break block23;
                }
                if (!(node instanceof Link)) break block24;
                this.writeNode((Node)((Link)node).getSharedGroup(), string, transform3D);
                break block23;
            }
            if (!(node instanceof Shape3D)) break block23;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes2 = renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            if (shape3D.numGeometries() >= 1 && (renderingAttributes == null || renderingAttributes.getVisible())) {
                Object object;
                String string2 = "";
                if (this.accept(string)) {
                    string2 = string + "_";
                }
                String string3 = null;
                if (shape3D.getUserData() instanceof String) {
                    string3 = (String)shape3D.getUserData();
                }
                if (this.accept(string3)) {
                    string2 = string2 + string3 + "_";
                }
                string2 = string2 + String.valueOf(this.shapeIndex++);
                this.out.write("g " + string2 + "\n");
                TexCoordGeneration texCoordGeneration = null;
                Transform3D transform3D2 = new Transform3D();
                if (this.mtlFileName != null && appearance != null) {
                    ComparableAppearance comparableAppearance;
                    texCoordGeneration = appearance.getTexCoordGeneration();
                    TextureAttributes textureAttributes = appearance.getTextureAttributes();
                    if (textureAttributes != null) {
                        textureAttributes.getTextureTransform(transform3D2);
                    }
                    if ((object = this.appearances.get(comparableAppearance = new ComparableAppearance(appearance))) == null) {
                        Object object2;
                        Texture texture;
                        try {
                            object = appearance.getName();
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        if (object == null || !this.accept((String)object)) {
                            object = string2;
                        } else {
                            texture = this.appearances.values();
                            object2 = (String)object + "_" + string2;
                            int n = 0;
                            while (texture.contains(object)) {
                                object = n == 0 ? object2 : (String)object2 + "_" + n;
                                ++n;
                            }
                        }
                        this.appearances.put(comparableAppearance, (String)object);
                        texture = appearance.getTexture();
                        if (texture != null && (object2 = this.textures.get(texture)) == null) {
                            String string4;
                            block21: {
                                string4 = "png";
                                URL uRL = (URL)texture.getUserData();
                                if (uRL instanceof URL) {
                                    InputStream inputStream = null;
                                    try {
                                        inputStream = this.openStream(uRL);
                                        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                                        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                                        if (iterator.hasNext()) {
                                            ImageReader imageReader = iterator.next();
                                            string4 = imageReader.getFormatName().toLowerCase();
                                            this.copiedTextures.add(uRL);
                                        }
                                    }
                                    catch (IOException iOException) {
                                        if (inputStream == null) break block21;
                                        inputStream.close();
                                    }
                                }
                            }
                            object2 = new File(this.mtlFileName.substring(0, this.mtlFileName.length() - 4) + "_" + (String)object + "." + string4);
                            this.textures.put(texture, (File)object2);
                        }
                    }
                    this.out.write("usemtl " + (String)object + "\n");
                }
                int n = 1;
                boolean bl = false;
                if (appearance != null && (object = appearance.getPolygonAttributes()) != null) {
                    n = object.getCullFace();
                    bl = object.getBackFaceNormalFlip();
                }
                int n2 = shape3D.numGeometries();
                for (int i = 0; i < n2; ++i) {
                    this.writeNodeGeometry(shape3D.getGeometry(i), transform3D, texCoordGeneration, transform3D2, n, bl);
                }
            }
        }
    }

    private InputStream openStream(URL uRL) throws IOException {
        JarURLConnection jarURLConnection;
        URL uRL2;
        URLConnection uRLConnection = uRL.openConnection();
        if (System.getProperty("os.name").startsWith("Windows") && uRLConnection instanceof JarURLConnection && (uRL2 = (jarURLConnection = (JarURLConnection)uRLConnection).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
            try {
                if (new File(uRL2.toURI()).canWrite()) {
                    uRLConnection.setUseCaches(false);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                IOException iOException = new IOException();
                iOException.initCause(uRISyntaxException);
                throw iOException;
            }
        }
        return uRLConnection.getInputStream();
    }

    private boolean accept(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            return false;
        }
        return true;
    }

    private void writeNodeGeometry(Geometry geometry, Transform3D transform3D, TexCoordGeneration texCoordGeneration, Transform3D transform3D2, int n, boolean bl) throws IOException {
        block73: {
            int n2;
            int n3;
            int n4;
            int n5;
            boolean bl2;
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            boolean bl3;
            int[] nArray4;
            GeometryArray geometryArray;
            block74: {
                int[] nArray5;
                IndexedGeometryStripArray indexedGeometryStripArray;
                block79: {
                    block78: {
                        block77: {
                            block76: {
                                block75: {
                                    ArrayList<Vector3f> arrayList;
                                    StringBuilder stringBuilder;
                                    if (!(geometry instanceof GeometryArray)) break block73;
                                    geometryArray = (GeometryArray)geometry;
                                    nArray4 = new int[geometryArray.getVertexCount()];
                                    boolean bl4 = bl3 = (geometryArray.getVertexFormat() & 2) != 0;
                                    if (bl3) {
                                        stringBuilder = new StringBuilder(geometryArray.getVertexCount() * 3 * 10);
                                        arrayList = new ArrayList<Vector3f>();
                                    } else {
                                        stringBuilder = null;
                                        arrayList = null;
                                    }
                                    nArray3 = new int[geometryArray.getVertexCount()];
                                    nArray2 = n == 0 ? new int[geometryArray.getVertexCount()] : null;
                                    boolean bl5 = (geometryArray.getVertexFormat() & 0x20) != 0;
                                    nArray = new int[geometryArray.getVertexCount()];
                                    bl2 = false;
                                    Vector4f vector4f = null;
                                    Vector4f vector4f2 = null;
                                    if (texCoordGeneration != null) {
                                        boolean bl6 = bl2 = texCoordGeneration.getGenMode() == 0 && texCoordGeneration.getEnable() && !(geometryArray instanceof IndexedLineArray) && !(geometryArray instanceof IndexedLineStripArray) && !(geometryArray instanceof LineArray) && !(geometryArray instanceof LineStripArray);
                                        if (bl2) {
                                            vector4f = new Vector4f();
                                            vector4f2 = new Vector4f();
                                            texCoordGeneration.getPlaneS(vector4f);
                                            texCoordGeneration.getPlaneT(vector4f2);
                                        }
                                    }
                                    this.checkCurrentThreadIsntInterrupted();
                                    if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                                        Point3f point3f;
                                        if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                                            float[] fArray = geometryArray.getInterleavedVertices();
                                            n5 = fArray.length / geometryArray.getVertexCount();
                                            n4 = 0;
                                            n3 = n5 - 3;
                                            n2 = geometryArray.getVertexCount();
                                            while (n4 < n2) {
                                                point3f = new Point3f(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
                                                this.writeVertex(transform3D, point3f, n4, nArray4);
                                                ++n4;
                                                n3 += n5;
                                            }
                                            if (texCoordGeneration != null) {
                                                if (bl2) {
                                                    n4 = 0;
                                                    n3 = n5 - 3;
                                                    n2 = geometryArray.getVertexCount();
                                                    while (n4 < n2) {
                                                        point3f = this.generateTextureCoordinates(fArray[n3], fArray[n3 + 1], fArray[n3 + 2], vector4f, vector4f2);
                                                        this.writeTextureCoordinates((TexCoord2f)point3f, transform3D2, n4, nArray);
                                                        ++n4;
                                                        n3 += n5;
                                                    }
                                                }
                                            } else if (bl5) {
                                                n4 = 0;
                                                n3 = 0;
                                                n2 = geometryArray.getVertexCount();
                                                while (n4 < n2) {
                                                    point3f = new TexCoord2f(fArray[n3], fArray[n3 + 1]);
                                                    this.writeTextureCoordinates((TexCoord2f)point3f, transform3D2, n4, nArray);
                                                    ++n4;
                                                    n3 += n5;
                                                }
                                            }
                                            if (bl3) {
                                                n4 = 0;
                                                n3 = n5 - 6;
                                                n2 = geometryArray.getVertexCount();
                                                while (bl3 && n4 < n2) {
                                                    point3f = new Vector3f(fArray[n3], fArray[n3 + 1], fArray[n3 + 2]);
                                                    bl3 = this.writeNormal(stringBuilder, transform3D, (Vector3f)point3f, n4, nArray3, nArray2, arrayList, n, bl);
                                                    ++n4;
                                                    n3 += n5;
                                                }
                                            }
                                        } else {
                                            Point3f point3f2;
                                            float[] fArray = geometryArray.getCoordRefFloat();
                                            int n6 = 0;
                                            int n7 = 0;
                                            int n8 = geometryArray.getVertexCount();
                                            while (n6 < n8) {
                                                point3f2 = new Point3f(fArray[n7], fArray[n7 + 1], fArray[n7 + 2]);
                                                this.writeVertex(transform3D, point3f2, n6, nArray4);
                                                ++n6;
                                                n7 += 3;
                                            }
                                            if (texCoordGeneration != null) {
                                                if (bl2) {
                                                    n6 = 0;
                                                    n7 = 0;
                                                    n8 = geometryArray.getVertexCount();
                                                    while (n6 < n8) {
                                                        point3f2 = this.generateTextureCoordinates(fArray[n7], fArray[n7 + 1], fArray[n7 + 2], vector4f, vector4f2);
                                                        this.writeTextureCoordinates((TexCoord2f)point3f2, transform3D2, n6, nArray);
                                                        ++n6;
                                                        n7 += 3;
                                                    }
                                                }
                                            } else if (bl5) {
                                                float[] fArray2 = geometryArray.getTexCoordRefFloat(0);
                                                n7 = 0;
                                                n8 = 0;
                                                int n9 = geometryArray.getVertexCount();
                                                while (n7 < n9) {
                                                    point3f = new TexCoord2f(fArray2[n8], fArray2[n8 + 1]);
                                                    this.writeTextureCoordinates((TexCoord2f)point3f, transform3D2, n7, nArray);
                                                    ++n7;
                                                    n8 += 2;
                                                }
                                            }
                                            if (bl3) {
                                                float[] fArray3 = geometryArray.getNormalRefFloat();
                                                n7 = 0;
                                                n8 = 0;
                                                int n10 = geometryArray.getVertexCount();
                                                while (bl3 && n7 < n10) {
                                                    point3f = new Vector3f(fArray3[n8], fArray3[n8 + 1], fArray3[n8 + 2]);
                                                    bl3 = this.writeNormal(stringBuilder, transform3D, (Vector3f)point3f, n7, nArray3, nArray2, arrayList, n, bl);
                                                    ++n7;
                                                    n8 += 3;
                                                }
                                            }
                                        }
                                    } else {
                                        Point3f point3f;
                                        int n11;
                                        int n12 = geometryArray.getVertexCount();
                                        for (n11 = 0; n11 < n12; ++n11) {
                                            point3f = new Point3f();
                                            geometryArray.getCoordinate(n11, point3f);
                                            this.writeVertex(transform3D, point3f, n11, nArray4);
                                        }
                                        if (texCoordGeneration != null) {
                                            if (bl2) {
                                                n12 = geometryArray.getVertexCount();
                                                for (n11 = 0; n11 < n12; ++n11) {
                                                    point3f = new Point3f();
                                                    geometryArray.getCoordinate(n11, point3f);
                                                    TexCoord2f texCoord2f = this.generateTextureCoordinates(point3f.x, point3f.y, point3f.z, vector4f, vector4f2);
                                                    this.writeTextureCoordinates(texCoord2f, transform3D2, n11, nArray);
                                                }
                                            }
                                        } else if (bl5) {
                                            n12 = geometryArray.getVertexCount();
                                            for (n11 = 0; n11 < n12; ++n11) {
                                                point3f = new TexCoord2f();
                                                geometryArray.getTextureCoordinate(0, n11, (TexCoord2f)point3f);
                                                this.writeTextureCoordinates((TexCoord2f)point3f, transform3D2, n11, nArray);
                                            }
                                        }
                                        if (bl3) {
                                            n12 = geometryArray.getVertexCount();
                                            for (n11 = 0; bl3 && n11 < n12; ++n11) {
                                                point3f = new Vector3f();
                                                geometryArray.getNormal(n11, (Vector3f)point3f);
                                                bl3 = this.writeNormal(stringBuilder, transform3D, (Vector3f)point3f, n11, nArray3, nArray2, arrayList, n, bl);
                                            }
                                        }
                                    }
                                    if (bl3) {
                                        this.out.write(stringBuilder.toString());
                                    } else if (arrayList != null) {
                                        for (Vector3f vector3f : arrayList) {
                                            this.normalIndices.remove(vector3f);
                                        }
                                    }
                                    this.checkCurrentThreadIsntInterrupted();
                                    if (!(geometryArray instanceof IndexedGeometryArray)) break block74;
                                    if (!(geometryArray instanceof IndexedLineArray)) break block75;
                                    IndexedLineArray indexedLineArray = (IndexedLineArray)geometryArray;
                                    n4 = indexedLineArray.getIndexCount();
                                    for (n5 = 0; n5 < n4; n5 += 2) {
                                        this.writeIndexedLine((IndexedGeometryArray)indexedLineArray, n5, n5 + 1, nArray4, nArray);
                                    }
                                    break block73;
                                }
                                if (!(geometryArray instanceof IndexedTriangleArray)) break block76;
                                IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)geometryArray;
                                n4 = indexedTriangleArray.getIndexCount();
                                for (n5 = 0; n5 < n4; n5 += 3) {
                                    this.writeIndexedTriangle((IndexedGeometryArray)indexedTriangleArray, n5, n5 + 1, n5 + 2, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                                }
                                break block73;
                            }
                            if (!(geometryArray instanceof IndexedQuadArray)) break block77;
                            IndexedQuadArray indexedQuadArray = (IndexedQuadArray)geometryArray;
                            n4 = indexedQuadArray.getIndexCount();
                            for (n5 = 0; n5 < n4; n5 += 4) {
                                this.writeIndexedQuadrilateral((IndexedGeometryArray)indexedQuadArray, n5, n5 + 1, n5 + 2, n5 + 3, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                            }
                            break block73;
                        }
                        if (!(geometryArray instanceof IndexedGeometryStripArray)) break block73;
                        indexedGeometryStripArray = (IndexedGeometryStripArray)geometryArray;
                        nArray5 = new int[indexedGeometryStripArray.getNumStrips()];
                        indexedGeometryStripArray.getStripIndexCounts(nArray5);
                        n4 = 0;
                        if (!(indexedGeometryStripArray instanceof IndexedLineStripArray)) break block78;
                        for (n3 = 0; n3 < nArray5.length; ++n3) {
                            int n13 = n4 + nArray5[n3] - 1;
                            for (n2 = n4; n2 < n13; ++n2) {
                                this.writeIndexedLine((IndexedGeometryArray)indexedGeometryStripArray, n2, n2 + 1, nArray4, nArray);
                            }
                            n4 += nArray5[n3];
                        }
                        break block73;
                    }
                    if (!(indexedGeometryStripArray instanceof IndexedTriangleStripArray)) break block79;
                    for (n3 = 0; n3 < nArray5.length; ++n3) {
                        n2 = n4;
                        int n14 = n4 + nArray5[n3] - 2;
                        int n15 = 0;
                        while (n2 < n14) {
                            if (n15 % 2 == 0) {
                                this.writeIndexedTriangle((IndexedGeometryArray)indexedGeometryStripArray, n2, n2 + 1, n2 + 2, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                            } else {
                                this.writeIndexedTriangle((IndexedGeometryArray)indexedGeometryStripArray, n2, n2 + 2, n2 + 1, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                            }
                            ++n2;
                            ++n15;
                        }
                        n4 += nArray5[n3];
                    }
                    break block73;
                }
                if (!(indexedGeometryStripArray instanceof IndexedTriangleFanArray)) break block73;
                for (n3 = 0; n3 < nArray5.length; ++n3) {
                    int n16 = n4 + nArray5[n3] - 2;
                    for (n2 = n4; n2 < n16; ++n2) {
                        this.writeIndexedTriangle((IndexedGeometryArray)indexedGeometryStripArray, n4, n2 + 1, n2 + 2, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                    }
                    n4 += nArray5[n3];
                }
                break block73;
            }
            if (geometryArray instanceof LineArray) {
                LineArray lineArray = (LineArray)geometryArray;
                n4 = lineArray.getVertexCount();
                for (n5 = 0; n5 < n4; n5 += 2) {
                    this.writeLine((GeometryArray)lineArray, n5, n5 + 1, nArray4, nArray);
                }
            } else if (geometryArray instanceof TriangleArray) {
                TriangleArray triangleArray = (TriangleArray)geometryArray;
                n4 = triangleArray.getVertexCount();
                for (n5 = 0; n5 < n4; n5 += 3) {
                    this.writeTriangle((GeometryArray)triangleArray, n5, n5 + 1, n5 + 2, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                }
            } else if (geometryArray instanceof QuadArray) {
                QuadArray quadArray = (QuadArray)geometryArray;
                n4 = quadArray.getVertexCount();
                for (n5 = 0; n5 < n4; n5 += 4) {
                    this.writeQuadrilateral((GeometryArray)quadArray, n5, n5 + 1, n5 + 2, n5 + 3, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                }
            } else if (geometryArray instanceof GeometryStripArray) {
                GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
                int[] nArray6 = new int[geometryStripArray.getNumStrips()];
                geometryStripArray.getStripVertexCounts(nArray6);
                n4 = 0;
                if (geometryStripArray instanceof LineStripArray) {
                    for (n3 = 0; n3 < nArray6.length; ++n3) {
                        int n17 = n4 + nArray6[n3] - 1;
                        for (n2 = n4; n2 < n17; ++n2) {
                            this.writeLine((GeometryArray)geometryStripArray, n2, n2 + 1, nArray4, nArray);
                        }
                        n4 += nArray6[n3];
                    }
                } else if (geometryStripArray instanceof TriangleStripArray) {
                    for (n3 = 0; n3 < nArray6.length; ++n3) {
                        n2 = n4;
                        int n18 = n4 + nArray6[n3] - 2;
                        int n19 = 0;
                        while (n2 < n18) {
                            if (n19 % 2 == 0) {
                                this.writeTriangle((GeometryArray)geometryStripArray, n2, n2 + 1, n2 + 2, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                            } else {
                                this.writeTriangle((GeometryArray)geometryStripArray, n2, n2 + 2, n2 + 1, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                            }
                            ++n2;
                            ++n19;
                        }
                        n4 += nArray6[n3];
                    }
                } else if (geometryStripArray instanceof TriangleFanArray) {
                    for (n3 = 0; n3 < nArray6.length; ++n3) {
                        int n20 = n4 + nArray6[n3] - 2;
                        for (n2 = n4; n2 < n20; ++n2) {
                            this.writeTriangle((GeometryArray)geometryStripArray, n4, n2 + 1, n2 + 2, nArray4, nArray3, nArray2, bl3, nArray, bl2, n);
                        }
                        n4 += nArray6[n3];
                    }
                }
            }
        }
    }

    private TexCoord2f generateTextureCoordinates(float f, float f2, float f3, Vector4f vector4f, Vector4f vector4f2) {
        return new TexCoord2f(f * vector4f.x + f2 * vector4f.y + f3 * vector4f.z + vector4f.w, f * vector4f2.x + f2 * vector4f2.y + f3 * vector4f2.z + vector4f2.w);
    }

    private void writeVertex(Transform3D transform3D, Point3f point3f, int n, int[] nArray) throws IOException {
        transform3D.transform(point3f);
        Integer n2 = this.vertexIndices.get(point3f);
        if (n2 == null) {
            nArray[n] = this.vertexIndices.size() + 1;
            this.vertexIndices.put(point3f, nArray[n]);
            this.out.write("v " + this.format(point3f.x) + " " + this.format(point3f.y) + " " + this.format(point3f.z) + "\n");
        } else {
            nArray[n] = n2;
        }
    }

    private String format(float f) {
        if (this.numberFormat != null) {
            return this.numberFormat.format(f);
        }
        String string = String.valueOf(f);
        if (string.indexOf(69) != -1) {
            return this.defaultNumberFormat.format(f);
        }
        return string;
    }

    private boolean writeNormal(StringBuilder stringBuilder, Transform3D transform3D, Vector3f vector3f, int n, int[] nArray, int[] nArray2, List<Vector3f> list, int n2, boolean bl) throws IOException {
        Integer n3;
        if (Float.isNaN(vector3f.x) || Float.isNaN(vector3f.y) || Float.isNaN(vector3f.z)) {
            return false;
        }
        if (bl) {
            vector3f.negate();
        }
        if (vector3f.x != 0.0f || vector3f.y != 0.0f || vector3f.z != 0.0f) {
            transform3D.transform(vector3f);
            vector3f.normalize();
        }
        if ((n3 = this.normalIndices.get(vector3f)) == null) {
            nArray[n] = this.normalIndices.size() + 1;
            this.normalIndices.put(vector3f, nArray[n]);
            list.add(vector3f);
            stringBuilder.append("vn " + this.format(vector3f.x) + " " + this.format(vector3f.y) + " " + this.format(vector3f.z) + "\n");
        } else {
            nArray[n] = n3;
        }
        if (n2 == 0) {
            Vector3f vector3f2 = new Vector3f();
            vector3f2.negate((Tuple3f)vector3f);
            return this.writeNormal(stringBuilder, transform3D, vector3f2, n, nArray2, null, list, 2, false);
        }
        return true;
    }

    private void writeTextureCoordinates(TexCoord2f texCoord2f, Transform3D transform3D, int n, int[] nArray) throws IOException {
        Integer n2;
        if (transform3D.getBestType() != 2) {
            n2 = new Point3f(texCoord2f.x, texCoord2f.y, 0.0f);
            transform3D.transform((Point3f)n2);
            texCoord2f = new TexCoord2f(((Point3f)n2).x, ((Point3f)n2).y);
        }
        if ((n2 = this.textureCoordinatesIndices.get(texCoord2f)) == null) {
            nArray[n] = this.textureCoordinatesIndices.size() + 1;
            this.textureCoordinatesIndices.put(texCoord2f, nArray[n]);
            this.out.write("vt " + this.format(texCoord2f.x) + " " + this.format(texCoord2f.y) + " 0\n");
        } else {
            nArray[n] = n2;
        }
    }

    private void writeIndexedLine(IndexedGeometryArray indexedGeometryArray, int n, int n2, int[] nArray, int[] nArray2) throws IOException {
        if ((indexedGeometryArray.getVertexFormat() & 0x20) != 0) {
            this.out.write("l " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray2[indexedGeometryArray.getTextureCoordinateIndex(0, n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray2[indexedGeometryArray.getTextureCoordinateIndex(0, n2)] + "\n");
        } else {
            this.out.write("l " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "\n");
        }
    }

    private void writeIndexedTriangle(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, int[] nArray4, boolean bl2, int n4) throws IOException {
        if (n4 == 2) {
            int n5 = n;
            n = n3;
            n3 = n5;
        }
        if (bl2) {
            if (bl) {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n3)] + "\n");
            } else {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n3)] + "\n");
            }
        } else if ((indexedGeometryArray.getVertexFormat() & 0x20) != 0) {
            if (bl) {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n2)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n3)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n3)] + "\n");
            } else {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n3)] + "\n");
            }
        } else if (bl) {
            this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n3)] + "\n");
        } else {
            this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "\n");
        }
        if (n4 == 0) {
            this.writeIndexedTriangle(indexedGeometryArray, n, n2, n3, nArray, nArray3, null, bl, nArray4, bl2, 2);
        }
    }

    private void writeIndexedQuadrilateral(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, int[] nArray4, boolean bl2, int n5) throws IOException {
        if (n5 == 2) {
            int n6 = n2;
            n2 = n3;
            n3 = n6;
            n6 = n;
            n = n4;
            n4 = n6;
        }
        if (bl2) {
            if (bl) {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n3)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n4)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n4)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n4)] + "\n");
            } else {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n3)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n4)] + "/" + nArray4[indexedGeometryArray.getCoordinateIndex(n4)] + "\n");
            }
        } else if ((indexedGeometryArray.getVertexFormat() & 0x20) != 0) {
            if (bl) {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n2)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n3)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n3)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n4)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n4)] + "/" + nArray2[indexedGeometryArray.getNormalIndex(n4)] + "\n");
            } else {
                this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n3)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n4)] + "/" + nArray4[indexedGeometryArray.getTextureCoordinateIndex(0, n4)] + "\n");
            }
        } else if (bl) {
            this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n3)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n4)] + "//" + nArray2[indexedGeometryArray.getNormalIndex(n4)] + "\n");
        } else {
            this.out.write("f " + nArray[indexedGeometryArray.getCoordinateIndex(n)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n2)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n3)] + " " + nArray[indexedGeometryArray.getCoordinateIndex(n4)] + "\n");
        }
        if (n5 == 0) {
            this.writeIndexedQuadrilateral(indexedGeometryArray, n, n2, n3, n4, nArray, nArray3, null, bl, nArray4, bl2, 2);
        }
    }

    private void writeLine(GeometryArray geometryArray, int n, int n2, int[] nArray, int[] nArray2) throws IOException {
        if ((geometryArray.getVertexFormat() & 0x20) != 0) {
            this.out.write("l " + nArray[n] + "/" + nArray2[n] + " " + nArray[n2] + "/" + nArray2[n2] + "\n");
        } else {
            this.out.write("l " + nArray[n] + " " + nArray[n2] + "\n");
        }
    }

    private void writeTriangle(GeometryArray geometryArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, int[] nArray4, boolean bl2, int n4) throws IOException {
        if (n4 == 2) {
            int n5 = n;
            n = n3;
            n3 = n5;
        }
        if (bl2 || (geometryArray.getVertexFormat() & 0x20) != 0) {
            if (bl) {
                this.out.write("f " + nArray[n] + "/" + nArray4[n] + "/" + nArray2[n] + " " + nArray[n2] + "/" + nArray4[n2] + "/" + nArray2[n2] + " " + nArray[n3] + "/" + nArray4[n3] + "/" + nArray2[n3] + "\n");
            } else {
                this.out.write("f " + nArray[n] + "/" + nArray4[n] + " " + nArray[n2] + "/" + nArray4[n2] + " " + nArray[n3] + "/" + nArray4[n3] + "\n");
            }
        } else if (bl) {
            this.out.write("f " + nArray[n] + "//" + nArray2[n] + " " + nArray[n2] + "//" + nArray2[n2] + " " + nArray[n3] + "//" + nArray2[n3] + "\n");
        } else {
            this.out.write("f " + nArray[n] + " " + nArray[n2] + " " + nArray[n3] + "\n");
        }
        if (n4 == 0) {
            this.writeTriangle(geometryArray, n, n2, n3, nArray, nArray3, null, bl, nArray4, bl2, 2);
        }
    }

    private void writeQuadrilateral(GeometryArray geometryArray, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, int[] nArray4, boolean bl2, int n5) throws IOException {
        if (n5 == 2) {
            int n6 = n2;
            n2 = n3;
            n3 = n6;
            n6 = n;
            n = n4;
            n4 = n6;
        }
        if (bl2 || (geometryArray.getVertexFormat() & 0x20) != 0) {
            if (bl) {
                this.out.write("f " + nArray[n] + "/" + nArray4[n] + "/" + nArray2[n] + " " + nArray[n2] + "/" + nArray4[n2] + "/" + nArray2[n2] + " " + nArray[n3] + "/" + nArray4[n3] + "/" + nArray2[n3] + " " + nArray[n4] + "/" + nArray4[n4] + "/" + nArray2[n4] + "\n");
            } else {
                this.out.write("f " + nArray[n] + "/" + nArray4[n] + " " + nArray[n2] + "/" + nArray4[n2] + " " + nArray[n3] + "/" + nArray4[n3] + " " + nArray[n4] + "/" + nArray4[n4] + "\n");
            }
        } else if (bl) {
            this.out.write("f " + nArray[n] + "//" + nArray2[n] + " " + nArray[n2] + "//" + nArray2[n2] + " " + nArray[n3] + "//" + nArray2[n3] + " " + nArray[n4] + "//" + nArray2[n4] + "\n");
        } else {
            this.out.write("f " + nArray[n] + " " + nArray[n2] + " " + nArray[n3] + " " + nArray[n4] + "\n");
        }
        if (n5 == 0) {
            this.writeQuadrilateral(geometryArray, n, n2, n3, n4, nArray, nArray3, null, bl, nArray4, bl2, 2);
        }
    }

    @Override
    public void close() throws IOException, InterruptedIOException {
        super.close();
        if (this.mtlFileName != null) {
            this.writeAppearancesToMTLFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAppearancesToMTLFile() throws IOException {
        try (Writer writer = null;){
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Appearance appearance;
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.mtlFileName)), "ISO-8859-1");
            this.writeHeader(writer);
            for (Map.Entry<ComparableAppearance, String> entry : this.appearances.entrySet()) {
                this.checkCurrentThreadIsntInterrupted();
                appearance = entry.getKey().getAppearance();
                object4 = entry.getValue();
                writer.write("\nnewmtl " + (String)object4 + "\n");
                object3 = appearance.getMaterial();
                if (object3 != null) {
                    if (object3 instanceof OBJMaterial && ((OBJMaterial)((Object)object3)).isIlluminationModelSet()) {
                        writer.write("illum " + ((OBJMaterial)((Object)object3)).getIlluminationModel() + "\n");
                    } else if (object3.getShininess() > 1.0f) {
                        writer.write("illum 2\n");
                    } else if (object3.getLightingEnable()) {
                        writer.write("illum 1\n");
                    } else {
                        writer.write("illum 0\n");
                    }
                    object2 = new Color3f();
                    object3.getAmbientColor((Color3f)object2);
                    writer.write("Ka " + this.format(((Color3f)object2).x) + " " + this.format(((Color3f)object2).y) + " " + this.format(((Color3f)object2).z) + "\n");
                    object3.getDiffuseColor((Color3f)object2);
                    writer.write("Kd " + this.format(((Color3f)object2).x) + " " + this.format(((Color3f)object2).y) + " " + this.format(((Color3f)object2).z) + "\n");
                    object3.getSpecularColor((Color3f)object2);
                    writer.write("Ks " + this.format(((Color3f)object2).x) + " " + this.format(((Color3f)object2).y) + " " + this.format(((Color3f)object2).z) + "\n");
                    writer.write("Ns " + this.format(object3.getShininess()) + "\n");
                    if (object3 instanceof OBJMaterial) {
                        object = (OBJMaterial)((Object)object3);
                        if (object.isOpticalDensitySet()) {
                            writer.write("Ni " + this.format(object.getOpticalDensity()) + "\n");
                        }
                        if (object.isSharpnessSet()) {
                            writer.write("sharpness " + this.format(object.getSharpness()) + "\n");
                        }
                    }
                } else {
                    object2 = appearance.getColoringAttributes();
                    if (object2 != null) {
                        writer.write("illum 0\n");
                        object = new Color3f();
                        object2.getColor(object);
                        writer.write("Ka " + this.format(object.x) + " " + this.format(object.y) + " " + this.format(object.z) + "\n");
                        writer.write("Kd " + this.format(object.x) + " " + this.format(object.y) + " " + this.format(object.z) + "\n");
                        writer.write("Ks " + this.format(object.x) + " " + this.format(object.y) + " " + this.format(object.z) + "\n");
                    }
                }
                object2 = appearance.getTransparencyAttributes();
                if (object2 != null) {
                    if (!(object3 instanceof OBJMaterial)) {
                        writer.write("Ni 1\n");
                    }
                    writer.write("d " + this.format(1.0f - object2.getTransparency()) + "\n");
                }
                if ((object = appearance.getTexture()) == null) continue;
                writer.write("map_Kd " + this.textures.get(object).getName() + "\n");
            }
            for (Map.Entry<ComparableAppearance, Object> entry : this.textures.entrySet()) {
                appearance = (Texture)entry.getKey();
                object4 = appearance.getUserData();
                if (this.copiedTextures.contains(object4)) {
                    object3 = null;
                    object2 = null;
                    try {
                        int n;
                        object3 = this.openStream((URL)object4);
                        object2 = new FileOutputStream((File)entry.getValue());
                        object = new byte[8192];
                        while ((n = ((InputStream)object3).read((byte[])object)) != -1) {
                            ((OutputStream)object2).write((byte[])object, 0, n);
                        }
                        continue;
                    }
                    finally {
                        if (object3 != null) {
                            ((InputStream)object3).close();
                        }
                        if (object2 != null) {
                            ((OutputStream)object2).close();
                        }
                        continue;
                    }
                }
                object3 = (ImageComponent2D)appearance.getImage(0);
                object2 = object3.getRenderedImage();
                ImageIO.write((RenderedImage)object2, "png", (File)entry.getValue());
            }
        }
    }

    public static void writeNodeInZIPFile(Node node, File file, int n, String string, String string2) throws IOException {
        OBJWriter.writeNodeInZIPFile(node, null, file, n, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void writeNodeInZIPFile(Node node, Map<String, Appearance> map, File file, int n, String string, String string2) throws IOException {
        void var10_15;
        File[] fileArray;
        File file2;
        block16: {
            file2 = null;
            for (int i = 0; i < 10 && file2 == null; ++i) {
                file2 = File.createTempFile("obj", "tmp");
                file2.delete();
                if (file2.mkdirs()) continue;
                file2 = null;
            }
            if (file2 == null) {
                throw new IOException("Couldn't create a temporary folder");
            }
            ZipOutputStream zipOutputStream = null;
            try {
                fileArray = new OBJWriter(new File(file2, string), string2, -1);
                fileArray.writeNode(node);
                fileArray.close();
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                zipOutputStream.setLevel(n);
                for (File file3 : file2.listFiles()) {
                    if (!file3.isFile()) continue;
                    try (InputStream inputStream = null;){
                        int n2;
                        zipOutputStream.putNextEntry(new ZipEntry(file3.getName()));
                        inputStream = new FileInputStream(file3);
                        byte[] byArray = new byte[8096];
                        while ((n2 = inputStream.read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n2);
                        }
                        zipOutputStream.closeEntry();
                    }
                }
                if (map != null) {
                    for (Map.Entry entry : fileArray.appearances.entrySet()) {
                        map.put((String)entry.getValue(), ((ComparableAppearance)entry.getKey()).getAppearance());
                    }
                }
                if (zipOutputStream == null) break block16;
            }
            catch (Throwable throwable) {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                for (File file4 : file2.listFiles()) {
                    if (!file4.isFile()) continue;
                    file4.delete();
                }
                file2.delete();
                throw throwable;
            }
            zipOutputStream.close();
        }
        fileArray = file2.listFiles();
        int n3 = fileArray.length;
        boolean bl = false;
        while (var10_15 < n3) {
            File file5 = fileArray[var10_15];
            if (file5.isFile()) {
                file5.delete();
            }
            ++var10_15;
        }
        file2.delete();
    }

    private static class ComparableAppearance {
        private Appearance appearance;

        public ComparableAppearance(Appearance appearance) {
            this.appearance = appearance;
        }

        public Appearance getAppearance() {
            return this.appearance;
        }

        public boolean equals(Object object) {
            if (object instanceof ComparableAppearance) {
                Object object2;
                Object object3;
                TransparencyAttributes transparencyAttributes;
                Color3f color3f;
                Material material;
                Color3f color3f2;
                ColoringAttributes coloringAttributes;
                Appearance appearance = ((ComparableAppearance)object).appearance;
                ColoringAttributes coloringAttributes2 = this.appearance.getColoringAttributes();
                if (coloringAttributes2 == null ^ (coloringAttributes = appearance.getColoringAttributes()) == null) {
                    return false;
                }
                if (coloringAttributes2 != coloringAttributes) {
                    color3f2 = new Color3f();
                    material = new Color3f();
                    coloringAttributes2.getColor(color3f2);
                    coloringAttributes.getColor((Color3f)material);
                    if (!color3f2.equals((Tuple3f)material)) {
                        return false;
                    }
                }
                if ((color3f2 = this.appearance.getMaterial()) == null ^ (material = appearance.getMaterial()) == null) {
                    return false;
                }
                if (color3f2 != material) {
                    color3f = new Color3f();
                    transparencyAttributes = new Color3f();
                    color3f2.getAmbientColor(color3f);
                    material.getAmbientColor((Color3f)transparencyAttributes);
                    if (!color3f.equals((Tuple3f)transparencyAttributes)) {
                        return false;
                    }
                    color3f2.getDiffuseColor(color3f);
                    material.getDiffuseColor((Color3f)transparencyAttributes);
                    if (!color3f.equals((Tuple3f)transparencyAttributes)) {
                        return false;
                    }
                    color3f2.getEmissiveColor(color3f);
                    material.getEmissiveColor((Color3f)transparencyAttributes);
                    if (!color3f.equals((Tuple3f)transparencyAttributes)) {
                        return false;
                    }
                    color3f2.getSpecularColor(color3f);
                    material.getSpecularColor((Color3f)transparencyAttributes);
                    if (!color3f.equals((Tuple3f)transparencyAttributes)) {
                        return false;
                    }
                    if (color3f2.getShininess() != material.getShininess()) {
                        return false;
                    }
                    if (color3f2.getClass() != material.getClass()) {
                        return false;
                    }
                    if (color3f2.getClass() == OBJMaterial.class) {
                        object3 = (OBJMaterial)color3f2;
                        object2 = (OBJMaterial)material;
                        if (((OBJMaterial)((Object)object3)).isOpticalDensitySet() ^ ((OBJMaterial)((Object)object2)).isOpticalDensitySet()) {
                            return false;
                        }
                        if (((OBJMaterial)((Object)object3)).isOpticalDensitySet() && ((OBJMaterial)((Object)object2)).isOpticalDensitySet() && ((OBJMaterial)((Object)object3)).getOpticalDensity() != ((OBJMaterial)((Object)object2)).getOpticalDensity()) {
                            return false;
                        }
                        if (((OBJMaterial)((Object)object3)).isIlluminationModelSet() ^ ((OBJMaterial)((Object)object2)).isIlluminationModelSet()) {
                            return false;
                        }
                        if (((OBJMaterial)((Object)object3)).isIlluminationModelSet() && ((OBJMaterial)((Object)object2)).isIlluminationModelSet() && ((OBJMaterial)((Object)object3)).getIlluminationModel() != ((OBJMaterial)((Object)object2)).getIlluminationModel()) {
                            return false;
                        }
                        if (((OBJMaterial)((Object)object3)).isSharpnessSet() ^ ((OBJMaterial)((Object)object2)).isSharpnessSet()) {
                            return false;
                        }
                        if (((OBJMaterial)((Object)object3)).isSharpnessSet() && ((OBJMaterial)((Object)object2)).isSharpnessSet() && ((OBJMaterial)((Object)object3)).getSharpness() != ((OBJMaterial)((Object)object2)).getSharpness()) {
                            return false;
                        }
                    }
                }
                if ((color3f = this.appearance.getTransparencyAttributes()) == null ^ (transparencyAttributes = appearance.getTransparencyAttributes()) == null) {
                    return false;
                }
                if (color3f != transparencyAttributes && color3f.getTransparency() != transparencyAttributes.getTransparency()) {
                    return false;
                }
                object3 = this.appearance.getTexture();
                if (object3 == null ^ (object2 = appearance.getTexture()) == null) {
                    return false;
                }
                if (object3 != object2 && object3.getImage(0) != object2.getImage(0)) {
                    return false;
                }
                try {
                    String string = this.appearance.getName();
                    String string2 = appearance.getName();
                    if (string == null ^ string2 == null) {
                        return false;
                    }
                    if (string != string2 && !string.equals(string2)) {
                        return false;
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            Texture texture;
            Color3f color3f;
            Color3f color3f2;
            int n = 0;
            ColoringAttributes coloringAttributes = this.appearance.getColoringAttributes();
            if (coloringAttributes != null) {
                color3f2 = new Color3f();
                coloringAttributes.getColor(color3f2);
                n += color3f2.hashCode();
            }
            if ((color3f2 = this.appearance.getMaterial()) != null) {
                color3f = new Color3f();
                color3f2.getAmbientColor(color3f);
                n += color3f.hashCode();
                color3f2.getDiffuseColor(color3f);
                n += color3f.hashCode();
                color3f2.getEmissiveColor(color3f);
                n += color3f.hashCode();
                color3f2.getSpecularColor(color3f);
                n += color3f.hashCode();
                n += Float.floatToIntBits(color3f2.getShininess());
            }
            if ((color3f = this.appearance.getTransparencyAttributes()) != null) {
                n += Float.floatToIntBits(color3f.getTransparency());
            }
            if ((texture = this.appearance.getTexture()) != null) {
                n += texture.getImage(0).hashCode();
            }
            try {
                String string = this.appearance.getName();
                if (string != null) {
                    n += string.hashCode();
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            return n;
        }
    }
}

