/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGrid.ServerState;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.CommunicatorEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Server;
import com.zeroc.IceGridGUI.LiveDeployment.Service;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.JToolBar;

class ServiceEditor
extends CommunicatorEditor {
    private final Coordinator _coordinator;
    private JTextField _entry = new JTextField(20);
    private JCheckBox _started = new JCheckBox("Started");
    private JToolBar _toolBar;

    @Override
    public JToolBar getToolBar() {
        if (this._toolBar == null) {
            this._toolBar = new ToolBar();
        }
        return this._toolBar;
    }

    ServiceEditor(Coordinator coordinator) {
        this._coordinator = coordinator;
        this._entry.setEditable(false);
        this._started.setEnabled(false);
    }

    void show(Service service) {
        Service previous = (Service)this._target;
        this._target = service;
        ServiceDescriptor descriptor = service.getServiceDescriptor();
        Utils.Resolver resolver = service.getResolver();
        this.show((CommunicatorDescriptor)descriptor, service.getProperties(), resolver);
        this._entry.setText(resolver.substitute(descriptor.entry));
        this._started.setSelected(service.isStarted());
        Server server = (Server)service.getParent();
        int iceIntVersion = server.getIceVersion();
        if (server.getState() == ServerState.Active && (iceIntVersion == 0 || iceIntVersion >= 30300)) {
            this.showRuntimeProperties(previous);
        } else {
            this.clearRuntimeProperties("");
        }
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        builder.appendSeparator("Runtime Status");
        builder.append("", (Component)this._started);
        builder.nextLine();
        this.appendRuntimeProperties(builder);
        builder.appendSeparator("Configuration");
        this.appendDescriptorProperties(builder);
        builder.append("Entry Point");
        builder.append((Component)this._entry, 3);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Service Properties");
    }

    private class ToolBar
    extends JToolBar {
        private ToolBar() {
            this.putClientProperty("jgoodies.headerStyle", HeaderStyle.SINGLE);
            this.putClientProperty("Plastic.borderStyle", BorderStyle.SEPARATOR);
            this.setFloatable(false);
            this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            LiveActions la = ServiceEditor.this._coordinator.getLiveActionsForMenu();
            this.add(la.get(0));
            this.add(la.get(1));
        }
    }
}

