/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class JosmAction
extends AbstractAction
implements Destroyable {
    protected transient Shortcut sc;
    private transient LayerChangeAdapter layerChangeAdapter;
    private transient ActiveLayerChangeAdapter activeLayerChangeAdapter;
    private transient SelectionChangeAdapter selectionChangeAdapter;

    public JosmAction(String name, ImageProvider icon, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
        super(name);
        ImageResource resource;
        if (icon != null && (resource = icon.getResource()) != null) {
            try {
                resource.attachImageIcon(this, true);
            }
            catch (RuntimeException e) {
                Logging.warn("Unable to attach image icon {0} for action {1}", icon, name);
                Logging.error(e);
            }
        }
        this.setHelpId();
        this.sc = shortcut;
        if (this.sc != null && !this.sc.isAutomatic()) {
            MainApplication.registerActionShortcut(this, this.sc);
        }
        this.setTooltip(tooltip);
        if (this.getValue("toolbar") == null) {
            this.putValue("toolbar", toolbarId);
        }
        if (registerInToolbar && MainApplication.getToolbar() != null) {
            MainApplication.getToolbar().register(this);
        }
        if (installAdapters) {
            this.installAdapters();
        }
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar, String toolbarId, boolean installAdapters) {
        this(name, iconName == null ? null : new ImageProvider(iconName).setOptional(true), tooltip, shortcut, registerInToolbar, toolbarId == null ? iconName : toolbarId, installAdapters);
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar, boolean installAdapters) {
        this(name, iconName, tooltip, shortcut, registerInToolbar, null, installAdapters);
    }

    public JosmAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        this(name, iconName, tooltip, shortcut, registerInToolbar, null, true);
    }

    public JosmAction() {
        this(true);
    }

    public JosmAction(boolean installAdapters) {
        this.setHelpId();
        if (installAdapters) {
            this.installAdapters();
        }
    }

    public JosmAction(String name, String iconName, String tooltip, List<Shortcut> shortcuts) {
        this(name, iconName, tooltip, shortcuts.get(0), true, null, true);
        for (int i = 1; i < shortcuts.size(); ++i) {
            MainApplication.registerActionShortcut(this, shortcuts.get(i));
        }
    }

    protected void installAdapters() {
        if (this.listenToLayerChange()) {
            this.layerChangeAdapter = new LayerChangeAdapter();
            this.activeLayerChangeAdapter = new ActiveLayerChangeAdapter();
            this.getLayerManager().addLayerChangeListener(this.layerChangeAdapter);
            this.getLayerManager().addActiveLayerChangeListener(this.activeLayerChangeAdapter);
        }
        if (this.listenToSelectionChange()) {
            this.selectionChangeAdapter = new SelectionChangeAdapter();
            SelectionEventManager.getInstance().addSelectionListenerForEdt(this.selectionChangeAdapter);
        }
        this.initEnabledState();
    }

    protected boolean listenToLayerChange() {
        return true;
    }

    protected boolean listenToSelectionChange() {
        return true;
    }

    @Override
    public void destroy() {
        if (this.sc != null && !this.sc.isAutomatic()) {
            MainApplication.unregisterActionShortcut(this);
        }
        if (this.layerChangeAdapter != null) {
            this.getLayerManager().removeLayerChangeListener(this.layerChangeAdapter);
            this.getLayerManager().removeActiveLayerChangeListener(this.activeLayerChangeAdapter);
        }
        if (this.selectionChangeAdapter != null) {
            SelectionEventManager.getInstance().removeSelectionListener(this.selectionChangeAdapter);
        }
    }

    private void setHelpId() {
        String helpId = "Action/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        if (helpId.endsWith("Action")) {
            helpId = helpId.substring(0, helpId.length() - 6);
        }
        this.putValue("help", helpId);
    }

    public Shortcut getShortcut() {
        if (this.sc == null) {
            this.sc = Shortcut.registerShortcut("core:none", I18n.tr("No Shortcut", new Object[0]), 65535, 5000);
        }
        return this.sc;
    }

    public final void setTooltip(String tooltip) {
        if (tooltip != null) {
            this.putValue("ShortDescription", PlatformManager.getPlatform().makeTooltip(tooltip, this.sc));
        }
    }

    public MainLayerManager getLayerManager() {
        return MainApplication.getLayerManager();
    }

    protected static void waitFuture(Future<?> future, PleaseWaitProgressMonitor monitor) {
        MainApplication.worker.submit(() -> {
            try {
                future.get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                Logging.error(e);
                return;
            }
            monitor.close();
        });
    }

    protected void initEnabledState() {
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
    }

    protected final void updateEnabledStateOnCurrentSelection() {
        this.updateEnabledStateOnCurrentSelection(false);
    }

    protected final void updateEnabledStateOnCurrentSelection(boolean allowReadOnly) {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        if (ds != null && (allowReadOnly || !ds.isLocked())) {
            this.updateEnabledState(ds.getSelected());
        } else {
            this.setEnabled(false);
        }
    }

    protected final void updateEnabledStateOnModifiableSelection(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(OsmUtils.isOsmCollectionEditable(selection));
    }

    public static boolean checkAndConfirmOutlyingOperation(String operation, String dialogTitle, String outsideDialogMessage, String incompleteDialogMessage, Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> ignore) {
        boolean answer;
        JPanel msg;
        int checkRes = Command.checkOutlyingOrIncompleteOperation(primitives, ignore);
        if ((checkRes & 1) != 0) {
            msg = new JPanel(new GridBagLayout());
            msg.add(new JMultilineLabel("<html>" + outsideDialogMessage + "</html>"));
            answer = ConditionalOptionPaneUtil.showConfirmationDialog(operation + "_outside_nodes", MainApplication.getMainFrame(), msg, dialogTitle, 0, 3, 0);
            if (!answer) {
                return false;
            }
        }
        if ((checkRes & 2) != 0) {
            msg = new JPanel(new GridBagLayout());
            msg.add(new JMultilineLabel("<html>" + incompleteDialogMessage + "</html>"));
            answer = ConditionalOptionPaneUtil.showConfirmationDialog(operation + "_incomplete", MainApplication.getMainFrame(), msg, dialogTitle, 0, 3, 0);
            if (!answer) {
                return false;
            }
        }
        return true;
    }

    protected class SelectionChangeAdapter
    implements DataSelectionListener {
        protected SelectionChangeAdapter() {
        }

        @Override
        public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
            JosmAction.this.updateEnabledState(event.getSelection());
        }

        public String toString() {
            return "SelectionChangeAdapter [" + JosmAction.this + ']';
        }
    }

    protected class ActiveLayerChangeAdapter
    implements MainLayerManager.ActiveLayerChangeListener {
        protected ActiveLayerChangeAdapter() {
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            JosmAction.this.updateEnabledState();
        }

        public String toString() {
            return "ActiveLayerChangeAdapter [" + JosmAction.this + ']';
        }
    }

    protected class LayerChangeAdapter
    implements LayerManager.LayerChangeListener {
        protected LayerChangeAdapter() {
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            JosmAction.this.updateEnabledState();
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            JosmAction.this.updateEnabledState();
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
            JosmAction.this.updateEnabledState();
        }

        public String toString() {
            return "LayerChangeAdapter [" + JosmAction.this + ']';
        }
    }
}

