/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.impl;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.DataSourceContainer;
import com.sun.tools.visualvm.core.datasource.DataSourceRepository;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.core.explorer.ExplorerSupport;
import com.sun.tools.visualvm.core.options.GlobalPreferences;
import com.sun.tools.visualvm.host.Host;
import com.sun.tools.visualvm.host.HostsSupport;
import com.sun.tools.visualvm.host.RemoteHostsContainer;
import com.sun.tools.visualvm.host.impl.HostProperties;
import com.sun.tools.visualvm.host.impl.LocalHostImpl;
import com.sun.tools.visualvm.host.impl.RemoteHostImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class HostProvider {
    private static final Logger LOGGER = Logger.getLogger(HostProvider.class.getName());
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROPERTY_HOSTNAME = "prop_hostname";
    private static final String DNSA_KEY = "HostProvider_NotifyUnresolved";
    private static InetAddress localhostAddress2;
    private Semaphore hostsLockedSemaphore = new Semaphore(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host createHost(HostProperties hostDescriptor, boolean createOnly, boolean interactive) {
        try {
            ProgressHandle pHandleF;
            this.lockHosts();
            final String hostName = hostDescriptor.getHostName();
            InetAddress inetAddress = null;
            ProgressHandle pHandle = null;
            try {
                block21: {
                    pHandle = ProgressHandleFactory.createHandle((String)(NbBundle.getMessage(HostProvider.class, (String)"LBL_Searching_for_host") + hostName));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        inetAddress = InetAddress.getByName(hostName);
                    }
                    catch (UnknownHostException e) {
                        if (!interactive) break block21;
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HostProvider.class, (String)"MSG_Wrong_Host", (Object)hostName), 0));
                    }
                }
                pHandleF = pHandle;
            }
            catch (Throwable throwable) {
                ProgressHandle pHandleF2 = pHandle;
                SwingUtilities.invokeLater(new Runnable(pHandleF2){
                    final /* synthetic */ ProgressHandle val$pHandleF;
                    {
                        this.val$pHandleF = progressHandle;
                    }

                    @Override
                    public void run() {
                        if (this.val$pHandleF != null) {
                            this.val$pHandleF.finish();
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            if (inetAddress != null) {
                final Host knownHost = this.getHostByAddressImpl(inetAddress);
                if (knownHost != null) {
                    if (interactive && createOnly) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ExplorerSupport.sharedInstance().selectDataSource((DataSource)knownHost);
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HostProvider.class, (String)"MSG_Already_Monitored", (Object[])new Object[]{hostName, DataSourceDescriptorFactory.getDescriptor((DataSource)knownHost).getName()}), 2));
                            }
                        });
                    }
                    Host host = knownHost;
                    return host;
                }
                String ipString = inetAddress.getHostAddress();
                String[] propNames = new String[]{SNAPSHOT_VERSION, PROPERTY_HOSTNAME, "prop_name"};
                String[] propValues = new String[]{CURRENT_SNAPSHOT_VERSION, hostName, hostDescriptor.getDisplayName()};
                File customPropertiesStorage = Utils.getUniqueFile((File)HostsSupport.getStorageDirectory(), (String)ipString, (String)".properties");
                Storage storage = new Storage(customPropertiesStorage.getParentFile(), customPropertiesStorage.getName());
                storage.setCustomProperties(propNames, propValues);
                Host newHost = null;
                try {
                    newHost = new RemoteHostImpl(hostName, storage);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error creating host", e);
                }
                if (newHost != null) {
                    DataSourceContainer remoteHosts = RemoteHostsContainer.sharedInstance().getRepository();
                    Set remoteHostsSet = remoteHosts.getDataSources(Host.class);
                    if (!createOnly && remoteHostsSet.contains((Object)newHost)) {
                        storage.deleteCustomPropertiesStorage();
                        for (Host existingHost : remoteHostsSet) {
                            if (!existingHost.equals((Object)newHost)) continue;
                            newHost = existingHost;
                            break;
                        }
                    } else {
                        if (hostDescriptor.getPropertiesCustomizer() != null) {
                            hostDescriptor.getPropertiesCustomizer().propertiesDefined((DataSource)newHost);
                        }
                        remoteHosts.addDataSource((DataSource)newHost);
                    }
                }
                RemoteHostImpl remoteHostImpl = newHost;
                return remoteHostImpl;
            }
            Host host = null;
            return host;
        }
        catch (InterruptedException ex) {
            LOGGER.throwing(HostProvider.class.getName(), "createHost", ex);
            Host host = null;
            return host;
        }
        finally {
            this.unlockHosts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHost(RemoteHostImpl host, boolean interactive) {
        try {
            this.lockHosts();
            DataSource owner = host.getOwner();
            if (owner != null) {
                owner.getRepository().removeDataSource((DataSource)host);
            }
        }
        catch (InterruptedException ex) {
            LOGGER.throwing(HostProvider.class.getName(), "removeHost", ex);
        }
        finally {
            this.unlockHosts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host getHostByAddress(InetAddress inetAddress) {
        try {
            this.lockHosts();
            Host host = this.getHostByAddressImpl(inetAddress);
            return host;
        }
        catch (InterruptedException ex) {
            LOGGER.throwing(HostProvider.class.getName(), "getHostByAddress", ex);
            Host host = null;
            return host;
        }
        finally {
            this.unlockHosts();
        }
    }

    private Host getHostByAddressImpl(InetAddress inetAddress) {
        Set knownHosts = DataSourceRepository.sharedInstance().getDataSources(RemoteHostImpl.class);
        for (RemoteHostImpl knownHost : knownHosts) {
            if (!knownHost.getInetAddress().equals(inetAddress)) continue;
            return knownHost;
        }
        if (inetAddress.equals(Host.LOCALHOST.getInetAddress())) {
            return Host.LOCALHOST;
        }
        if (inetAddress.equals(localhostAddress2)) {
            return Host.LOCALHOST;
        }
        if (inetAddress.isLoopbackAddress()) {
            return Host.LOCALHOST;
        }
        return null;
    }

    public Host createLocalHost() {
        try {
            return new LocalHostImpl();
        }
        catch (UnknownHostException e) {
            LOGGER.severe("Critical failure: cannot resolve localhost");
            return null;
        }
    }

    public Host createUnknownHost() {
        try {
            return new Host("unknown", InetAddress.getByAddress(new byte[]{0, 0, 0, 0})){};
        }
        catch (UnknownHostException e) {
            LOGGER.severe("Failure: cannot resolve <unknown> host");
            return null;
        }
    }

    private void initLocalHost() {
        try {
            localhostAddress2 = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (Host.LOCALHOST != null) {
            DataSource.ROOT.getRepository().addDataSource((DataSource)Host.LOCALHOST);
        }
    }

    private void initUnknownHost() {
        final Host unknownhost = Host.UNKNOWN_HOST;
        if (unknownhost != null) {
            unknownhost.getRepository().addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent event) {
                    unknownhost.setVisible(!event.getCurrent().isEmpty());
                }
            }, DataSource.class);
            RemoteHostsContainer.sharedInstance().getRepository().addDataSource((DataSource)unknownhost);
        }
    }

    private void initPersistedHosts() {
        if (HostsSupport.storageDirectoryExists()) {
            File storageDir = HostsSupport.getStorageDirectory();
            File[] files = storageDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            });
            HashSet<File> unresolvedHostsF = new HashSet<File>();
            HashSet<String> unresolvedHostsS = new HashSet<String>();
            HashSet<RemoteHostImpl> hosts = new HashSet<RemoteHostImpl>();
            for (File file : files) {
                if ("localhost.properties".equals(file.getName())) continue;
                Storage storage = new Storage(storageDir, file.getName());
                String hostName = storage.getCustomProperty(PROPERTY_HOSTNAME);
                RemoteHostImpl persistedHost = null;
                try {
                    persistedHost = new RemoteHostImpl(hostName, storage);
                }
                catch (Exception e) {
                    LOGGER.throwing(HostProvider.class.getName(), "initPersistedHosts", e);
                    unresolvedHostsF.add(file);
                    unresolvedHostsS.add(hostName);
                }
                if (persistedHost == null) continue;
                hosts.add(persistedHost);
            }
            if (!unresolvedHostsF.isEmpty()) {
                HostProvider.notifyUnresolvedHosts(unresolvedHostsF, unresolvedHostsS);
            }
            RemoteHostsContainer.sharedInstance().getRepository().addDataSources(hosts);
        }
    }

    private static void notifyUnresolvedHosts(final Set<File> unresolvedHostsF, final Set<String> unresolvedHostsS) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Boolean b;
                String s = GlobalPreferences.sharedInstance().getDoNotShowAgain(HostProvider.DNSA_KEY);
                Boolean bl = b = s == null ? null : Boolean.valueOf(Boolean.parseBoolean(s));
                if (b == null) {
                    JPanel messagePanel = new JPanel(new BorderLayout(5, 5));
                    messagePanel.add((Component)new JLabel(NbBundle.getMessage(HostProvider.class, (String)"MSG_Unresolved_Hosts")), "North");
                    JList<Object> list = new JList<Object>(unresolvedHostsS.toArray());
                    list.setVisibleRowCount(4);
                    messagePanel.add((Component)new JScrollPane(list), "Center");
                    JCheckBox dnsa = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)dnsa, (String)NbBundle.getMessage(HostProvider.class, (String)"LBL_RememberAction"));
                    dnsa.setToolTipText(NbBundle.getMessage(HostProvider.class, (String)"TTP_RememberAction"));
                    JPanel p = new JPanel(new BorderLayout());
                    p.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 20));
                    p.add((Component)dnsa, "West");
                    messagePanel.add((Component)p, "South");
                    NotifyDescriptor dd = new NotifyDescriptor((Object)messagePanel, NbBundle.getMessage(HostProvider.class, (String)"Title_Unresolved_Hosts"), 0, 0, null, NotifyDescriptor.YES_OPTION);
                    Object ret = DialogDisplayer.getDefault().notify(dd);
                    if (ret == NotifyDescriptor.NO_OPTION) {
                        b = Boolean.FALSE;
                    } else if (ret == NotifyDescriptor.YES_OPTION) {
                        b = Boolean.TRUE;
                    }
                    if (dnsa.isSelected() && b != null) {
                        GlobalPreferences.sharedInstance().setDoNotShowAgain(HostProvider.DNSA_KEY, b.toString());
                    }
                }
                if (Boolean.FALSE.equals(b)) {
                    for (File file : unresolvedHostsF) {
                        Utils.delete((File)file, (boolean)true);
                    }
                }
                unresolvedHostsF.clear();
                unresolvedHostsS.clear();
            }
        }, 1000);
    }

    private void lockHosts() throws InterruptedException {
        this.hostsLockedSemaphore.acquire();
    }

    private void unlockHosts() {
        DataSource.EVENT_QUEUE.post(new Runnable(){

            @Override
            public void run() {
                HostProvider.this.hostsLockedSemaphore.release();
            }
        });
    }

    public void initialize() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        HostProvider.this.initLocalHost();
                        HostProvider.this.initUnknownHost();
                        HostProvider.this.initPersistedHosts();
                        HostProvider.this.unlockHosts();
                    }
                });
            }
        });
    }

    public HostProvider() {
        try {
            this.lockHosts();
        }
        catch (InterruptedException ex) {
            LOGGER.throwing(HostProvider.class.getName(), "<init>", ex);
        }
    }
}

