/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import org.jruby.Ruby;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.InvokeFailedException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.EmbedRubyRuntimeAdapterImpl;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.InstanceVariable;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyObjectAdapterImpl
implements EmbedRubyObjectAdapter {
    private final RubyObjectAdapter adapter = JavaEmbedUtils.newObjectAdapter();
    private final ScriptingContainer container;

    public EmbedRubyObjectAdapterImpl(ScriptingContainer container) {
        this.container = container;
    }

    @Override
    public boolean isKindOf(IRubyObject value2, RubyModule rubyModule) {
        return this.adapter.isKindOf(value2, rubyModule);
    }

    @Override
    public IRubyObject[] convertToJavaArray(IRubyObject array2) {
        return this.adapter.convertToJavaArray(array2);
    }

    @Override
    public RubyInteger convertToRubyInteger(IRubyObject obj) {
        return this.adapter.convertToRubyInteger(obj);
    }

    @Override
    public RubyString convertToRubyString(IRubyObject obj) {
        return this.adapter.convertToRubyString(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject setInstanceVariable(IRubyObject obj, String variableName, IRubyObject value2) {
        BiVariableMap map2;
        BiVariableMap biVariableMap = map2 = this.container.getVarMap();
        synchronized (biVariableMap) {
            if (map2.containsKey(variableName)) {
                BiVariable bv = map2.getVariable((RubyObject)this.container.getProvider().getRuntime().getTopSelf(), variableName);
                bv.setRubyObject(value2);
            } else {
                InstanceVariable iv = new InstanceVariable(obj, variableName, value2);
                map2.update(variableName, iv);
            }
        }
        return obj.getInstanceVariables().setInstanceVariable(variableName, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject getInstanceVariable(IRubyObject obj, String variableName) {
        BiVariableMap map2;
        BiVariableMap biVariableMap = map2 = this.container.getVarMap();
        synchronized (biVariableMap) {
            if (map2.containsKey(variableName)) {
                BiVariable bv = map2.getVariable((RubyObject)this.container.getProvider().getRuntime().getTopSelf(), variableName);
                return bv.getRubyObject();
            }
        }
        return null;
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName) {
        return this.adapter.callMethod(receiver2, methodName);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject singleArg) {
        return this.adapter.callMethod(receiver2, methodName, singleArg);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2) {
        return this.adapter.callMethod(receiver2, methodName, args2);
    }

    @Override
    public IRubyObject callMethod(IRubyObject receiver2, String methodName, IRubyObject[] args2, Block block) {
        return this.adapter.callMethod(receiver2, methodName, args2, block);
    }

    @Override
    public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2) {
        return this.adapter.callSuper(receiver2, args2);
    }

    @Override
    public IRubyObject callSuper(IRubyObject receiver2, IRubyObject[] args2, Block block) {
        return this.adapter.callSuper(receiver2, args2, block);
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD_NOARG, returnType, rubyReceiver, methodName, null, null, new Object[0]);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object singleArg, Class<T> returnType) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD, returnType, rubyReceiver, methodName, null, null, singleArg);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD, returnType, rubyReceiver, methodName, null, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD_WITHBLOCK, returnType, rubyReceiver, methodName, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD_NOARG, returnType, rubyReceiver, methodName, null, unit, new Object[0]);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType, EmbedEvalUnit unit) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD, returnType, rubyReceiver, methodName, null, unit, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD_WITHBLOCK, returnType, rubyReceiver, methodName, block, unit, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callSuper(Object receiver2, Object[] args2, Class<T> returnType) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLSUPER, returnType, rubyReceiver, null, null, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T callSuper(Object receiver2, Object[] args2, Block block, Class<T> returnType) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLSUPER_WITHBLOCK, returnType, rubyReceiver, null, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public Object callMethod(Object receiver2, String methodName, Object ... args2) {
        try {
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            if (args2.length == 0) {
                return this.call(MethodType.CALLMETHOD_NOARG, Object.class, rubyReceiver, methodName, null, null, new Object[0]);
            }
            return this.call(MethodType.CALLMETHOD, Object.class, rubyReceiver, methodName, null, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public Object callMethod(Object receiver2, String methodName, Block block, Object ... args2) {
        try {
            if (args2.length == 0) {
                throw new IllegalArgumentException("needs at least one argument in a method");
            }
            RubyObject rubyReceiver = this.getReceiverObject(receiver2);
            return this.call(MethodType.CALLMETHOD_WITHBLOCK, Object.class, rubyReceiver, methodName, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    @Override
    public <T> T runRubyMethod(Class<T> returnType, Object receiver2, String methodName, Block block, Object ... args2) {
        try {
            RubyObject rubyReceiver = (RubyObject)JavaEmbedUtils.javaToRuby(this.container.getProvider().getRuntime(), receiver2);
            if (args2.length == 0) {
                return this.call(MethodType.CALLMETHOD_NOARG, returnType, rubyReceiver, methodName, block, null, new Object[0]);
            }
            return this.call(MethodType.CALLMETHOD, returnType, rubyReceiver, methodName, block, null, args2);
        }
        catch (InvokeFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
    }

    private <T> T call(MethodType type2, Class<T> returnType, RubyObject rubyReceiver, String methodName, Block block, EmbedEvalUnit unit, Object ... args2) {
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        Ruby runtime2 = this.container.getProvider().getRuntime();
        boolean sharing_variables = true;
        Object obj = this.container.getAttribute((Object)AttributeName.SHARING_VARIABLES);
        if (obj != null && obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            sharing_variables = false;
        }
        if (sharing_variables) {
            ManyVarsDynamicScope scope = unit != null && unit.getScope() != null ? unit.getScope() : EmbedRubyRuntimeAdapterImpl.getManyVarsDynamicScope(this.container, 0);
            this.container.getVarMap().inject(scope, 0, rubyReceiver);
            runtime2.getCurrentContext().pushScope(scope);
        }
        try {
            IRubyObject result2 = this.callEachType(type2, rubyReceiver, methodName, block, args2);
            if (sharing_variables) {
                this.container.getVarMap().retrieve(rubyReceiver);
            }
            if (!(result2 instanceof RubyNil) && returnType != null) {
                Object ret = JavaEmbedUtils.rubyToJava(runtime2, result2, returnType);
                T t = ret != null ? (T)returnType.cast(ret) : null;
                return t;
            }
            T t = null;
            return t;
        }
        catch (RaiseException e) {
            runtime2.printError(e.getException());
            throw new InvokeFailedException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new InvokeFailedException(e);
        }
        finally {
            if (sharing_variables) {
                runtime2.getCurrentContext().popScope();
            }
        }
    }

    private RubyObject getReceiverObject(Object receiver2) {
        Ruby runtime2 = this.container.getProvider().getRuntime();
        if (receiver2 == null || !(receiver2 instanceof IRubyObject)) {
            return (RubyObject)runtime2.getTopSelf();
        }
        if (receiver2 instanceof RubyObject) {
            return (RubyObject)receiver2;
        }
        return (RubyObject)((IRubyObject)receiver2).getRuntime().getTopSelf();
    }

    private IRubyObject callEachType(MethodType type2, IRubyObject rubyReceiver, String methodName, Block block, Object ... args2) {
        Ruby runtime2 = rubyReceiver.getRuntime();
        IRubyObject[] rubyArgs = null;
        if (args2 != null && args2.length > 0) {
            rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime2, args2);
            for (int i2 = 0; i2 < rubyArgs.length; ++i2) {
                IRubyObject obj = rubyArgs[i2];
                if (!(obj instanceof JavaObject)) continue;
                rubyArgs[i2] = Java.wrap(runtime2, obj);
            }
        }
        ThreadContext context = runtime2.getCurrentContext();
        switch (type2) {
            case CALLMETHOD_NOARG: {
                return Helpers.invoke(context, rubyReceiver, methodName);
            }
            case CALLMETHOD: {
                return Helpers.invoke(context, rubyReceiver, methodName, rubyArgs);
            }
            case CALLMETHOD_WITHBLOCK: {
                return Helpers.invoke(context, rubyReceiver, methodName, rubyArgs, block);
            }
            case CALLSUPER: {
                return Helpers.invokeSuper(context, rubyReceiver, rubyArgs, Block.NULL_BLOCK);
            }
            case CALLSUPER_WITHBLOCK: {
                return Helpers.invokeSuper(context, rubyReceiver, rubyArgs, block);
            }
        }
        return null;
    }

    public static enum MethodType {
        CALLMETHOD_NOARG,
        CALLMETHOD,
        CALLMETHOD_WITHBLOCK,
        CALLSUPER,
        CALLSUPER_WITHBLOCK;

    }
}

