/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CY = "K\u0131br\u0131s";
        final String metaValue_ET = "Etiyopya";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_jv = "Cava Dili";
        final String metaValue_kn = "Kannada";
        final String metaValue_ml = "Malayalam";
        final String metaValue_ban = "Bali Dili";
        final String metaValue_bug = "Bugis";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_ssy = "Saho";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blis Sembolleri";
        final Object[][] data = new Object[][] {
            { "ksh", "K\u00f6ln Diyalekti" },
            { "Ogam", "Ogham" },
            { "mwl", "Miranda Dili" },
            { "key.colStrength", "S\u0131ralama G\u00fcc\u00fc" },
            { "Zsym", "Sembol" },
            { "cch", "Atsam" },
            { "mwr", "Marvari" },
            { "type.nu.lanatham", "Tai Tham Tham Rakamlar\u0131" },
            { "egl", "Emilia Dili" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanva" },
            { "%%NJIVA", "Gniva/Njiva Leh\u00e7esi" },
            { "xmf", "Megrelce" },
            { "egy", "Eski M\u0131s\u0131r Dili" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Ascension Adas\u0131" },
            { "rar", "Rarotongan" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "Birle\u015fik Arap Emirlikleri" },
            { "nl_BE", "Flamanca" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ve Barbuda" },
            { "type.ca.ethiopic", "Etiyopik Takvim" },
            { "glk", "Gilanice" },
            { "AI", "Anguilla" },
            { "key.tz", "Saat Dilimi" },
            { "AL", "Arnavutluk" },
            { "AM", "Ermenistan" },
            { "Teng", "Tengvar" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Arjantin" },
            { "Prti", "Part\u00e7a Kitabe Dili" },
            { "AS", "Amerikan Samoas\u0131" },
            { "AT", "Avusturya" },
            { "AU", "Avustralya" },
            { "AW", "Aruba" },
            { "en_US", "Amerikan \u0130ngilizcesi" },
            { "AX", "\u00c5land Adalar\u0131" },
            { "key.colNormalization", "Normalle\u015ftirilmi\u015f S\u0131ralama" },
            { "mye", "Myene" },
            { "AZ", "Azerbaycan" },
            { "%%AREVELA", "Do\u011fu Ermenicesi" },
            { "BA", "Bosna Hersek" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Banglade\u015f" },
            { "kum", "Kumuk\u00e7a" },
            { "BE", "Bel\u00e7ika" },
            { "gmh", "Orta\u00e7a\u011f Y\u00fcksek Almancas\u0131" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Bahreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivya" },
            { "BQ", "Karayip Hollanda" },
            { "BR", "Brezilya" },
            { "BS", "Bahamalar" },
            { "xog", "Soga" },
            { "BT", "Butan" },
            { "BV", "Bouvet Adas\u0131" },
            { "BW", "Botsvana" },
            { "BY", "Beyaz Rusya" },
            { "BZ", "Belize" },
            { "Visp", "Konu\u015fma Sesleri \u00c7izimlemesi" },
            { "type.ca.persian", "\u0130ran Takvimi" },
            { "type.nu.hebr", "\u0130brani Rakamlar\u0131" },
            { "CA", "Kanada" },
            { "CC", "Cocos (Keeling) Adalar\u0131" },
            { "mzn", "Mazenderanca" },
            { "CD", "Kongo - Kin\u015fasa" },
            { "CF", "Orta Afrika Cumhuriyeti" },
            { "CG", "Kongo - Brazavil" },
            { "CH", "\u0130svi\u00e7re" },
            { "CI", "Fildi\u015fi Sahili" },
            { "CK", "Cook Adalar\u0131" },
            { "CL", "\u015eili" },
            { "Kthi", "Kaithi" },
            { "CM", "Kamerun" },
            { "CN", "\u00c7in" },
            { "CO", "Kolombiya" },
            { "CP", "Clipperton Adas\u0131" },
            { "CR", "Kosta Rika" },
            { "CU", "K\u00fcba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Adas\u0131" },
            { "CY", metaValue_CY },
            { "type.nu.bali", "Bali Rakamlar\u0131" },
            { "CZ", "\u00c7ek Cumhuriyeti" },
            { "eka", "Ekajuk" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "Bat\u0131 Flamanca" },
            { "DE", "Almanya" },
            { "goh", "Eski Y\u00fcksek Almanca" },
            { "ace", "Achinese" },
            { "cgg", "Kigaca" },
            { "DG", "Diego Garcia" },
            { "gom", "Goa Konkanicesi" },
            { "type.nu.deva", "Devanagari Rakamlar\u0131" },
            { "DJ", "Cibuti" },
            { "type.colNumeric.no", "Rakamlar\u0131 Ayr\u0131 S\u0131ralama" },
            { "DK", "Danimarka" },
            { "ach", "Acoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "K\u00fc\u00e7\u00fck Harf Ermeni Rakamlar\u0131" },
            { "DO", "Dominik Cumhuriyeti" },
            { "gor", "Gorontalo" },
            { "got", "Got\u00e7a" },
            { "vmf", "Main Frankonya Dili" },
            { "Mtei", "Meitei Mayek" },
            { "key.variableTop", "Sembollere G\u00f6re S\u0131ralama" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Cezayir" },
            { "pag", "Pangasinan" },
            { "pal", "Pehlevi Dili" },
            { "EA", "Septe ve Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ekvador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estonya" },
            { "tiv", "Tiv" },
            { "EG", "M\u0131s\u0131r" },
            { "EH", "Bat\u0131 Sahara" },
            { "chg", "\u00c7a\u011fatay Dili" },
            { "pau", "Palau Dili" },
            { "type.colNormalization.yes", "Unicode Normalle\u015ftirilmi\u015f Olarak S\u0131ralama" },
            { "chk", "Chuukese" },
            { "chn", "Chinook Jargon" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Choctaw" },
            { "chr", "\u00c7erokice" },
            { "ER", "Eritre" },
            { "ES", "\u0130spanya" },
            { "ET", metaValue_ET },
            { "EU", "Avrupa Birli\u011fi" },
            { "elx", "Elam" },
            { "type.ca.gregorian", "Miladi Takvim" },
            { "chy", "\u015eayen Dili" },
            { "type.nu.gujr", "G\u00fccerat Rakamlar\u0131" },
            { "Inds", "Indus" },
            { "ady", "Adigece" },
            { "aeb", "Tunus Arap\u00e7as\u0131" },
            { "FI", "Finlandiya" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Adalar\u0131" },
            { "FM", "Mikronezya" },
            { "key.va", "Yerel Varyant" },
            { "FO", "Faroe Adalar\u0131" },
            { "Taml", "Tamil" },
            { "FR", "Fransa" },
            { "Kpel", metaValue_kpe },
            { "pcd", "Picard Dili" },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "K\u00f6ken" },
            { "type.ca.indian", "Ulusal Hint Takvimi" },
            { "rgn", "Romanyolca" },
            { "grc", "Antik Yunanca" },
            { "GA", "Gabon" },
            { "tkr", "Sahurca" },
            { "vot", "Votic" },
            { "GB", "Birle\u015fik Krall\u0131k" },
            { "GD", "Grenada" },
            { "GE", "G\u00fcrcistan" },
            { "GF", "Frans\u0131z Guyanas\u0131" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "Tale", "Tai Le" },
            { "GI", "Cebelitar\u0131k" },
            { "afh", "Afrihili" },
            { "GL", "Gr\u00f6nland" },
            { "enm", "Orta\u00e7a\u011f \u0130ngilizcesi" },
            { "GM", "Gambiya" },
            { "GN", "Gine" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekvator Ginesi" },
            { "GR", "Yunanistan" },
            { "GS", "G\u00fcney Georgia ve G\u00fcney Sandwich Adalar\u0131" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Pensilvanya Almancas\u0131" },
            { "GW", "Gine-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingonca" },
            { "Talu", "New Tai Lue" },
            { "GY", "Guyana" },
            { "ckb", "Orta K\u00fcrt\u00e7e" },
            { "zxx", "Dilbilim i\u00e7eri\u011fi yok" },
            { "Jurc", "Jurchen" },
            { "tly", "Tal\u0131\u015f\u00e7a" },
            { "pdt", "Plautdietsch" },
            { "de_AT", "Avusturya Almancas\u0131" },
            { "Vaii", metaValue_vai },
            { "HK", "\u00c7in Hong Kong \u00d6YB" },
            { "HM", "Heard Adas\u0131 ve McDonald Adalar\u0131" },
            { "HN", "Honduras" },
            { "HR", "H\u0131rvatistan" },
            { "agq", "Aghem" },
            { "gsw", "\u0130svi\u00e7re Almancas\u0131" },
            { "type.ca.islamic-umalqura", "Hicri Takvim (\u00dcmm\u00fc-l Kurra Takvimi)" },
            { "HT", "Haiti" },
            { "HU", "Macaristan" },
            { "rif", "Rif Berbericesi" },
            { "tmh", "Tama\u015fek" },
            { "IC", "Kanarya Adalar\u0131" },
            { "nan", "Min Nan \u00c7incesi" },
            { "ID", "Endonezya" },
            { "peo", "Eski Fars\u00e7a" },
            { "type.nu.kali", "Kayah Li Rakamlar\u0131" },
            { "IE", "\u0130rlanda" },
            { "nap", "Napolice" },
            { "naq", "Nama" },
            { "zza", "Zazaca" },
            { "Tang", "Tangut" },
            { "IL", "\u0130srail" },
            { "Nbat", "Nebati" },
            { "IM", "Man Adas\u0131" },
            { "IN", "Hindistan" },
            { "type.co.eor", "Avrupa S\u0131ralama Kurallar\u0131" },
            { "IO", "Britanya Hint Okyanusu Topraklar\u0131" },
            { "IQ", "Irak" },
            { "IR", "\u0130ran" },
            { "IS", "\u0130zlanda" },
            { "IT", "\u0130talya" },
            { "Zmth", "Matematiksel G\u00f6sterim" },
            { "type.nu.thai", "Tay Rakamlar\u0131" },
            { "vro", "V\u00f5ro" },
            { "guc", "Wayuu" },
            { "%%POSIX", "Bilgisayar" },
            { "type.nu.beng", "Bengal Rakamlar\u0131" },
            { "pfl", "Palatin Almancas\u0131" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Hicri Takvim" },
            { "JM", "Jamaika" },
            { "Beng", "Bengal" },
            { "JO", "\u00dcrd\u00fcn" },
            { "gur", "Frafra" },
            { "JP", "Japonya" },
            { "%%1606NICT", "1606\u2018ya Dek Ge\u00e7 Orta\u00e7a\u011f Frans\u0131zcas\u0131" },
            { "ain", "Ayni Dili" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "Kannada Rakamlar\u0131" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "\u0130svi\u00e7re Y\u00fcksek Almancas\u0131" },
            { "type.co.phonetic", "Fonetik S\u0131ralama D\u00fczeni" },
            { "izh", "\u0130ngriya Dili" },
            { "type.ca.buddhist", "Budist Takvimi" },
            { "KE", "Kenya" },
            { "419", "Latin Amerika" },
            { "KG", "K\u0131rg\u0131zistan" },
            { "KH", "Kambo\u00e7ya" },
            { "KI", "Kiribati" },
            { "KM", "Komorlar" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts ve Nevis" },
            { "Zinh", "Kal\u0131tsal" },
            { "fr_CA", "Kanada Frans\u0131zcas\u0131" },
            { "KP", "Kuzey Kore" },
            { "KR", "G\u00fcney Kore" },
            { "Plrd", "Pollard Fonetik" },
            { "fr_CH", "\u0130svi\u00e7re Frans\u0131zcas\u0131" },
            { "KW", "Kuveyt" },
            { "tpi", "Tok Pisin" },
            { "KY", "Cayman Adalar\u0131" },
            { "KZ", "Kazakistan" },
            { "Cyrl", "Kiril" },
            { "LA", "Laos" },
            { "LB", "L\u00fcbnan" },
            { "LC", "Saint Lucia" },
            { "phn", "Fenike Dili" },
            { "Cyrs", "Eski Kilise Slavcas\u0131 Kiril" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "A\u015fa\u011f\u0131 Almanca" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akad Dili" },
            { "cop", "K\u0131ptice" },
            { "LR", "Liberya" },
            { "esu", "Merkezi Yupik\u00e7e" },
            { "LS", "Lesoto" },
            { "Phlv", "Kitap Pehlevi Dili" },
            { "LT", "Litvanya" },
            { "LU", "L\u00fcksemburg" },
            { "LV", "Letonya" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libya" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabamaca" },
            { "lah", "Lahnda" },
            { "Mahj", "Mahajani" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Fas" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "Nshu", "N\u00fcshu" },
            { "ME", "Karada\u011f" },
            { "MF", "Saint Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall Adalar\u0131" },
            { "ale", "Aleut" },
            { "Thai", "Tay" },
            { "type.nu.vaii", "Vai Rakamlar\u0131" },
            { "MK", "Makedonya" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mo\u011folistan" },
            { "new", "Nevari" },
            { "MO", "\u00c7in Makao \u00d6YB" },
            { "aln", "Gheg Arnavut\u00e7as\u0131" },
            { "MP", "Kuzey Mariana Adalar\u0131" },
            { "MQ", "Martinik" },
            { "MR", "Moritanya" },
            { "MS", "Montserrat" },
            { "type.colAlternate.non-ignorable", "Sembolleri S\u0131ralama" },
            { "MT", "Malta" },
            { "cps", "Capiznon" },
            { "MU", "Mauritius" },
            { "alt", "G\u00fcney Altayca" },
            { "MV", "Maldivler" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "type.ca.japanese", "Japon Takvimi" },
            { "MY", "Malezya" },
            { "MZ", "Mozambik" },
            { "Phli", "Pehlevi Kitabe Dili" },
            { "NA", "Namibya" },
            { "type.ca.hebrew", "Yahudi Takvimi" },
            { "type.co.dictionary", "S\u00f6zl\u00fck S\u0131ralama D\u00fczeni" },
            { "NC", "Yeni Kaledonya" },
            { "%%WADEGILE", "Wade-Giles (Latin Alfabesinde Yaz\u0131m\u0131)" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "G\u00f6zden Ge\u00e7irilmi\u015f Birle\u015ftirilmi\u015f Yaz\u0131m Kurallar\u0131" },
            { "NE", "Nijer" },
            { "NF", "Norfolk Adas\u0131" },
            { "NG", "Nijerya" },
            { "trv", "Taroko" },
            { "Phlp", "Psalter Pehlevi" },
            { "NI", "Nikaragua" },
            { "Hmng", "Pahavh Hmong" },
            { "NL", "Hollanda" },
            { "NO", "Norve\u00e7" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "tsd", "Tsakonca" },
            { "NU", "Niue" },
            { "Phnx", "Fenike" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshian" },
            { "NZ", "Yeni Zelanda" },
            { "Merc", "Meroitik El Yaz\u0131s\u0131" },
            { "rom", "Romanca" },
            { "Mero", "Meroitik" },
            { "crh", "K\u0131r\u0131m T\u00fcrk\u00e7esi" },
            { "type.colAlternate.shifted", "Sembolleri Yoksayarak S\u0131ralama" },
            { "ang", "Eski \u0130ngilizce" },
            { "OM", "Umman" },
            { "anp", "Angika" },
            { "Xpeo", "Eski Fars" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Arap Takvimi" },
            { "csb", "Kashubian" },
            { "en_GB", "\u0130ngiliz \u0130ngilizcesi" },
            { "PE", "Peru" },
            { "ttt", "Tat\u00e7a" },
            { "PF", "Frans\u0131z Polinezyas\u0131" },
            { "PG", "Papua Yeni Gine" },
            { "PH", "Filipinler" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre ve Miquelon" },
            { "PN", "Pitcairn Adalar\u0131" },
            { "type.colBackwards.yes", "Aksanlar\u0131 Ters S\u0131ralama" },
            { "PR", "Porto Riko" },
            { "Bali", metaValue_ban },
            { "PS", "Filistin B\u00f6lgeleri" },
            { "PT", "Portekiz" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "K\u00fc\u00e7\u00fck Harf Yunan Rakamlar\u0131" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", "\u0130brani" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "Standart \u0130sko\u00e7 \u0130ngilizcesi" },
            { "jam", "Jamaika Patois Dili" },
            { "pms", "Piyemontece" },
            { "niu", "Niuean" },
            { "QO", "Uzak Okyanusya" },
            { "ext", "Ekstremadura Dili" },
            { "lez", "Lezgice" },
            { "%%FONUPA", "UPA Ses Bilimi" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "001", "D\u00fcnya" },
            { "002", "Afrika" },
            { "njo", "Ao Naga" },
            { "003", "Kuzey Amerika" },
            { "RE", "R\u00e9union" },
            { "type.colNormalization.no", "Normalle\u015ftirme Olmadan S\u0131ralama" },
            { "005", "G\u00fcney Amerika" },
            { "lfn", "Lingua Franca Nova" },
            { "jbo", "Lojban" },
            { "pnt", "Kuzeybat\u0131 Kafkasya" },
            { "Rjng", "Rejang" },
            { "009", "Okyanusya" },
            { "RO", "Romanya" },
            { "RS", "S\u0131rbistan" },
            { "Mroo", "Mro" },
            { "RU", "Rusya" },
            { "RW", "Ruanda" },
            { "Mani", "Mani" },
            { "Ugar", "Ugarit \u00c7ivi Yaz\u0131s\u0131" },
            { "key.colAlternate", "Sembolleri S\u0131ralamay\u0131 Yoksayma" },
            { "Khar", "Kharoshthi" },
            { "SA", "Suudi Arabistan" },
            { "pon", "Pohnpeian" },
            { "Mand", "Manden" },
            { "SB", "Solomon Adalar\u0131" },
            { "twq", "Tasawaq" },
            { "011", "Bat\u0131 Afrika" },
            { "SC", "Sey\u015feller" },
            { "SD", "Sudan" },
            { "013", "Orta Amerika" },
            { "SE", "\u0130sve\u00e7" },
            { "014", "Do\u011fu Afrika" },
            { "arc", "Aramice" },
            { "Loma", "Loma" },
            { "015", "Kuzey Afrika" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "strict" },
            { "017", "Orta Afrika" },
            { "SI", "Slovenya" },
            { "018", "Afrika\u2019n\u0131n G\u00fcneyi" },
            { "SJ", "Svalbard ve Jan Mayen Adalar\u0131" },
            { "019", "Amerika" },
            { "SK", "Slovakya" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "arn", "Araukanya Dili" },
            { "arp", "Arapaho Dili" },
            { "type.nu.taml", "Geleneksel Tamil Rakamlar\u0131" },
            { "SR", "Surinam" },
            { "aro", "Araona" },
            { "SS", "G\u00fcney Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 ve Pr\u00edncipe" },
            { "arq", "Cezayir Arap\u00e7as\u0131" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Suriye" },
            { "yao", "Yao" },
            { "SZ", "Svaziland" },
            { "arw", "Arawak Dili" },
            { "arz", "M\u0131s\u0131r Arap\u00e7as\u0131" },
            { "ary", "Fas Arap\u00e7as\u0131" },
            { "yap", "Yap\u00e7a" },
            { "rtm", "Rotuman" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "ABD \u00d6l\u00e7\u00fc Sistemi" },
            { "021", "Amerika\u2019n\u0131n Kuzeyi" },
            { "TC", "Turks ve Caicos Adalar\u0131" },
            { "yav", "Yangben" },
            { "TD", "\u00c7ad" },
            { "TF", "Frans\u0131z G\u00fcney Topraklar\u0131" },
            { "ase", "Amerikan \u0130\u015faret Dili" },
            { "TG", "Togo" },
            { "TH", "Tayland" },
            { "TJ", "Tacikistan" },
            { "TK", metaValue_TK },
            { "029", "Karayipler" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Hangul \u0130lk Sessiz Harfe G\u00f6re Arama" },
            { "TM", "T\u00fcrkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunus" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkiye" },
            { "TT", "Trinidad ve Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Tayvan" },
            { "ast", "Asturyasca" },
            { "rue", "Rusince" },
            { "rug", "Roviana" },
            { "Orkh", "Orhun" },
            { "TZ", "Tanzanya" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Bilinmeyen Alfabe" },
            { "Sind", "Khudabadi" },
            { "UA", "Ukrayna" },
            { "lij", "Ligurca" },
            { "rup", "Ulah\u00e7a" },
            { "030", "Do\u011fu Asya" },
            { "tyv", "Tuvaca" },
            { "sw_CD", "Kongo Svahili" },
            { "034", "G\u00fcney Asya" },
            { "hai", "Haida" },
            { "035", "G\u00fcneydo\u011fu Asya" },
            { "UG", "Uganda" },
            { "hak", "Hakka \u00c7incesi" },
            { "type.co.pinyin", "Basitle\u015ftirilmi\u015f \u00c7ince Pinyin S\u0131ralamas\u0131" },
            { "type.colHiraganaQuaternary.yes", "Kana\u2019y\u0131 Farkl\u0131 S\u0131ralama" },
            { "039", "G\u00fcney Avrupa" },
            { "Sinh", "Seylan" },
            { "UM", "ABD Uzak Adalar\u0131" },
            { "liv", "Livonca" },
            { "US", "ABD" },
            { "haw", "Hawaii Dili" },
            { "%%1959ACAD", "Akademik" },
            { "type.co.gb2312han", "Basitle\u015ftirilmi\u015f \u00c7ince S\u0131ralamas\u0131 - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Prusyaca" },
            { "UZ", "\u00d6zbekistan" },
            { "tzm", "Orta Fas Tamazigti" },
            { "type.co.stroke", "Geleneksel \u00c7ince Vuru\u015f S\u0131ralamas\u0131" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatikan" },
            { "pro", "Eski Provensal" },
            { "VC", "Saint Vincent ve Grenadinler" },
            { "VE", "Venezuela" },
            { "VG", "Britanya Virjin Adalar\u0131" },
            { "VI", "ABD Virjin Adalar\u0131" },
            { "VN", "Vietnam" },
            { "type.colBackwards.no", "Aksanlar\u0131 Normal Olarak S\u0131ralama" },
            { "VU", "Vanuatu" },
            { "nog", "Nogayca" },
            { "rwk", "Rwa" },
            { "non", "Eski Norse" },
            { "053", "Avustralasya" },
            { "%%AREVMDA", "Bat\u0131 Ermenicesi" },
            { "054", "Melanezya" },
            { "WF", "Wallis ve Futuna Adalar\u0131" },
            { "type.co.traditional", "Geleneksel S\u0131ralama" },
            { "057", "Mikronezya B\u00f6lgesi" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakotaca" },
            { "nov", "Novial" },
            { "type.nu.finance", "Finansal Say\u0131lar" },
            { "avk", "Kotava" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Meetei Mayek Rakamlar\u0131" },
            { "wal", "Valamo" },
            { "was", "Va\u015fo" },
            { "war", "Varay" },
            { "awa", "Awadhi" },
            { "061", "Polinezya" },
            { "XK", "Kosova" },
            { "type.nu.brah", "Brahmi Rakamlar\u0131" },
            { "Gujr", "G\u00fccerat" },
            { "Zxxx", "Yaz\u0131l\u0131 Olmayan" },
            { "Olck", "Ol Chiki" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Yemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Standart S\u0131ralama" },
            { "lmo", "Lombard\u00e7a" },
            { "fan", "Fang" },
            { "%%ROZAJ", "Resia Leh\u00e7esi" },
            { "fat", "Fanti" },
            { "Sgnw", "\u0130\u015faret Dili" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Cham Rakamlar\u0131" },
            { "ZA", "G\u00fcney Afrika" },
            { "type.lb.loose", "loose" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "G\u00fcrc\u00fc Rakamlar\u0131" },
            { "type.co.zhuyin", "Zhuyin S\u0131ralamas\u0131" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambiya" },
            { "%%PINYIN", "Pinyin (Latin Alfabesinde Yaz\u0131m\u0131)" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Bilinmeyen B\u00f6lge" },
            { "Runr", "Runik" },
            { "type.ms.metric", "Metrik Sistem" },
            { "type.ca.iso8601", "ISO-8601 Takvimi" },
            { "lol", "Mongo" },
            { "nso", "Kuzey Sotho" },
            { "type.nu.telu", "Telugu Rakamlar\u0131" },
            { "loz", "Lozi" },
            { "Nkgb", "Naksi Geba" },
            { "type.colHiraganaQuaternary.no", "Kana\u2019y\u0131 Ayr\u0131 S\u0131ralama" },
            { "jmc", "Machame" },
            { "hif", "Fiji Hint\u00e7esi" },
            { "type.nu.hansfin", "Finansal Basitle\u015ftirilmi\u015f \u00c7in Rakamlar\u0131" },
            { "type.colStrength.secondary", "Aksanlar\u0131 S\u0131ralama" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Geni\u015fletilmi\u015f Hint-Arap Rakamlar\u0131" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Tam Geni\u015flikte Rakamlar" },
            { "hit", "Hitit\u00e7e" },
            { "dar", "Dargince" },
            { "dav", "Taita" },
            { "Maya", "Maya Hiyeroglifleri" },
            { "lrc", "Kuzey Luri" },
            { "Copt", "K\u0131pti" },
            { "nwc", "Klasik Nevari" },
            { "udm", "Udmurt\u00e7a" },
            { "Khmr", "Kmer" },
            { "type.ca.islamic-rgsa", "Hicri Takvim (Suudi)" },
            { "Limb", "Limbu" },
            { "sad", "Sandave" },
            { "type.nu.roman", "Roma Rakamlar\u0131" },
            { "sah", "Yakut\u00e7a" },
            { "ltg", "Latgalian" },
            { "sam", "Samarit Aramcas\u0131" },
            { "Aghb", "Kafkas Albanyas\u0131" },
            { "%%SCOUSE", "Scouse" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "saz", metaValue_saz },
            { "jpr", "Yahudi Fars\u00e7as\u0131" },
            { "type.nu.native", "Yerel Rakamlar" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamvezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipince" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Lushai" },
            { "bal", "Baluchi" },
            { "den", "Slavey" },
            { "ban", metaValue_ban },
            { "uga", "Ugarit Dili" },
            { "fit", "Tornedalin Fincesi" },
            { "luy", "Luyia" },
            { "bar", "Bavyera Dili" },
            { "bas", "Basa Dili" },
            { "bax", "Bamun" },
            { "jrb", "Yahudi Arap\u00e7as\u0131" },
            { "es_ES", "Avrupa \u0130spanyolcas\u0131" },
            { "nzi", "Nzima" },
            { "sco", "Scots" },
            { "scn", "Sicilyaca" },
            { "aa", "Afar" },
            { "ab", "Abhazca" },
            { "bbc", "Batak Toba" },
            { "key.colCaseFirst", "B\u00fcy\u00fck/K\u00fc\u00e7\u00fck Harf S\u0131ralama" },
            { "ae", "Avest\u00e7e" },
            { "af", "Afrikaanca" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Chakma Rakamlar\u0131" },
            { "bbj", "Ghomala" },
            { "am", "Amharca" },
            { "an", "Aragonca" },
            { "Arab", "Arap" },
            { "%%SOLBA", "Stolvizza/Solbica Leh\u00e7esi" },
            { "Jpan", "Japon" },
            { "ar", "Arap\u00e7a" },
            { "Hrkt", "Katakana veya Hiragana" },
            { "as", "Assamca" },
            { "sdc", "Sassari Sarduca" },
            { "Lina", "Lineer A" },
            { "av", "Avar Dili" },
            { "Linb", "Lineer B" },
            { "sdh", "G\u00fcney K\u00fcrt\u00e7esi" },
            { "ay", "Aymara" },
            { "az", "Azerice" },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Oseacco/Osojane Leh\u00e7esi" },
            { "ba", "Ba\u015fk\u0131rt\u00e7a" },
            { "type.co.unihan", "Radical-Stroke S\u0131ralama D\u00fczeni" },
            { "be", "Beyaz Rus\u00e7a" },
            { "bg", "Bulgarca" },
            { "bi", "Bislama" },
            { "type.nu.java", "Cava Rakamlar\u0131" },
            { "bm", "Bambara" },
            { "bn", "Bengalce" },
            { "bo", "Tibet\u00e7e" },
            { "dgr", "Dogrib" },
            { "br", "Bretonca" },
            { "bs", "Bo\u015fnak\u00e7a" },
            { "see", "Seneca" },
            { "Mymr", "Burma" },
            { "sei", "Seri" },
            { "type.nu.laoo", "Lao Rakamlar\u0131" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkup" },
            { "ca", "Katalanca" },
            { "ses", "Koyraboro Senni" },
            { "ce", "\u00c7e\u00e7ence" },
            { "ch", "Chamorro" },
            { "%%REVISED", "G\u00f6zden Ge\u00e7irilmi\u015f Yaz\u0131m Kurallar\u0131" },
            { "co", "Korsikaca" },
            { "Orya", "Oriya" },
            { "cr", "Cree" },
            { "cs", "\u00c7ek\u00e7e" },
            { "cu", "Kilise Slavcas\u0131" },
            { "yrl", "Nheengatu" },
            { "cv", "\u00c7uva\u015f\u00e7a" },
            { "cy", "Galce" },
            { "type.nu.ethi", "Ge\u2019ez Rakamlar\u0131" },
            { "Yiii", "Yi" },
            { "da", "Danca" },
            { "pt_PT", "Avrupa Portekizcesi" },
            { "de", "Almanca" },
            { "bej", "Beja Dili" },
            { "din", "Dinka" },
            { "jut", "Yutland Dili" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Eski \u0130rlandaca" },
            { "type.nu.mong", "Mo\u011folca Rakamlar" },
            { "dv", "Divehi" },
            { "es_419", "Latin Amerika \u0130spanyolcas\u0131" },
            { "bew", "Betawi" },
            { "dz", "Butan Dili" },
            { "bez", "Bena" },
            { "type.ca.chinese", "\u00c7in Takvimi" },
            { "lzh", "Edebi \u00c7ince" },
            { "Lisu", "Fraser" },
            { "dje", "Zarma" },
            { "sgs", "Samogit\u00e7e" },
            { "type.nu.grek", "Yunan Rakamlar\u0131" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "normal" },
            { "ro_MD", "Moldovaca" },
            { "el", "Yunanca" },
            { "en", "\u0130ngilizce" },
            { "eo", "Esperanto" },
            { "bfq", "Badaga" },
            { "lzz", "Lazca" },
            { "type.co.big5han", "Geleneksel \u00c7ince S\u0131ralamas\u0131 - Big5" },
            { "es", "\u0130spanyolca" },
            { "et", "Estonca" },
            { "eu", "Bask\u00e7a" },
            { "Buhd", "Buhid" },
            { "Hang", "Hang\u0131l" },
            { "Samr", "Samarit" },
            { "shi", "Ta\u015felhit" },
            { "hsb", "Yukar\u0131 Sorb\u00e7a" },
            { "Hani", "Han" },
            { "shn", "Shan Dili" },
            { "Hano", "Hanunoo" },
            { "fa", "Fars\u00e7a" },
            { "Hans", "Basitle\u015ftirilmi\u015f" },
            { "type.nu.latn", "Bat\u0131 Rakamlar\u0131" },
            { "Hant", "Geleneksel" },
            { "az_Arab", "G\u00fcney Azerice" },
            { "ff", "Fulah" },
            { "shu", "\u00c7ad Arap\u00e7as\u0131" },
            { "hsn", "Xiang \u00c7incesi" },
            { "fi", "Fince" },
            { "fj", "Fiji Dili" },
            { "fon", "Fon" },
            { "bgn", "Bat\u0131 Balochi" },
            { "yue", "Kantonca" },
            { "fo", "Faroe Dili" },
            { "umb", "Umbundu" },
            { "fr", "Frans\u0131zca" },
            { "sid", "Sidamo" },
            { "fy", "Bat\u0131 Frizcesi" },
            { "ga", "\u0130rlandaca" },
            { "gd", "\u0130sko\u00e7 Gal Dili" },
            { "key.colCaseLevel", "B\u00fcy\u00fck/K\u00fc\u00e7\u00fck Harfe Duyarl\u0131 S\u0131ralama" },
            { "gl", "Gali\u00e7yaca" },
            { "gn", "Guarani Dili" },
            { "bho", "Arayanice" },
            { "und", "Bilinmeyen Dil" },
            { "type.ca.ethiopic-amete-alem", "Etiyopik Amete Alem Takvimi" },
            { "gu", "G\u00fccerat\u00e7a" },
            { "type.ca.islamic-tbla", "Hicri Takvim (Astronomik Evreler)" },
            { "gv", "Manks" },
            { "ha", "Hausa" },
            { "he", "\u0130branice" },
            { "hi", "Hint\u00e7e" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", "H\u0131rvat\u00e7a" },
            { "ht", "Haiti Dili" },
            { "hu", "Macarca" },
            { "hy", "Ermenice" },
            { "hz", "Herero" },
            { "frc", "Cajun Frans\u0131zcas\u0131" },
            { "%%FONIPA", "IPA Ses Bilimi" },
            { "ia", "Interlingua" },
            { "id", "Endonezce" },
            { "type.nu.tibt", "Tibet Rakamlar\u0131" },
            { "ie", "Interlingue" },
            { "ig", "\u0130bo Dili" },
            { "ii", "Sichuan Yi" },
            { "frm", "Orta\u00e7a\u011f Frans\u0131zcas\u0131" },
            { "ik", "Inupiak" },
            { "fro", "Eski Frans\u0131zca" },
            { "frp", "Arpitanca" },
            { "io", "Ido" },
            { "frs", "Do\u011fu Frizcesi" },
            { "bjn", "Banjar Dili" },
            { "frr", "Kuzey Frizce" },
            { "is", "\u0130zlandaca" },
            { "it", "\u0130talyanca" },
            { "iu", "Inuktitut" },
            { "sli", "A\u015fa\u011f\u0131 Silezyaca" },
            { "Mlym", metaValue_ml },
            { "ja", "Japonca" },
            { "Sarb", "Eski G\u00fcney Arap" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "type.nu.lepc", "Lep\u00e7a Rakamlar\u0131" },
            { "bkm", "Kom" },
            { "sma", "G\u00fcney Sami" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavian" },
            { "mad", "Madura Dili" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", "G\u00fcrc\u00fcce" },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "wuu", "Wu \u00c7incesi" },
            { "sms", "Skolt Sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", "Gotik" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazak\u00e7a" },
            { "kl", "Gr\u00f6nland Dili" },
            { "km", "Kmerce" },
            { "kn", metaValue_kn },
            { "type.colStrength.identical", "T\u00fcm\u00fcn\u00fc S\u0131ralama" },
            { "ko", "Korece" },
            { "kr", "Kanuri" },
            { "ks", "Ke\u015fmirce" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", "Avesta" },
            { "ku", "K\u00fcrt\u00e7e" },
            { "kv", "Komi" },
            { "kw", "Kernevek\u00e7e" },
            { "ky", "K\u0131rg\u0131zca" },
            { "snk", "Soninke" },
            { "type.colStrength.primary", "Yaln\u0131zca Taban Harflerini S\u0131ralama" },
            { "la", "Latince" },
            { "lb", "L\u00fcksemburgca" },
            { "type.nu.mlym", "Malayalam Rakamlar\u0131" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgca" },
            { "Tibt", "Tibet" },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "type.colCaseLevel.no", "B\u00fcy\u00fck/K\u00fc\u00e7\u00fck Harfe Duyarl\u0131 Olmadan S\u0131ralama" },
            { "lo", "Laoca" },
            { "type.colStrength.tertiary", "Aksanlar\u0131/B\u00fcy\u00fck-K\u00fc\u00e7\u00fck Harfleri/Geni\u015fli\u011fi S\u0131ralama" },
            { "type.nu.lana", "Tai Tham Hora Rakamlar\u0131" },
            { "lt", "Litvanca" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letonca" },
            { "sog", "Sogdiana Dili" },
            { "mg", "Malga\u015f\u00e7a" },
            { "mh", "Marshall Adalar\u0131 Dili" },
            { "type.co.ducet", "Saptanm\u0131\u015f Unicode S\u0131ralamas\u0131" },
            { "mi", "Maori Dili" },
            { "mk", "Makedonca" },
            { "ml", metaValue_ml },
            { "mn", "Mo\u011folca" },
            { "mr", "Marathi" },
            { "ms", "Malayca" },
            { "mt", "Maltaca" },
            { "Saur", metaValue_saz },
            { "my", "Burmaca" },
            { "Armn", "Ermeni" },
            { "mdf", "Mok\u015fa Dili" },
            { "mde", "Maba" },
            { "dsb", "A\u015fa\u011f\u0131 Sorb\u00e7a" },
            { "Armi", "\u0130mparatorluk Aramicesi" },
            { "na", "Nauru Dili" },
            { "type.co.search", "Genel Ama\u00e7l\u0131 Arama" },
            { "nb", "Norve\u00e7\u00e7e Bokm\u00e5l" },
            { "nd", "Kuzey Ndebele" },
            { "ne", "Nepalce" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", "Hollandaca" },
            { "nn", "Norve\u00e7\u00e7e Nynorsk" },
            { "no", "Norve\u00e7\u00e7e" },
            { "nr", "G\u00fcney Ndebele" },
            { "nv", "Navaho Dili" },
            { "kaa", "Karakalpak\u00e7a" },
            { "ny", "Nyanja" },
            { "kac", "Ka\u00e7in" },
            { "kab", "Kabiliyece" },
            { "%%POLYTON", "Politonik" },
            { "type.colCaseFirst.lower", "\u00d6nce K\u00fc\u00e7\u00fck Harfleri S\u0131ralama" },
            { "oc", "Occitan" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "oj", "Ojibva Dili" },
            { "mer", "Meru" },
            { "type.nu.armn", "Ermeni Rakamlar\u0131" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "dtp", "Orta Kadazan" },
            { "or", "Oriya Dili" },
            { "Modi", "Modi" },
            { "os", "Oset\u00e7e" },
            { "bpy", "Bishnupriya" },
            { "kbd", "Kabardeyce" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Pencap\u00e7a" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Resia Lipovaz Leh\u00e7esi" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "bqi", "Bahtiyari" },
            { "pl", "Leh\u00e7e" },
            { "dum", "Orta\u00e7a\u011f Felemenk\u00e7esi" },
            { "type.ca.dangi", "Dangi Takvimi" },
            { "ps", "Pe\u015ftuca" },
            { "pt", "Portekizce" },
            { "mga", "Orta\u00e7a\u011f \u0130rlandacas\u0131" },
            { "key.co", "S\u0131ralama D\u00fczeni" },
            { "pt_BR", "Brezilya Portekizcesi" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "type.nu.nkoo", "N\u2019Ko Rakamlar\u0131" },
            { "bra", "Braj" },
            { "key.ca", "Takvim" },
            { "Laoo", "Lao" },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "24 Saat Sistemi (0\u201323)" },
            { "type.hc.h24", "24 Saat Sistemi (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "Brohice" },
            { "type.nu.mymr", "Myanmar Rakamlar\u0131" },
            { "qu", "Ke\u00e7uvaca" },
            { "zap", "Zapotek Dili" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "Ethi", metaValue_ET },
            { "stq", "Saterland Frizcesi" },
            { "type.hc.h12", "12 Saat Sistemi (1\u201312)" },
            { "type.hc.h11", "12 Saat Sistemi (0\u201311)" },
            { "rm", "Roman\u015f\u00e7a" },
            { "rn", "Kirundi" },
            { "key.cu", "Para Birimi" },
            { "ro", "Romence" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Oriya Rakamlar\u0131" },
            { "type.nu.hanidec", "\u00c7in Rakamlar\u0131" },
            { "ru", "Rus\u00e7a" },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Avustralya \u0130ngilizcesi" },
            { "Dupl", "Duploy\u00e9 Stenografi" },
            { "sa", "Sanskrit\u00e7e" },
            { "%%UCCOR", "Birle\u015ftirilmi\u015f Yaz\u0131m Kurallar\u0131" },
            { "sc", "Sardunya Dili" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Kuzey Sami" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "S\u0131rp-H\u0131rvat Dili" },
            { "ken", "Kenyang" },
            { "si", "Seylanca" },
            { "sux", "S\u00fcmerce" },
            { "sk", "Slovak\u00e7a" },
            { "sl", "Slovence" },
            { "Gran", "Grantha" },
            { "sm", "Samoa Dili" },
            { "sn", "Shona" },
            { "so", "Somalice" },
            { "type.nu.arab", "Hint-Arap Rakamlar\u0131" },
            { "sq", "Arnavut\u00e7a" },
            { "sr", "S\u0131rp\u00e7a" },
            { "ss", "Sisvati" },
            { "Java", metaValue_jv },
            { "st", "G\u00fcney Sotho" },
            { "su", "Sunda Dili" },
            { "%%NEDIS", "Natisone Leh\u00e7esi" },
            { "sv", "\u0130sve\u00e7\u00e7e" },
            { "sw", "Svahili" },
            { "type.nu.hantfin", "Finansal Geleneksel \u00c7in Rakamlar\u0131" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", "Tamilce" },
            { "142", "Asya" },
            { "bua", "Buryat" },
            { "143", "Orta Asya" },
            { "te", "Telugu Dili" },
            { "145", "Bat\u0131 Asya" },
            { "tg", "Tacik\u00e7e" },
            { "th", "Tayca" },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "type.colNumeric.yes", "Rakamlar\u0131 Say\u0131sal Olarak S\u0131ralama" },
            { "en_CA", "Kanada \u0130ngilizcesi" },
            { "tk", "T\u00fcrkmence" },
            { "tl", "Takalot\u00e7a" },
            { "tn", "Setsvana" },
            { "to", "Tongaca" },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Japon Rakamlar\u0131" },
            { "tr", "T\u00fcrk\u00e7e" },
            { "ts", "Tsonga" },
            { "swb", "Komorca" },
            { "Cakm", "Chakma" },
            { "tt", "Tatarca" },
            { "dyu", "Dyula" },
            { "tw", "Tvi" },
            { "ty", "Tahiti Dili" },
            { "%%BISKE", "San Giorgio/Bila Leh\u00e7esi" },
            { "150", "Avrupa" },
            { "key.colHiraganaQuaternary", "Kana S\u0131ralamas\u0131" },
            { "151", "Do\u011fu Avrupa" },
            { "154", "Kuzey Avrupa" },
            { "dzg", "Dazaga" },
            { "155", "Bat\u0131 Avrupa" },
            { "ug", "Uygurca" },
            { "Ital", "Eski \u0130talyan" },
            { "Kore", "Kore" },
            { "kgp", "Kaingang" },
            { "Zyyy", "Ortak" },
            { "uk", "Ukraynaca" },
            { "zea", "Zelandaca" },
            { "type.colCaseFirst.no", "Normal B\u00fcy\u00fck/K\u00fc\u00e7\u00fck Harf D\u00fczeninde S\u0131ralama" },
            { "type.colStrength.quaternary", "Aksanlar\u0131/B\u00fcy\u00fck-K\u00fc\u00e7\u00fck Harfleri/Geni\u015fli\u011fi/Kana\u2019y\u0131 S\u0131ralama" },
            { "type.ca.coptic", "K\u0131pti Takvim" },
            { "ur", "Urduca" },
            { "%%1994", "Standart Resia Yaz\u0131m Kurallar\u0131" },
            { "xal", "Kalm\u0131k\u00e7a" },
            { "zen", "Zenaga" },
            { "uz", "\u00d6zbek\u00e7e" },
            { "kha", "Khasi" },
            { "%%1996", "1996 Almanca Yaz\u0131m Kurallar\u0131" },
            { "nds_NL", "A\u015fa\u011f\u0131 Saksonca" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "\u00c7in Cumhuriyeti Takvimi" },
            { "vi", "Vietnamca" },
            { "kho", "Hotanca" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Saat Sistemi (12 - 24)" },
            { "%%TARASK", "Taraskievica Yaz\u0131m Kurallar\u0131" },
            { "vo", "Volap\u00fck" },
            { "key.x", "\u00d6zel Kullan\u0131m" },
            { "khw", "\u00c7itral Dili" },
            { "syc", "Klasik S\u00fcryanice" },
            { "Osma", "Osmanya" },
            { "quc", "Ki\u00e7ece" },
            { "qug", "Chimborazo Highland Quichua" },
            { "gaa", "Ga" },
            { "wa", "Valonca" },
            { "gag", "Gagavuzca" },
            { "syr", "S\u00fcryanice" },
            { "Grek", "Yunan" },
            { "gan", "Gan \u00c7incesi" },
            { "kiu", "K\u0131rman\u00e7\u00e7a" },
            { "Lydi", "Lidya" },
            { "Xsux", "S\u00fcmer-Akad \u00c7ivi Yaz\u0131s\u0131" },
            { "wo", "Volof\u00e7a" },
            { "zgh", "Standart Berberi Dili Tamazight" },
            { "ar_001", "Modern Standart Arap\u00e7a" },
            { "Cans", "UCAS" },
            { "gay", "Gayo" },
            { "key.colNumeric", "Say\u0131sal S\u0131ralama" },
            { "Mong", "Mo\u011fol" },
            { "mnc", "Man\u00e7urya Dili" },
            { "Latf", "Fraktur Latin" },
            { "szl", "Silezyaca" },
            { "Hluw", "Anadolu Hiyeroglifleri" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", "Latin" },
            { "Latg", "Gael Latin" },
            { "type.nu.hans", "Basitle\u015ftirilmi\u015f \u00c7in Rakamlar\u0131" },
            { "type.nu.hant", "Geleneksel \u00c7in Rakamlar\u0131" },
            { "xh", "Zosa" },
            { "type.nu.romanlow", "K\u00fc\u00e7\u00fck Harf Roma Rakamlar\u0131" },
            { "byn", "Blin" },
            { "Lyci", "Likya" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "gbz", "Zerd\u00fc\u015ft Daricesi" },
            { "Moon", "Moon" },
            { "moh", "Mohavk Dili" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Erken Modern Frans\u0131zca" },
            { "yi", "Yidi\u015f" },
            { "mos", "Mossi" },
            { "Syrc", "S\u00fcryani" },
            { "Dsrt", "Deseret" },
            { "yo", "Yorubaca" },
            { "type.nu.traditional", "Geleneksel Rakamlar" },
            { "es_MX", "Meksika \u0130spanyolcas\u0131" },
            { "Syrj", "Bat\u0131 S\u00fcryani" },
            { "ota", "Osmanl\u0131 T\u00fcrk\u00e7esi" },
            { "Syre", "Estrangela S\u00fcryani" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Karya" },
            { "kln", "Kalenjin" },
            { "zh", "\u00c7ince" },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Eski Permik" },
            { "key.lb", "lb" },
            { "zu", "Zuluca" },
            { "type.co.phonebook", "Telefon Defteri S\u0131ralamas\u0131" },
            { "%%MONOTON", "Monotonik" },
            { "Geor", "G\u00fcrc\u00fc" },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.colCaseLevel.yes", "B\u00fcy\u00fck/K\u00fc\u00e7\u00fck Harfe Duyarla S\u0131ralama" },
            { "type.nu.jpanfin", "Finansal Japon Rakamlar\u0131" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "mrj", "Ova \u00c7irmi\u015f\u00e7esi" },
            { "Syrn", "Do\u011fu S\u00fcryani" },
            { "type.nu.mymrshan", "Myanmar Shan Rakamlar\u0131" },
            { "Elba", "Elbasan" },
            { "Narb", "Eski Kuzey Arap" },
            { "type.nu.olck", "Ol Chiki Rakamlar\u0131" },
            { "type.co.reformed", "Yeni S\u0131ralama D\u00fczeni" },
            { "Tglg", "Takalot" },
            { "Egyd", "Demotik M\u0131s\u0131r" },
            { "key.colBackwards", "Ters Aksan S\u0131ralama" },
            { "Egyh", "Hiyeratik M\u0131s\u0131r" },
            { "Palm", "Palmira" },
            { "ebu", "Embu" },
            { "Egyp", "M\u0131s\u0131r Hiyeroglifleri" },
            { "Geok", "Hutsuri G\u00fcrc\u00fc" },
            { "zh_Hans", "Basitle\u015ftirilmi\u015f \u00c7ince" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Eski Macar" },
            { "kok", "Konkani" },
            { "%%1901", "Geleneksel Almanca Yaz\u0131m Kurallar\u0131" },
            { "kos", "Kosraean" },
            { "vec", "Venedik\u00e7e" },
            { "type.nu.limb", "Limbu Rakamlar\u0131" },
            { "zh_Hant", "Geleneksel \u00c7ince" },
            { "Sund", "Sunda" },
            { "vep", "Veps" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "Kmer Rakamlar\u0131" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valensiyaca" },
            { "Cprt", metaValue_CY },
            { "%%BAKU1926", "Birle\u015ftirilmi\u015f Yeni T\u00fcrk Alfabesi" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Gurmukhi Rakamlar\u0131" },
            { "mul", "Birden Fazla Dil" },
            { "cad", "Caddo" },
            { "key.ms", "\u00d6l\u00e7\u00fc Sistemi" },
            { "mus", "Creek" },
            { "Glag", "Glagolit" },
            { "gil", "Kiribati Dili" },
            { "%%KKCOR", "Ortak Yaz\u0131m Kurallar\u0131" },
            { "Cher", "\u00c7eroki" },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Tamil Rakamlar\u0131" },
            { "krc", "Kara\u00e7ay-Balkarca" },
            { "inh", "\u0130ngu\u015f\u00e7a" },
            { "krj", "Kinaray-a" },
            { "kri", "Krio" },
            { "krl", "Karelyaca" },
            { "efi", "Efik" },
            { "tcy", "Tuluca" },
            { "key.nu", "Rakamlar" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "type.colCaseFirst.upper", "\u00d6nce B\u00fcy\u00fck Harfleri S\u0131ralama" },
            { "Telu", "Telugu" },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
