/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.SQLFormatter;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

final class JDBCJavaNameRenderer
extends JavaNameRenderer {
    private static final Icon SQL_ICON = Icons.getIcon((String)"ProfilerIcons.SqlQuery");
    private static final Icon SQL_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, SQL_ICON);
    private static final Icon LEAF_ICON = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private static final Icon LEAF_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, LEAF_ICON);
    private final Icon icon;
    private final Icon iconDisabled;
    private String currentValue;
    private JLabel currentSQLRenderer;
    private static int CACHE_SIZE = 100;
    private List<String> sqlRenderersKeys;
    private Map<String, JLabel> sqlRenderersCache;

    public JDBCJavaNameRenderer() {
        this("ProfilerIcons.NodeReverse");
    }

    public JDBCJavaNameRenderer(String string) {
        this.icon = Icons.getIcon((String)string);
        this.iconDisabled = UIManager.getLookAndFeel().getDisabledIcon(null, this.icon);
    }

    @Override
    public void setValue(Object object, int n) {
        if (object instanceof PresoObjAllocCCTNode) {
            PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)object;
            boolean bl = presoObjAllocCCTNode.isFiltered();
            this.currentValue = presoObjAllocCCTNode.getNodeName();
            if (JDBCTreeTableView.isSQL(presoObjAllocCCTNode)) {
                JDBCTreeTableView.SQLQueryNode sQLQueryNode = (JDBCTreeTableView.SQLQueryNode)presoObjAllocCCTNode;
                String string = sQLQueryNode.htmlName;
                if (string == null) {
                    sQLQueryNode.htmlName = string = SQLFormatter.format(this.currentValue);
                }
                this.currentSQLRenderer = this.sqlRenderer(string, bl ? SQL_ICON_DISABLED : SQL_ICON);
            } else {
                if (bl) {
                    this.setNormalValue("");
                    this.setBoldValue("");
                    this.setGrayValue(this.currentValue);
                } else {
                    super.setValue(this.currentValue, n);
                }
                if (presoObjAllocCCTNode.isLeaf()) {
                    this.setIcon(bl ? LEAF_ICON_DISABLED : LEAF_ICON);
                } else {
                    this.setIcon(bl ? this.iconDisabled : this.icon);
                }
                this.currentSQLRenderer = null;
            }
        } else {
            super.setValue(object, n);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.currentSQLRenderer != null ? this.currentSQLRenderer : super.getComponent();
    }

    @Override
    public String toString() {
        return this.currentValue;
    }

    private JLabel sqlRenderer(String string, Icon icon) {
        JLabel jLabel;
        if (this.sqlRenderersCache == null) {
            this.sqlRenderersKeys = new ArrayList<String>(CACHE_SIZE);
            this.sqlRenderersCache = new HashMap<String, JLabel>(CACHE_SIZE);
        }
        if ((jLabel = this.sqlRenderersCache.get(string)) == null) {
            if (this.sqlRenderersKeys.size() < CACHE_SIZE) {
                jLabel = new DefaultTableCellRenderer();
            } else {
                String string2 = this.sqlRenderersKeys.remove(0);
                jLabel = this.sqlRenderersCache.remove(string2);
            }
            this.sqlRenderersKeys.add(string);
            this.sqlRenderersCache.put(string, jLabel);
            jLabel.setText(string);
        }
        jLabel.setIcon(icon);
        return jLabel;
    }
}

