/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.GaussianReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class GaussianFchkReader
extends GaussianReader {
    private Map<String, Object> fileData;
    private int atomCount;
    private static String[] AO_TYPES = new String[]{"F7", "D5", "L", "S", "P", "D", "F", "G", "H"};

    @Override
    protected void initializeReader() throws Exception {
        super.initializeReader();
        this.energyUnits = "";
        this.fileData = new Hashtable<String, Object>();
        this.fileData.put("title", this.rd().trim());
        this.calculationType = PT.rep(this.rd(), "  ", " ");
        this.asc.newAtomSet();
        this.asc.setCurrentModelInfo("fileData", this.fileData);
        this.readAllData();
        this.readAtoms();
        this.readBonds();
        this.readDipoleMoment();
        this.readPartialCharges();
        this.readBasis();
        this.readMolecularObitals();
        this.checkForFreq();
        this.continuing = false;
    }

    private void checkForFreq() throws Exception {
        Integer n = (Integer)this.fileData.get("Vib-NDim");
        if (n == null) {
            this.readFrequencies("NumFreq", false);
            return;
        }
        try {
            int n2 = n;
            float[] fArray = (float[])this.fileData.get("Vib-E2");
            float[] fArray2 = (float[])this.fileData.get("Vib-Modes");
            float[] fArray3 = this.fillFloat(fArray, 0, n2);
            float[] fArray4 = this.fillFloat(fArray, n2, n2);
            float[] fArray5 = this.fillFloat(fArray, n2 * 2, n2);
            float[] fArray6 = this.fillFloat(fArray, n2 * 3, n2);
            int n3 = this.asc.getLastAtomSetAtomCount();
            boolean[] blArray = new boolean[n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                boolean bl = blArray[n5] = !this.doGetVibration(++this.vibrationNumber);
                if (!blArray[n5]) {
                    int n6 = this.asc.ac;
                    this.asc.cloneAtomSetWithBonds(true);
                    String string = this.asc.setAtomSetFrequency(this.vibrationNumber, "Calculation " + this.calculationNumber, null, "" + fArray3[n5], null);
                    this.appendLoadNote("model " + this.asc.atomSetCount + ": " + string);
                    this.namedSets.set(this.asc.iSet);
                    this.asc.setAtomSetModelProperty("ReducedMass", String.valueOf(fArray4[n5]) + " AMU");
                    this.asc.setAtomSetModelProperty("ForceConstant", String.valueOf(fArray5[n5]) + " mDyne/A");
                    this.asc.setAtomSetModelProperty("IRIntensity", String.valueOf(fArray6[n5]) + " KM/Mole");
                    int n7 = 0;
                    while (n7 < n3) {
                        this.asc.addVibrationVectorWithSymmetry(n6 + n7, fArray2[n4++], fArray2[n4++], fArray2[n4++], false);
                        ++n7;
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            Logger.error("Could not read Vib-E2 section: " + exception.getMessage());
        }
    }

    private float[] fillFloat(float[] fArray, int n, int n2) {
        float[] fArray2 = new float[n2];
        int n3 = 0;
        int n4 = n + n2;
        while (n < n4) {
            fArray2[n3] = fArray[n];
            ++n;
            ++n3;
        }
        return fArray2;
    }

    private void readAllData() throws Exception {
        while ((this.line == null ? this.rd() : this.line) != null) {
            if (this.line.length() < 40) {
                if (this.line.indexOf("NumAtom") != 0) continue;
                return;
            }
            String string = PT.rep(this.line.substring(0, 40).trim(), " ", "");
            char c = this.line.charAt(43);
            boolean bl = this.line.indexOf("N=") >= 0;
            String string2 = this.line.substring(50).trim();
            Logger.info(String.valueOf(string) + " = " + string2 + " " + bl);
            Object object = null;
            if (bl) {
                switch (c) {
                    case 'I': 
                    case 'R': {
                        object = this.fillFloatArray(null, 0, new float[this.parseIntStr(string2)]);
                        this.line = null;
                        break;
                    }
                    default: {
                        string2 = this.rd().trim();
                        while (this.rd() != null && this.line.indexOf("   N=   ") < 0) {
                            string2 = String.valueOf(string2) + " " + this.line.trim();
                        }
                        object = string2;
                        break;
                    }
                }
            } else {
                switch (c) {
                    case 'I': {
                        object = this.parseIntStr(string2);
                        break;
                    }
                    case 'R': {
                        object = Double.parseDouble(string2);
                        break;
                    }
                    case 'C': 
                    case 'L': {
                        object = string2;
                    }
                }
                this.line = null;
            }
            if (object == null) continue;
            this.fileData.put(string, object);
        }
    }

    @Override
    protected void readAtoms() throws Exception {
        float[] fArray = (float[])this.fileData.get("Atomicnumbers");
        float[] fArray2 = (float[])this.fileData.get("Currentcartesiancoordinates");
        String string = "" + this.fileData.get("TotalEnergy");
        this.asc.setAtomSetEnergy(string, this.parseFloatStr(string));
        this.atomCount = fArray.length;
        float f = 0.5291772f;
        int n = 0;
        int n2 = 0;
        while (n < this.atomCount) {
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)fArray[n];
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordXYZ(atom, fArray2[n2++] * f, fArray2[n2++] * f, fArray2[n2++] * f);
            ++n;
        }
    }

    protected void readBonds() {
        try {
            float[] fArray = (float[])this.fileData.get("NBond");
            float[] fArray2 = (float[])this.fileData.get("IBond");
            if (fArray.length == 0) {
                return;
            }
            float[] fArray3 = (float[])this.fileData.get("RBond");
            int n = fArray3.length / fArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.atomCount) {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = (int)fArray2[n3] - 1;
                    if (n5 > n2) {
                        float f = fArray3[n3];
                        int n6 = f == 1.5f ? 515 : (int)f;
                        this.asc.addBond(new Bond(n2, n5, n6));
                    }
                    ++n4;
                    ++n3;
                }
                ++n2;
            }
            this.addJmolScript("connect 1.1 {_H} {*} ");
        }
        catch (Exception exception) {
            Logger.info("GaussianFchkReader -- bonding ignored");
        }
    }

    @Override
    protected void readDipoleMoment() throws Exception {
        float[] fArray = (float[])this.fileData.get("DipoleMoment");
        if (fArray == null) {
            return;
        }
        V3 v3 = V3.new3(fArray[0], fArray[1], fArray[2]);
        Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + v3);
        this.asc.setCurrentModelInfo("dipole", v3);
    }

    @Override
    protected void readPartialCharges() throws Exception {
        float[] fArray = (float[])this.fileData.get("Mulliken Charges");
        if (fArray == null) {
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        int n = 0;
        while (n < this.atomCount) {
            float f;
            atomArray[n].partialCharge = f = fArray[n];
            if (Math.abs(f) > 0.8f) {
                atomArray[n].formalCharge = Math.round(f);
            }
            ++n;
        }
        Logger.info("Mulliken charges found for Model " + this.asc.atomSetCount);
    }

    @Override
    protected void readBasis() throws Exception {
        float[] fArray = (float[])this.fileData.get("Shelltypes");
        this.gaussianCount = 0;
        this.shellCount = 0;
        if (fArray == null) {
            return;
        }
        this.shellCount = fArray.length;
        this.shells = new Lst();
        float[] fArray2 = (float[])this.fileData.get("Numberofprimitivespershell");
        float[] fArray3 = (float[])this.fileData.get("Shelltoatommap");
        float[] fArray4 = (float[])this.fileData.get("Primitiveexponents");
        float[] fArray5 = (float[])this.fileData.get("Contractioncoefficients");
        float[] fArray6 = (float[])this.fileData.get("P(S=P)Contractioncoefficients");
        this.gaussians = AU.newFloat2(fArray4.length);
        int n = 0;
        while (n < this.shellCount) {
            String string = AO_TYPES[(int)fArray[n] + 3];
            int n2 = (int)fArray2[n];
            int n3 = (int)fArray3[n];
            int[] nArray = new int[]{n3, string.equals("F7") || string.equals("D5") ? BasisFunctionReader.getQuantumShellTagIDSpherical(string.substring(0, 1)) : BasisFunctionReader.getQuantumShellTagID(string), this.gaussianCount + 1, n2};
            if (this.debugging) {
                Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(nArray));
            }
            this.shells.addLast(nArray);
            int n4 = 0;
            while (n4 < n2) {
                this.gaussians[this.gaussianCount] = new float[3];
                float[] fArray7 = this.gaussians[this.gaussianCount];
                fArray7[0] = fArray4[this.gaussianCount];
                fArray7[1] = fArray5[this.gaussianCount];
                if (fArray6 != null) {
                    fArray7[2] = fArray6[this.gaussianCount];
                }
                ++this.gaussianCount;
                ++n4;
            }
            ++n;
        }
        Logger.info(String.valueOf(this.shellCount) + " slater shells read");
        Logger.info(String.valueOf(this.gaussianCount) + " gaussian primitives read");
    }

    protected void readMolecularObitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        int n = (Integer)this.fileData.get("Numberofelectrons");
        int n2 = (Integer)this.fileData.get("Numberofalphaelectrons");
        int n3 = (Integer)this.fileData.get("Numberofbetaelectrons");
        float[] fArray = (float[])this.fileData.get("AlphaOrbitalEnergies");
        float[] fArray2 = (float[])this.fileData.get("BetaOrbitalEnergies");
        float[] fArray3 = (float[])this.fileData.get("AlphaMOcoefficients");
        float[] fArray4 = (float[])this.fileData.get("BetaMOcoefficients");
        if (fArray3 == null) {
            return;
        }
        int n4 = fArray4 == null ? 2 : 1;
        int n5 = fArray4 == null ? n : n2;
        this.getOrbitals(fArray, fArray3, n4, n5);
        if (fArray4 != null) {
            this.getOrbitals(fArray2, fArray4, n4, n3);
        }
        this.setMOData(false);
    }

    private void getOrbitals(float[] fArray, float[] fArray2, int n, int n2) {
        int n3 = fArray.length;
        int n4 = fArray2.length;
        n4 /= n3;
        this.alphaBeta = n == 2 ? "" : (this.alphaBeta.equals("alpha") ? "beta" : "alpha");
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            float[] fArray3 = new float[n4];
            int n8 = 0;
            while (n8 < n4) {
                fArray3[n8] = fArray2[n5++];
                ++n8;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("coefficients", fArray3);
            hashtable.put("occupancy", Float.valueOf(n));
            if ((n6 += n) >= n2) {
                n = 0;
            }
            hashtable.put("energy", Float.valueOf(fArray[n7]));
            hashtable.put("type", this.alphaBeta);
            this.setMO(hashtable);
            ++n7;
        }
    }
}

