/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import java.util.Map;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.parser.StaticScope;

public class IRWriter {
    private IRWriter() {
    }

    public static void persist(IRWriterEncoder file2, IRScope script) throws IOException {
        file2.startEncoding(script);
        IRWriter.persistScopeInstructions(file2, script);
        file2.startEncodingScopeHeaders(script);
        IRWriter.persistScopeHeaders(file2, script);
        file2.endEncodingScopeHeaders(script);
        file2.endEncoding(script);
    }

    private static void persistScopeInstructions(IRWriterEncoder file2, IRScope parent) {
        IRWriter.persistScopeInstrs(file2, parent);
        for (IRScope scope : parent.getLexicalScopes()) {
            IRWriter.persistScopeInstructions(file2, scope);
        }
    }

    private static void persistScopeInstrs(IRWriterEncoder file2, IRScope scope) {
        file2.startEncodingScopeInstrs(scope);
        if (scope instanceof IRMethod && !scope.hasBeenBuilt()) {
            ((IRMethod)scope).lazilyAcquireInterpreterContext();
        }
        for (Instr instr : scope.getInterpreterContext().getInstructions()) {
            file2.encode(instr);
        }
        file2.endEncodingScopeInstrs(scope);
    }

    private static void persistScopeHeaders(IRWriterEncoder file2, IRScope parent) {
        IRWriter.persistScopeHeader(file2, parent);
        for (IRScope scope : parent.getLexicalScopes()) {
            IRWriter.persistScopeHeaders(file2, scope);
        }
    }

    private static void persistScopeHeader(IRWriterEncoder file2, IRScope scope) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Writing Scope Header");
        }
        file2.startEncodingScopeHeader(scope);
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("IRScopeType = " + (Object)((Object)scope.getScopeType()));
        }
        file2.encode(scope.getScopeType());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("NAME = " + scope.getName());
        }
        file2.encode(scope.getName());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Line # = " + scope.getLine());
        }
        file2.encode(scope.getLine());
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("# of temp vars = " + scope.getTemporaryVariablesCount());
        }
        file2.encode(scope.getTemporaryVariablesCount());
        if (scope.getScopeType() == IRScopeType.CLOSURE) {
            file2.encode(((IRClosure)scope).isEND());
        }
        IRWriter.persistScopeLabelIndices(scope, file2);
        if (!(scope instanceof IRScriptBody)) {
            file2.encode(scope.getLexicalParent());
        }
        if (scope instanceof IRClosure) {
            IRClosure closure = (IRClosure)scope;
            file2.encode(closure.getSignature());
        }
        IRWriter.persistStaticScope(file2, scope.getStaticScope());
        IRWriter.persistLocalVariables(scope, file2);
        file2.endEncodingScopeHeader(scope);
    }

    private static void persistLocalVariables(IRScope scope, IRWriterEncoder file2) {
        Map<RubySymbol, LocalVariable> localVariables = scope.getLocalVariables();
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("PERSISTING LVARS (" + localVariables.size() + ")");
        }
        file2.encode(localVariables.size());
        for (RubySymbol name2 : localVariables.keySet()) {
            file2.encode(name2);
            int offset2 = localVariables.get(name2).getOffset();
            if (RubyInstanceConfig.IR_WRITING_DEBUG) {
                System.out.println("    NAME: " + name2 + "(0:" + offset2 + ")");
            }
            file2.encode(offset2);
        }
    }

    private static void persistScopeLabelIndices(IRScope scope, IRWriterEncoder file2) {
        Map<String, Integer> labelIndices = scope.getVarIndices();
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("LABEL_SIZE: " + labelIndices.size());
        }
        file2.encode(labelIndices.size());
        for (String key2 : labelIndices.keySet()) {
            if (RubyInstanceConfig.IR_WRITING_DEBUG) {
                System.out.println("LABEL: " + key2);
            }
            file2.encode(key2);
            file2.encode(labelIndices.get(key2));
            if (!RubyInstanceConfig.IR_WRITING_DEBUG) continue;
            System.out.println("LABEL(num): " + labelIndices.get(key2));
        }
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("DONE LABELS: " + labelIndices.size());
        }
    }

    private static void persistStaticScope(IRWriterEncoder file2, StaticScope staticScope) {
        file2.encode(staticScope.getType());
        file2.encode(staticScope.getVariables());
        file2.encode(staticScope.getFirstKeywordIndex());
        file2.encode(staticScope.getSignature());
    }
}

