/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Timer;
import net.sourceforge.offroad.ui.OffRoadUIThread;

class InactivityListener
implements ActionListener,
AWTEventListener,
OffRoadUIThread.OffRoadUIThreadListener {
    public static final long KEY_EVENTS = 8L;
    public static final long MOUSE_EVENTS = 48L;
    public static final long USER_EVENTS = 56L;
    private Window window;
    private Action action;
    private int interval;
    private long eventMask;
    private Timer timer = new Timer(0, this);

    public InactivityListener(Window window, Action action) {
        this(window, action, 1);
    }

    public InactivityListener(Window window, Action action, int interval) {
        this(window, action, interval, 56L);
    }

    public InactivityListener(Window window, Action action, int minutes, long eventMask) {
        this.window = window;
        this.setAction(action);
        this.setInterval(minutes);
        this.setEventMask(eventMask);
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setInterval(int minutes) {
        this.setIntervalInMillis(minutes * 60000);
    }

    public void setIntervalInMillis(int interval) {
        this.interval = interval;
        this.timer.setInitialDelay(interval);
    }

    public void setEventMask(long eventMask) {
        this.eventMask = eventMask;
    }

    public void start() {
        this.timer.setInitialDelay(this.interval);
        this.timer.setDelay(this.interval);
        this.timer.setRepeats(true);
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionEvent ae = new ActionEvent(this.window, 1001, "");
        this.action.actionPerformed(ae);
    }

    @Override
    public void eventDispatched(AWTEvent e) {
        this.restart();
    }

    void restart() {
        if (this.timer.isRunning()) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    @Override
    public void threadStarted() {
        this.timer.stop();
    }

    @Override
    public void threadFinished() {
        this.restart();
    }
}

