/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.osmand.PlatformUtil;
import net.osmand.binary.OsmandIndex;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPoint;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.render.OsmandRenderer;
import net.osmand.plus.views.DrawPolylineLayer;
import net.osmand.plus.views.FavoritesLayer;
import net.osmand.plus.views.GPXLayer;
import net.osmand.plus.views.MapControlsLayer;
import net.osmand.plus.views.MapInfoLayer;
import net.osmand.plus.views.MapTextLayer;
import net.osmand.plus.views.OsmandMapLayer;
import net.osmand.plus.views.POIMapLayer;
import net.osmand.plus.views.PointNavigationLayer;
import net.osmand.plus.views.RouteLayer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.res.OffRoadResources;
import net.sourceforge.offroad.ui.CursorDistanceLayer;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.DirectSearchLayer;
import net.sourceforge.offroad.ui.DirectSearchSelectionLayer;
import net.sourceforge.offroad.ui.GenerateLayerOverlayThread;
import net.sourceforge.offroad.ui.GenerationThread;
import net.sourceforge.offroad.ui.InactivityListener;
import net.sourceforge.offroad.ui.LazyThread;
import net.sourceforge.offroad.ui.MoveAnimationThread;
import net.sourceforge.offroad.ui.OffRoadUIThread;
import net.sourceforge.offroad.ui.RotatedTileBoxCalculationOrder;
import net.sourceforge.offroad.ui.RoundButton;
import net.sourceforge.offroad.ui.ZoomAnimationThread;
import org.apache.commons.logging.Log;

public class OsmBitmapPanel
extends JPanel {
    private static final int INACTIVITY_TIME_IN_MILLISECONDS = 2000;
    private static final Log log = PlatformUtil.getLog(OsmBitmapPanel.class);
    private static final Color BACKGROUND_COLOR = Color.white;
    private OsmWindow mContext;
    private RotatedTileBox mCurrentTileBox;
    private boolean mShowCursor;
    private LatLon mCursorPosition = null;
    private int mCursorLength = 20;
    private BasicStroke mStroke;
    private List<OsmandMapLayer> layers = new ArrayList<OsmandMapLayer>();
    private Map<OsmandMapLayer, Float> zOrders = new HashMap<OsmandMapLayer, Float>();
    private POIMapLayer mPoiLayer;
    private ExecutorService mThreadPool;
    private OffRoadUIThread mLastThread;
    private InactivityListener mInactivityListener;
    private CalculateUnzoomedPicturesAction mUnzoomedPicturesAction;
    private RoundButton mCompassButton;
    private List<CalculateUnzoomedPicturesAction.ImageStorage> mEffectivelyDrawnImages = new ArrayList<CalculateUnzoomedPicturesAction.ImageStorage>();
    private int mZoomCounter;
    private BufferedImage mLayerImage;
    private RotatedTileBox mLayerImageTileBox;
    private boolean mCursorRadiusEnabled = false;
    private double mCursorRadiusSizeInMeters = 100.0;
    private boolean mZoomIsRunning = false;
    private DrawPolylineLayer mPolylineLayer;

    public OsmBitmapPanel(OsmWindow pWin) {
        this.mContext = pWin;
        this.setLayout(null);
        this.mUnzoomedPicturesAction = new CalculateUnzoomedPicturesAction();
        LatLon latLon = new LatLon(51.03325, 13.64656);
        int zoom = 17;
        if (this.mContext.getSettings().isLastKnownMapLocation()) {
            latLon = this.mContext.getSettings().getLastKnownMapLocation();
            zoom = this.mContext.getSettings().getLastKnownMapZoom();
        }
        this.setCurrentTileBox(new RotatedTileBox.RotatedTileBoxBuilder().setLocation(latLon.getLatitude(), latLon.getLongitude()).setZoom(zoom).setPixelDimensions(this.getWidth(), this.getHeight()).setRotate(0.0f).setMapDensity(1.0).build());
        this.mCursorLength = (int)(15.0 * this.mCurrentTileBox.getMapDensity());
        this.mStroke = new BasicStroke((float)(2.0 * this.mCurrentTileBox.getMapDensity()));
        RouteLayer routeLayer = new RouteLayer(this.mContext.getRoutingHelper());
        this.addLayer(routeLayer, 1.0f);
        this.addLayer(new MapTextLayer(), 2.0f);
        this.mPoiLayer = new POIMapLayer(pWin);
        this.addLayer(this.mPoiLayer, 3.0f);
        this.addLayer(new PointNavigationLayer(this.mContext), 4.0f);
        this.addLayer(new FavoritesLayer(), 5.0f);
        this.addLayer(new GPXLayer(), 6.0f);
        this.addLayer(new CursorDistanceLayer(), 7.0f);
        this.addLayer(new MapInfoLayer(this, routeLayer), 8.0f);
        this.mCompassButton = new RoundButton();
        this.addLayer(new MapControlsLayer(this), 9.0f);
        this.mPolylineLayer = new DrawPolylineLayer(this);
        this.addLayer(this.mPolylineLayer, 10.0f);
        DirectSearchLayer directSearchLayer = new DirectSearchLayer();
        this.mContext.mDirectSearchAction.registerDirectSearchReceiver(directSearchLayer);
        this.addLayer(directSearchLayer, 10.0f);
        DirectSearchSelectionLayer directSelectionLayer = new DirectSearchSelectionLayer();
        directSelectionLayer.setSearchProvider(this.mContext.mDirectSearchAction.getSelectionProvider());
        this.addLayer(directSelectionLayer, 11.0f);
        for (OsmandMapLayer layer : this.layers) {
            layer.initLayer(this);
        }
        AbstractAction updateCursorAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmBitmapPanel.this.mShowCursor = !OsmBitmapPanel.this.mShowCursor;
                OsmBitmapPanel.this.repaint();
            }
        };
        new Timer(2000, updateCursorAction).start();
        this.mThreadPool = Executors.newFixedThreadPool(4);
        this.add((Component)this.mCompassButton, this.getComponentCount() - 1);
        int size = this.mCompassButton.getZoomedCircleRadius();
        this.mCompassButton.setBounds(100, 100, size, size);
    }

    public void init() {
        this.mInactivityListener = new InactivityListener(this.mContext.getWindow(), this.mUnzoomedPicturesAction);
        this.mInactivityListener.setIntervalInMillis(1000);
        this.mInactivityListener.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalculateUnzoomedPicturesAction.ImageStorage> getEffectivelyDrawnImages() {
        List<CalculateUnzoomedPicturesAction.ImageStorage> list = this.mEffectivelyDrawnImages;
        synchronized (list) {
            return new ArrayList<CalculateUnzoomedPicturesAction.ImageStorage>(this.mEffectivelyDrawnImages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffectivelyDrawnImages(List<CalculateUnzoomedPicturesAction.ImageStorage> pList) {
        List<CalculateUnzoomedPicturesAction.ImageStorage> list = this.mEffectivelyDrawnImages;
        synchronized (list) {
            this.mEffectivelyDrawnImages.clear();
            this.mEffectivelyDrawnImages.addAll(pList);
        }
    }

    public float getScaleCoefficient() {
        float scaleCoefficient = this.getDensity();
        OsmWindow dm = this.mContext;
        if (Math.min((float)dm.widthPixels / (dm.density * 160.0f), (float)dm.heightPixels / (dm.density * 160.0f)) > 2.5f) {
            scaleCoefficient *= 1.5f;
        }
        return scaleCoefficient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getDensity() {
        RotatedTileBox rotatedTileBox = this.mCurrentTileBox;
        synchronized (rotatedTileBox) {
            return this.mCurrentTileBox.getDensity();
        }
    }

    private void clear(BufferedImage pImage) {
        Graphics g = pImage.getGraphics();
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, pImage.getWidth(), pImage.getHeight());
        g.dispose();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ArrayList<CalculateUnzoomedPicturesAction.ImageStorage> effectivelyDrawn = new ArrayList<CalculateUnzoomedPicturesAction.ImageStorage>();
        Graphics2D gd2 = (Graphics2D)g;
        Graphics2D g2 = this.createGraphics(gd2);
        RotatedTileBox ctb = this.copyCurrentTileBox();
        LatLon screenLT = ctb.getLeftTopLatLon();
        LatLon screenRB = ctb.getRightBottomLatLon();
        int upperBound = ctb.getZoom();
        boolean imageFound = false;
        for (int biggerZoom = 1; biggerZoom <= 22; ++biggerZoom) {
            List<CalculateUnzoomedPicturesAction.ImageStorage> tblist = this.mUnzoomedPicturesAction.getTileBoxesForZoom(biggerZoom);
            for (CalculateUnzoomedPicturesAction.ImageStorage tblistEntry : tblist) {
                RotatedTileBox rtb = tblistEntry.mTileBox;
                if (!rtb.intersects(screenLT, screenRB)) continue;
                LatLon rtbLT = rtb.getLeftTopLatLon();
                LatLon rtbRB = rtb.getRightBottomLatLon();
                LatLon clalo = rtb.getCenterLatLon();
                double xc = ctb.getPixXFromLatLon(clalo.getLatitude(), clalo.getLongitude());
                double yc = ctb.getPixYFromLatLon(clalo.getLatitude(), clalo.getLongitude());
                float ctbRotate = ctb.getRotate();
                float theta = ctbRotate - rtb.getRotate();
                ctb.setRotate(rtb.getRotate());
                double x1 = ctb.getPixXFromLatLon(rtbLT.getLatitude(), rtbLT.getLongitude());
                double y1 = ctb.getPixYFromLatLon(rtbLT.getLatitude(), rtbLT.getLongitude());
                double x2 = ctb.getPixXFromLatLon(rtbRB.getLatitude(), rtbRB.getLongitude());
                double y2 = ctb.getPixYFromLatLon(rtbRB.getLatitude(), rtbRB.getLongitude());
                BufferedImage image = tblistEntry.mImage;
                if (image != null) {
                    effectivelyDrawn.add(tblistEntry);
                    double thetaR = Math.toRadians(theta);
                    g2.rotate(thetaR, xc, yc);
                    g2.drawImage(image, (int)x1, (int)y1, (int)x2, (int)y2, 0, 0, image.getWidth(), image.getHeight(), null);
                    imageFound = true;
                    g2.rotate(-thetaR, xc, yc);
                }
                ctb.setRotate(ctbRotate);
            }
            if (biggerZoom == upperBound && imageFound) break;
        }
        this.setEffectivelyDrawnImages(effectivelyDrawn);
        this.drawLayers(ctb, g2, true);
        Stroke oldStroke = g2.getStroke();
        Color oldColor = g2.getColor();
        if (this.mCursorPosition != null && this.mShowCursor && ctb.containsLatLon(this.mCursorPosition)) {
            int posx = (int)ctb.getPixXFromLatLon(this.mCursorPosition.getLatitude(), this.mCursorPosition.getLongitude());
            int posy = (int)ctb.getPixYFromLatLon(this.mCursorPosition.getLatitude(), this.mCursorPosition.getLongitude());
            int size_h = this.mCursorLength;
            g2.setStroke(this.mStroke);
            g2.setColor(Color.RED);
            g2.drawLine(posx - size_h, posy, posx + size_h, posy);
            g2.drawLine(posx, posy - size_h, posx, posy + size_h);
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
        g2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RotatedTileBox copyCurrentTileBox() {
        RotatedTileBox ctb;
        RotatedTileBox rotatedTileBox = this.mCurrentTileBox;
        synchronized (rotatedTileBox) {
            ctb = this.mCurrentTileBox.copy();
        }
        return ctb;
    }

    boolean contains(RotatedTileBox bigger, RotatedTileBox smaller) {
        return bigger.containsLatLon(smaller.getLeftTopLatLon()) && bigger.containsLatLon(smaller.getRightBottomLatLon());
    }

    void setImage(BufferedImage pImage, RotatedTileBox pGenerationTileBox, OsmandRenderer.RenderingResult pResult) {
        if (pImage != null) {
            this.mUnzoomedPicturesAction.addToCache(pGenerationTileBox, pImage, pResult);
            this.repaint();
        }
    }

    OsmandRenderer.RenderingResult drawImage(BufferedImage pImage, RotatedTileBox pTileBox, IntermediateImageListener pListener) {
        this.clear(pImage);
        Graphics2D graphics = pImage.createGraphics();
        Graphics2D g2 = this.createGraphics(graphics);
        OsmandRenderer.RenderingResult result = this.mContext.loadMGap(g2, pTileBox, pListener);
        g2.dispose();
        graphics.dispose();
        return result;
    }

    public Graphics2D createGraphics(Graphics2D graphics) {
        Graphics2D g2 = (Graphics2D)graphics.create();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return g2;
    }

    public void zoomChange(int pWheelRotation, Point pNewCenter) {
        RotatedTileBox tileCopy = this.copyCurrentTileBox();
        int delta = pWheelRotation;
        int newZoom = tileCopy.getZoom() + delta;
        delta = (newZoom = (int)this.checkZoom(newZoom)) - tileCopy.getZoom();
        if (delta == 0) {
            log.info((Object)"No zooming, as delta is zero");
            return;
        }
        ZoomAnimationThread animationThread = new ZoomAnimationThread(this, delta, pNewCenter);
        animationThread.addListener(new OffRoadUIThread.OffRoadUIThreadListener(){

            @Override
            public void threadStarted() {
                log.debug((Object)"Zooming started");
                OsmBitmapPanel.this.mZoomIsRunning = true;
            }

            @Override
            public void threadFinished() {
                log.debug((Object)"Zooming stopped");
                OsmBitmapPanel.this.mZoomIsRunning = false;
            }
        });
        RotatedTileBox destinationTileBox = animationThread.getDestinationTileBox(tileCopy.getZoom(), 10, 9);
        this.queue(animationThread);
        GenerationThread genThread = new LazyThread(this, destinationTileBox);
        ++this.mZoomCounter;
        if (this.mZoomCounter >= 4) {
            this.mZoomCounter = 0;
            genThread = new GenerationThread(this, destinationTileBox);
        }
        this.queue(genThread);
    }

    public boolean isZoomRunning() {
        return this.mZoomIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(OffRoadUIThread pThread) {
        pThread.addListener(this.mInactivityListener);
        if (this.mLastThread != null) {
            OffRoadUIThread offRoadUIThread = this.mLastThread;
            synchronized (offRoadUIThread) {
                if (!this.mLastThread.hasFinished()) {
                    this.mLastThread.setNextThread(pThread);
                } else {
                    pThread.shouldContinue();
                }
            }
        } else {
            pThread.shouldContinue();
        }
        this.mLastThread = pThread;
        log.debug((Object)("New thread " + pThread + " is queued."));
        this.mThreadPool.execute(pThread);
        if (pThread instanceof GenerationThread) {
            this.queue(new GenerateLayerOverlayThread(this, this.copyCurrentTileBox()));
        }
    }

    public float checkZoom(float newZoom) {
        int maxZoom;
        int minZoom;
        OsmandIndex.MapLevel mapInstance = OsmandIndex.MapLevel.getDefaultInstance();
        int n = minZoom = mapInstance.hasMinzoom() ? mapInstance.getMinzoom() : 1;
        if (newZoom < (float)minZoom) {
            newZoom = minZoom;
        }
        int n2 = maxZoom = mapInstance.hasMaxzoom() ? mapInstance.getMaxzoom() : 22;
        if (newZoom > (float)maxZoom) {
            newZoom = maxZoom;
        }
        return newZoom;
    }

    public void moveImage(float pDeltaX, float pDeltaY) {
        RotatedTileBox tb = this.moveTileBox(pDeltaX, pDeltaY);
        this.queue(new LazyThread(this, tb));
    }

    public RotatedTileBox moveTileBox(float pDeltaX, float pDeltaY) {
        RotatedTileBox tb = this.copyCurrentTileBox();
        QuadPoint center = tb.getCenterPixelPoint();
        double newLat = tb.getLatFromPixel(center.x + pDeltaX, center.y + pDeltaY);
        double newLon = tb.getLonFromPixel(center.x + pDeltaX, center.y + pDeltaY);
        tb.setLatLonCenter(newLat, newLon);
        this.setCurrentTileBox(tb);
        return tb;
    }

    public void moveImageAnimatedInPercentage(float pDeltaX, float pDeltaY) {
        System.out.println("Moving by  " + (pDeltaX *= (float)this.getWidth()) + ", " + (pDeltaY *= (float)this.getHeight()));
        RotatedTileBox tileBox = this.copyCurrentTileBox();
        QuadPoint center = tileBox.getCenterPixelPoint();
        tileBox.setLatLonCenter(tileBox.getLatFromPixel(center.x + pDeltaX, center.y + pDeltaY), tileBox.getLonFromPixel(center.x + pDeltaX, center.y + pDeltaY));
        this.moveAnimated(pDeltaX, pDeltaY, tileBox);
    }

    public void moveAnimated(float pDeltaX, float pDeltaY, RotatedTileBox tileBox) {
        MoveAnimationThread animationThread = new MoveAnimationThread(this, pDeltaX, pDeltaY);
        this.queue(animationThread);
        this.queue(new GenerationThread(this, tileBox));
    }

    public BufferedImage createImage() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        return image;
    }

    public void dragImage(Point pTranslate) {
        this.moveTileBox(pTranslate.x, pTranslate.y);
        this.repaint();
    }

    public void setCursor(Point pCursorPoint) {
        this.mCursorPosition = this.getLatLon(pCursorPoint);
        System.out.println("Setting cursor to " + this.mCursorPosition);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LatLon getLatLon(Point pCursorPoint) {
        RotatedTileBox rotatedTileBox = this.mCurrentTileBox;
        synchronized (rotatedTileBox) {
            return this.mCurrentTileBox.getLatLonFromPixel(pCursorPoint.x, pCursorPoint.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getPoint(LatLon pLatLon) {
        RotatedTileBox rotatedTileBox = this.mCurrentTileBox;
        synchronized (rotatedTileBox) {
            int posx = (int)this.mCurrentTileBox.getPixXFromLatLon(pLatLon);
            int posy = (int)this.mCurrentTileBox.getPixYFromLatLon(pLatLon);
            return new Point(posx, posy);
        }
    }

    public void move(LatLon pLocation, int pZoom) {
        RotatedTileBox tb = this.copyCurrentTileBox();
        tb.setLatLonCenter(pLocation.getLatitude(), pLocation.getLongitude());
        int newZoom = (int)this.checkZoom(pZoom);
        tb.setZoom(newZoom);
        this.setCurrentTileBox(tb);
        this.queue(new GenerationThread(this, tb));
    }

    public void setCursor(LatLon pLocation) {
        this.mCursorPosition = pLocation;
        this.repaint();
    }

    public LatLon getCursorPosition() {
        return this.mCursorPosition;
    }

    public OsmWindow getContext() {
        return this.mContext;
    }

    public void drawLater() {
        RotatedTileBox tb = this.copyCurrentTileBox();
        tb.setPixelDimensions(this.getWidth(), this.getHeight());
        this.setCurrentTileBox(tb);
        this.queue(new GenerationThread(this, tb));
    }

    public void saveImage(File pSelectedFile) {
        BufferedImage myImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics g = myImage.getGraphics();
        this.print(g);
        try {
            ImageIO.write((RenderedImage)myImage, "png", pSelectedFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rotateIncrement(double pDegrees) {
        this.queue(new GenerationThread(this, this.copyCurrentTileBox()));
    }

    public void directRotateIncrement(double pDegrees) {
        RotatedTileBox tb = this.copyCurrentTileBox();
        tb.setRotate((float)pDegrees + tb.getRotate());
        this.setCurrentTileBox(tb);
        this.repaint();
    }

    public OsmandSettings getSettings() {
        return this.mContext.getSettings();
    }

    public OsmWindow getApplication() {
        return this.mContext;
    }

    public boolean isLayerVisible(OsmandMapLayer layer) {
        return this.layers.contains(layer);
    }

    public float getZorder(OsmandMapLayer layer) {
        Float z = this.zOrders.get(layer);
        if (z == null) {
            return 10.0f;
        }
        return z.floatValue();
    }

    public synchronized void addLayer(OsmandMapLayer layer, float zOrder) {
        int i = 0;
        for (i = 0; i < this.layers.size() && !(this.zOrders.get(this.layers.get(i)).floatValue() > zOrder); ++i) {
        }
        layer.initLayer(this);
        this.layers.add(i, layer);
        this.zOrders.put(layer, Float.valueOf(zOrder));
    }

    public synchronized void removeLayer(OsmandMapLayer layer) {
        while (this.layers.remove(layer)) {
        }
        this.zOrders.remove(layer);
        layer.destroyLayer();
    }

    public synchronized void removeAllLayers() {
        while (this.layers.size() > 0) {
            this.removeLayer(this.layers.get(0));
        }
    }

    public List<OsmandMapLayer> getLayers() {
        return this.layers;
    }

    public void drawLayers(RotatedTileBox pTileBox, Graphics2D lg, boolean pDrawDirectLayers) {
        QuadPoint c = pTileBox.getCenterPixelPoint();
        OsmandMapLayer.DrawSettings settings = new OsmandMapLayer.DrawSettings(false);
        List<OsmandMapLayer> layers = this.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            OsmandMapLayer layer = layers.get(i);
            if (pDrawDirectLayers != layer instanceof DirectOffroadLayer) continue;
            Graphics2D glayer = this.createGraphics(lg);
            try {
                if (!layer.drawInScreenPixels()) {
                    glayer.rotate(pTileBox.getRotate(), c.x, c.y);
                }
                layer.onPrepareBufferImage(glayer, pTileBox, settings);
                layer.onDraw(glayer, pTileBox, settings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            glayer.dispose();
        }
    }

    public <T extends OsmandMapLayer> T getLayerByClass(Class<T> cl) {
        for (OsmandMapLayer lr : this.layers) {
            if (!cl.isInstance(lr)) continue;
            return (T)lr;
        }
        return null;
    }

    public void refreshMap() {
        this.drawLater();
    }

    public POIMapLayer getPoiLayer() {
        return this.mPoiLayer;
    }

    void repaintAndWait(int pWaitMillies) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    OsmBitmapPanel.this.repaint();
                }
            });
            Thread.sleep(pWaitMillies);
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void setCurrentTileBox(RotatedTileBox pCurrentTileBox) {
        this.mCurrentTileBox = pCurrentTileBox;
        this.mUnzoomedPicturesAction.setTileBox(pCurrentTileBox);
        log.debug((Object)("TILEBOX: " + pCurrentTileBox));
    }

    public void resizePanel() {
        this.drawLater();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isQueueEmpty() {
        if (this.mLastThread != null) {
            OffRoadUIThread offRoadUIThread = this.mLastThread;
            synchronized (offRoadUIThread) {
                if (this.mLastThread.hasFinished()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public OffRoadResources getResources() {
        return this.mContext.getResources();
    }

    public void setLayerImage(BufferedImage pLayerImage, RotatedTileBox pTileBox) {
        this.mLayerImage = pLayerImage;
        this.mLayerImageTileBox = pTileBox;
        this.repaint();
    }

    public double getCursorRadiusSizeInMeters() {
        return this.mCursorRadiusSizeInMeters;
    }

    public boolean isCursorRadiusEnabled() {
        return this.mCursorRadiusEnabled;
    }

    public void setCursorRadiusEnabled(boolean pCursorRadiusEnabled) {
        this.mCursorRadiusEnabled = pCursorRadiusEnabled;
    }

    public void setCursorRadiusSizeInMeters(double pCursorRadiusSizeInMeters) {
        this.mCursorRadiusSizeInMeters = pCursorRadiusSizeInMeters;
    }

    public OsmWindow getMyApplication() {
        return this.getApplication();
    }

    public JButton findViewById(int pMapCompassButton) {
        return this.mCompassButton;
    }

    public DrawPolylineLayer getPolylineLayer() {
        return this.mPolylineLayer;
    }

    public class CalculateUnzoomedPicturesAction
    extends AbstractAction {
        private RotatedTileBoxCalculationOrder mTileOrder;
        private LinkedHashMap<RotatedTileBox, ImageStorage> mImageStore = new LinkedHashMap<RotatedTileBox, ImageStorage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<RotatedTileBox, ImageStorage> eldest) {
                return this.size() > 2 * CalculateUnzoomedPicturesAction.this.mTileOrder.getSize();
            }
        };

        public CalculateUnzoomedPicturesAction() {
            this.mTileOrder = new RotatedTileBoxCalculationOrder();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ImageStorage> getTileBoxesForZoom(int pZoom) {
            LinkedHashMap<RotatedTileBox, ImageStorage> linkedHashMap = this.mImageStore;
            synchronized (linkedHashMap) {
                ArrayList<ImageStorage> ret = new ArrayList<ImageStorage>();
                for (Map.Entry<RotatedTileBox, ImageStorage> rtb : this.mImageStore.entrySet()) {
                    if (rtb.getKey().getZoom() != pZoom) continue;
                    ret.add(rtb.getValue());
                }
                if (OsmBitmapPanel.this.mLayerImageTileBox != null && pZoom == OsmBitmapPanel.this.mLayerImageTileBox.getZoom()) {
                    ret.add(new ImageStorage(OsmBitmapPanel.this.mLayerImage, OsmBitmapPanel.this.mLayerImageTileBox, new OsmandRenderer.RenderingResult()));
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTileBox(RotatedTileBox pTb) {
            LinkedHashMap<RotatedTileBox, ImageStorage> linkedHashMap = this.mImageStore;
            synchronized (linkedHashMap) {
                this.mTileOrder.init(pTb);
            }
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            if (!OsmBitmapPanel.this.isQueueEmpty()) {
                return;
            }
            if (this.mTileOrder.hasNext()) {
                RotatedTileBox tb = this.mTileOrder.getNext();
                OsmBitmapPanel.this.queue(new GenerationThread(OsmBitmapPanel.this, tb){

                    @Override
                    public void runAfterThreadsBeforeHaveFinished() {
                        CalculateUnzoomedPicturesAction.this.addToCache(this.mTileCopy, this.mNewBitmap, this.mResult);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToCache(RotatedTileBox pTileBox, BufferedImage pBitmap, OsmandRenderer.RenderingResult pResult) {
            LinkedHashMap<RotatedTileBox, ImageStorage> linkedHashMap = this.mImageStore;
            synchronized (linkedHashMap) {
                log.debug((Object)("Adding  " + pTileBox + " to the cache."));
                this.mImageStore.put(pTileBox, new ImageStorage(pBitmap, pTileBox, pResult));
            }
        }

        public class ImageStorage {
            public BufferedImage mImage;
            public RotatedTileBox mTileBox;
            public OsmandRenderer.RenderingResult mResult;

            public ImageStorage(BufferedImage pImage, RotatedTileBox pTileBox, OsmandRenderer.RenderingResult pResult) {
                this.mImage = pImage;
                this.mTileBox = pTileBox;
                this.mResult = pResult;
            }
        }
    }

    public static interface IntermediateImageListener {
        public void propagateImage();
    }
}

