/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public abstract class CubeGrid
implements PrimitiveList {
    private int nx = 1;
    private int ny = 1;
    private int nz = 1;
    private float voxelwx;
    private float voxelwy;
    private float voxelwz;
    private float invVoxelwx;
    private float invVoxelwy;
    private float invVoxelwz;
    private BoundingBox bounds = new BoundingBox(1.0f);

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.nx = parameterList.getInt("resolutionX", this.nx);
        this.ny = parameterList.getInt("resolutionY", this.ny);
        this.nz = parameterList.getInt("resolutionZ", this.nz);
        this.voxelwx = 2.0f / (float)this.nx;
        this.voxelwy = 2.0f / (float)this.ny;
        this.voxelwz = 2.0f / (float)this.nz;
        this.invVoxelwx = 1.0f / this.voxelwx;
        this.invVoxelwy = 1.0f / this.voxelwy;
        this.invVoxelwz = 1.0f / this.voxelwz;
        return true;
    }

    protected abstract boolean inside(int var1, int var2, int var3);

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void prepareShadingState(ShadingState shadingState) {
        Vector3 vector3;
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        switch (shadingState.getPrimitiveID()) {
            case 0: {
                vector3 = new Vector3(-1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                vector3 = new Vector3(1.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                vector3 = new Vector3(0.0f, -1.0f, 0.0f);
                break;
            }
            case 3: {
                vector3 = new Vector3(0.0f, 1.0f, 0.0f);
                break;
            }
            case 4: {
                vector3 = new Vector3(0.0f, 0.0f, -1.0f);
                break;
            }
            case 5: {
                vector3 = new Vector3(0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                vector3 = new Vector3(0.0f, 0.0f, 0.0f);
            }
        }
        shadingState.getNormal().set(shadingState.transformNormalObjectToWorld(vector3));
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        boolean bl;
        float f;
        float f2;
        int n2;
        int n3;
        float f3;
        float f4;
        int n4;
        int n5;
        float f5;
        float f6;
        int n6;
        int n7;
        float f7 = ray.getMin();
        float f8 = ray.getMax();
        float f9 = ray.ox;
        float f10 = ray.oy;
        float f11 = ray.oz;
        float f12 = ray.dx;
        float f13 = 1.0f / f12;
        float f14 = ray.dy;
        float f15 = 1.0f / f14;
        float f16 = ray.dz;
        float f17 = 1.0f / f16;
        float f18 = (-1.0f - f9) * f13;
        float f19 = (1.0f - f9) * f13;
        int n8 = -1;
        if (f13 > 0.0f) {
            if (f18 > f7) {
                f7 = f18;
                n8 = 0;
            }
            if (f19 < f8) {
                f8 = f19;
            }
            if (f7 > f8) {
                return;
            }
        } else {
            if (f19 > f7) {
                f7 = f19;
                n8 = 1;
            }
            if (f18 < f8) {
                f8 = f18;
            }
            if (f7 > f8) {
                return;
            }
        }
        f18 = (-1.0f - f10) * f15;
        f19 = (1.0f - f10) * f15;
        if (f15 > 0.0f) {
            if (f18 > f7) {
                f7 = f18;
                n8 = 2;
            }
            if (f19 < f8) {
                f8 = f19;
            }
            if (f7 > f8) {
                return;
            }
        } else {
            if (f19 > f7) {
                f7 = f19;
                n8 = 3;
            }
            if (f18 < f8) {
                f8 = f18;
            }
            if (f7 > f8) {
                return;
            }
        }
        f18 = (-1.0f - f11) * f17;
        f19 = (1.0f - f11) * f17;
        if (f17 > 0.0f) {
            if (f18 > f7) {
                f7 = f18;
                n8 = 4;
            }
            if (f19 < f8) {
                f8 = f19;
            }
            if (f7 > f8) {
                return;
            }
        } else {
            if (f19 > f7) {
                f7 = f19;
                n8 = 5;
            }
            if (f18 < f8) {
                f8 = f18;
            }
            if (f7 > f8) {
                return;
            }
        }
        f10 += f7 * f14;
        f11 += f7 * f16;
        int n9 = (int)(((f9 += f7 * f12) + 1.0f) * this.invVoxelwx);
        if (n9 < 0) {
            n9 = 0;
        } else if (n9 >= this.nx) {
            n9 = this.nx - 1;
        }
        if (Math.abs(f12) < 1.0E-6f) {
            n7 = 0;
            n6 = n9;
            f6 = 0.0f;
            f5 = Float.POSITIVE_INFINITY;
        } else if (f12 > 0.0f) {
            n7 = 1;
            n6 = this.nx;
            f6 = this.voxelwx * f13;
            f5 = f7 + ((float)(n9 + 1) * this.voxelwx - 1.0f - f9) * f13;
        } else {
            n7 = -1;
            n6 = -1;
            f6 = -this.voxelwx * f13;
            f5 = f7 + ((float)n9 * this.voxelwx - 1.0f - f9) * f13;
        }
        int n10 = (int)((f10 + 1.0f) * this.invVoxelwy);
        if (n10 < 0) {
            n10 = 0;
        } else if (n10 >= this.ny) {
            n10 = this.ny - 1;
        }
        if (Math.abs(f14) < 1.0E-6f) {
            n5 = 0;
            n4 = n10;
            f4 = 0.0f;
            f3 = Float.POSITIVE_INFINITY;
        } else if (f14 > 0.0f) {
            n5 = 1;
            n4 = this.ny;
            f4 = this.voxelwy * f15;
            f3 = f7 + ((float)(n10 + 1) * this.voxelwy - 1.0f - f10) * f15;
        } else {
            n5 = -1;
            n4 = -1;
            f4 = -this.voxelwy * f15;
            f3 = f7 + ((float)n10 * this.voxelwy - 1.0f - f10) * f15;
        }
        int n11 = (int)((f11 + 1.0f) * this.invVoxelwz);
        if (n11 < 0) {
            n11 = 0;
        } else if (n11 >= this.nz) {
            n11 = this.nz - 1;
        }
        if (Math.abs(f16) < 1.0E-6f) {
            n3 = 0;
            n2 = n11;
            f2 = 0.0f;
            f = Float.POSITIVE_INFINITY;
        } else if (f16 > 0.0f) {
            n3 = 1;
            n2 = this.nz;
            f2 = this.voxelwz * f17;
            f = f7 + ((float)(n11 + 1) * this.voxelwz - 1.0f - f11) * f17;
        } else {
            n3 = -1;
            n2 = -1;
            f2 = -this.voxelwz * f17;
            f = f7 + ((float)n11 * this.voxelwz - 1.0f - f11) * f17;
        }
        boolean bl2 = bl = this.inside(n9, n10, n11) && this.bounds.contains(ray.ox, ray.oy, ray.oz);
        while (true) {
            if (this.inside(n9, n10, n11) != bl) {
                ray.setMax(f7);
                if (bl) {
                    n8 ^= 1;
                }
                intersectionState.setIntersection(n8);
                return;
            }
            if (f5 < f3 && f5 < f) {
                n8 = f12 > 0.0f ? 0 : 1;
                f7 = f5;
                if (f7 > f8) {
                    return;
                }
                if ((n9 += n7) == n6) {
                    return;
                }
                f5 += f6;
                continue;
            }
            if (f3 < f) {
                n8 = f14 > 0.0f ? 2 : 3;
                f7 = f3;
                if (f7 > f8) {
                    return;
                }
                if ((n10 += n5) == n4) {
                    return;
                }
                f3 += f4;
                continue;
            }
            n8 = f16 > 0.0f ? 4 : 5;
            f7 = f;
            if (f7 > f8) {
                return;
            }
            if ((n11 += n3) == n2) {
                return;
            }
            f += f2;
        }
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        return (n2 & 1) == 0 ? -1.0f : 1.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        if (matrix4 == null) {
            return this.bounds;
        }
        return matrix4.transform(this.bounds);
    }
}

