/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.GSSToken;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.Krb5Token;

abstract class MessageToken
extends Krb5Token {
    private static final int TOKEN_NO_CKSUM_SIZE = 16;
    private static final int FILLER = 65535;
    static final int SGN_ALG_DES_MAC_MD5 = 0;
    static final int SGN_ALG_DES_MAC = 512;
    static final int SGN_ALG_HMAC_SHA1_DES3_KD = 1024;
    static final int SEAL_ALG_NONE = 65535;
    static final int SEAL_ALG_DES = 0;
    static final int SEAL_ALG_DES3_KD = 512;
    static final int SEAL_ALG_ARCFOUR_HMAC = 4096;
    static final int SGN_ALG_HMAC_MD5_ARCFOUR = 4352;
    private static final int TOKEN_ID_POS = 0;
    private static final int SIGN_ALG_POS = 2;
    private static final int SEAL_ALG_POS = 4;
    private int seqNumber;
    private boolean confState = true;
    private boolean initiator = true;
    private int tokenId = 0;
    private GSSHeader gssHeader = null;
    private MessageTokenHeader tokenHeader = null;
    private byte[] checksum = null;
    private byte[] encSeqNumber = null;
    private byte[] seqNumberData = null;
    CipherHelper cipherHelper = null;

    MessageToken(int n, Krb5Context krb5Context, byte[] byArray, int n2, int n3, MessageProp messageProp) throws GSSException {
        this(n, krb5Context, new ByteArrayInputStream(byArray, n2, n3), messageProp);
    }

    MessageToken(int n, Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        this.init(n, krb5Context);
        try {
            this.gssHeader = new GSSHeader(inputStream);
            if (!this.gssHeader.getOid().equals((Object)OID)) {
                throw new GSSException(10, -1, MessageToken.getTokenName(n));
            }
            if (!this.confState) {
                messageProp.setPrivacy(false);
            }
            this.tokenHeader = new MessageTokenHeader(inputStream, messageProp);
            this.encSeqNumber = new byte[8];
            MessageToken.readFully(inputStream, this.encSeqNumber);
            this.checksum = new byte[this.cipherHelper.getChecksumLength()];
            MessageToken.readFully(inputStream, this.checksum);
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, MessageToken.getTokenName(n) + ":" + iOException.getMessage());
        }
    }

    public final GSSHeader getGSSHeader() {
        return this.gssHeader;
    }

    public final int getTokenId() {
        return this.tokenId;
    }

    public final byte[] getEncSeqNumber() {
        return this.encSeqNumber;
    }

    public final byte[] getChecksum() {
        return this.checksum;
    }

    public final boolean getConfState() {
        return this.confState;
    }

    public void genSignAndSeqNumber(MessageProp messageProp, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) throws GSSException {
        int n3 = messageProp.getQOP();
        if (n3 != 0) {
            n3 = 0;
            messageProp.setQOP(n3);
        }
        if (!this.confState) {
            messageProp.setPrivacy(false);
        }
        this.tokenHeader = new MessageTokenHeader(this.tokenId, messageProp.getPrivacy(), n3);
        this.checksum = this.getChecksum(byArray, byArray2, n, n2, byArray3);
        this.seqNumberData = new byte[8];
        if (this.cipherHelper.isArcFour()) {
            MessageToken.writeBigEndian(this.seqNumber, this.seqNumberData);
        } else {
            MessageToken.writeLittleEndian(this.seqNumber, this.seqNumberData);
        }
        if (!this.initiator) {
            this.seqNumberData[4] = -1;
            this.seqNumberData[5] = -1;
            this.seqNumberData[6] = -1;
            this.seqNumberData[7] = -1;
        }
        this.encSeqNumber = this.cipherHelper.encryptSeq(this.checksum, this.seqNumberData, 0, 8);
    }

    public final boolean verifySignAndSeqNumber(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) throws GSSException {
        byte[] byArray4 = this.getChecksum(byArray, byArray2, n, n2, byArray3);
        if (MessageDigest.isEqual(this.checksum, byArray4)) {
            this.seqNumberData = this.cipherHelper.decryptSeq(this.checksum, this.encSeqNumber, 0, 8);
            byte by = 0;
            if (this.initiator) {
                by = -1;
            }
            if (this.seqNumberData[4] == by && this.seqNumberData[5] == by && this.seqNumberData[6] == by && this.seqNumberData[7] == by) {
                return true;
            }
        }
        return false;
    }

    public final int getSequenceNumber() {
        int n = 0;
        n = this.cipherHelper.isArcFour() ? MessageToken.readBigEndian(this.seqNumberData, 0, 4) : MessageToken.readLittleEndian(this.seqNumberData, 0, 4);
        return n;
    }

    private byte[] getChecksum(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3) throws GSSException {
        byte[] byArray4 = this.tokenHeader.getBytes();
        byte[] byArray5 = byArray;
        byte[] byArray6 = byArray4;
        if (byArray5 != null) {
            byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        }
        return this.cipherHelper.calculateChecksum(this.tokenHeader.getSignAlg(), byArray6, byArray3, byArray2, n, n2, this.tokenId);
    }

    MessageToken(int n, Krb5Context krb5Context) throws GSSException {
        this.init(n, krb5Context);
        this.seqNumber = krb5Context.incrementMySequenceNumber();
    }

    private void init(int n, Krb5Context krb5Context) throws GSSException {
        this.tokenId = n;
        this.confState = krb5Context.getConfState();
        this.initiator = krb5Context.isInitiator();
        this.cipherHelper = krb5Context.getCipherHelper(null);
    }

    public void encode(OutputStream outputStream) throws IOException, GSSException {
        this.gssHeader = new GSSHeader(OID, this.getKrb5TokenSize());
        this.gssHeader.encode(outputStream);
        this.tokenHeader.encode(outputStream);
        outputStream.write(this.encSeqNumber);
        outputStream.write(this.checksum);
    }

    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize();
    }

    protected final int getTokenSize() throws GSSException {
        return 16 + this.cipherHelper.getChecksumLength();
    }

    protected static final int getTokenSize(CipherHelper cipherHelper) throws GSSException {
        return 16 + cipherHelper.getChecksumLength();
    }

    protected abstract int getSealAlg(boolean var1, int var2) throws GSSException;

    protected int getSgnAlg(int n) throws GSSException {
        return this.cipherHelper.getSgnAlg();
    }

    class MessageTokenHeader {
        private int tokenId;
        private int signAlg;
        private int sealAlg;
        private byte[] bytes = new byte[8];

        public MessageTokenHeader(int n, boolean bl, int n2) throws GSSException {
            this.tokenId = n;
            this.signAlg = MessageToken.this.getSgnAlg(n2);
            this.sealAlg = MessageToken.this.getSealAlg(bl, n2);
            this.bytes[0] = (byte)(n >>> 8);
            this.bytes[1] = (byte)n;
            this.bytes[2] = (byte)(this.signAlg >>> 8);
            this.bytes[3] = (byte)this.signAlg;
            this.bytes[4] = (byte)(this.sealAlg >>> 8);
            this.bytes[5] = (byte)this.sealAlg;
            this.bytes[6] = -1;
            this.bytes[7] = -1;
        }

        public MessageTokenHeader(InputStream inputStream, MessageProp messageProp) throws IOException {
            GSSToken.readFully(inputStream, this.bytes);
            this.tokenId = GSSToken.readInt(this.bytes, 0);
            this.signAlg = GSSToken.readInt(this.bytes, 2);
            this.sealAlg = GSSToken.readInt(this.bytes, 4);
            int n = GSSToken.readInt(this.bytes, 6);
            switch (this.sealAlg) {
                case 0: 
                case 512: 
                case 4096: {
                    messageProp.setPrivacy(true);
                    break;
                }
                default: {
                    messageProp.setPrivacy(false);
                }
            }
            messageProp.setQOP(0);
        }

        public final void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this.bytes);
        }

        public final int getTokenId() {
            return this.tokenId;
        }

        public final int getSignAlg() {
            return this.signAlg;
        }

        public final int getSealAlg() {
            return this.sealAlg;
        }

        public final byte[] getBytes() {
            return this.bytes;
        }
    }
}

