/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMMessageFormatter;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;

public class ElementNSImpl
extends ElementImpl {
    static final long serialVersionUID = -9142310625494392642L;
    static final String xmlURI = "http://www.w3.org/XML/1998/namespace";
    protected String namespaceURI;
    protected String localName;
    transient XSTypeDefinition type;

    protected ElementNSImpl() {
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2) throws DOMException {
        super(coreDocumentImpl, string2);
        this.setName(string, string2);
    }

    private void setName(String string, String string2) {
        this.namespaceURI = string;
        if (string != null) {
            this.namespaceURI = string.length() == 0 ? null : string;
        }
        int n = string2.indexOf(58);
        int n2 = string2.lastIndexOf(58);
        this.ownerDocument().checkNamespaceWF(string2, n, n2);
        if (n < 0) {
            this.localName = string2;
            this.ownerDocument().checkQName(null, this.localName);
            if (string2.equals("xmlns") && (string == null || !string.equals(NamespaceContext.XMLNS_URI)) || string != null && string.equals(NamespaceContext.XMLNS_URI) && !string2.equals("xmlns")) {
                String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                throw new DOMException(14, string3);
            }
        } else {
            String string4 = string2.substring(0, n);
            this.localName = string2.substring(n2 + 1);
            this.ownerDocument().checkQName(string4, this.localName);
            this.ownerDocument().checkDOMNSErr(string4, string);
        }
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string, String string2, String string3) throws DOMException {
        super(coreDocumentImpl, string2);
        this.localName = string3;
        this.namespaceURI = string;
    }

    protected ElementNSImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl, string);
    }

    void rename(String string, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = string2;
        this.setName(string, string2);
        this.reconcileDefaultAttributes();
    }

    protected void setValues(CoreDocumentImpl coreDocumentImpl, String string, String string2, String string3) {
        this.firstChild = null;
        this.previousSibling = null;
        this.nextSibling = null;
        this.fNodeListCache = null;
        this.attributes = null;
        this.flags = 0;
        this.setOwnerDocument(coreDocumentImpl);
        this.needsSyncData(true);
        this.name = string2;
        this.localName = string3;
        this.namespaceURI = string;
    }

    public String getNamespaceURI() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.namespaceURI;
    }

    public String getPrefix() {
        int n;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return (n = this.name.indexOf(58)) < 0 ? null : this.name.substring(0, n);
    }

    public void setPrefix(String string) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument().errorChecking) {
            if (this.isReadOnly()) {
                String string2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, string2);
            }
            if (string != null && string.length() != 0) {
                if (!CoreDocumentImpl.isXMLName(string)) {
                    String string3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_CHARACTER_ERR", null);
                    throw new DOMException(5, string3);
                }
                if (this.namespaceURI == null || string.indexOf(58) >= 0) {
                    String string4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                    throw new DOMException(14, string4);
                }
                if (string.equals("xml") && !this.namespaceURI.equals(xmlURI)) {
                    String string5 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null);
                    throw new DOMException(14, string5);
                }
            }
        }
        this.name = string != null && string.length() != 0 ? string + ":" + this.localName : this.localName;
    }

    public String getLocalName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.localName;
    }

    public String getBaseURI() {
        String string;
        Attr attr;
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string2 = this.ownerNode.getBaseURI();
        if (this.attributes != null && (attr = (Attr)this.attributes.getNamedItemNS(xmlURI, "base")) != null && (string = attr.getNodeValue()).length() != 0) {
            try {
                string = new URI(new URI(string2), string).toString();
            }
            catch (URI.MalformedURIException malformedURIException) {
                return null;
            }
            return string;
        }
        return string2;
    }

    public String getTypeName() {
        if (this.type != null) {
            return this.type.getName();
        }
        return null;
    }

    public String getTypeNamespace() {
        if (this.type != null) {
            return this.type.getNamespace();
        }
        return null;
    }

    public void setType(XSTypeDefinition xSTypeDefinition) {
        this.type = xSTypeDefinition;
    }
}

