/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;

abstract class AttributeDesugaring {
    AttributeDesugaring() {
    }

    static ImmutableAttributes desugar(ImmutableAttributes attributes, ImmutableAttributesFactory attributesFactory) {
        if (attributes.isEmpty()) {
            return attributes;
        }
        AttributeContainerInternal mutable = attributesFactory.mutable();
        ImmutableSet keySet = attributes.keySet();
        for (Attribute attribute : keySet) {
            Object value = attributes.getAttribute(attribute);
            Attribute desugared = (Attribute)Cast.uncheckedCast((Object)attribute);
            if (attribute.getType() == Boolean.class || attribute.getType() == String.class) {
                mutable.attribute(desugared, value);
                continue;
            }
            desugared = (Attribute)Cast.uncheckedCast((Object)Attribute.of((String)attribute.getName(), String.class));
            mutable.attribute(desugared, (Object)value.toString());
        }
        return mutable.asImmutable();
    }

    static ComponentSelector desugarSelector(ComponentSelector selector, ImmutableAttributesFactory attributesFactory) {
        DefaultProjectComponentSelector project;
        AttributeContainer projectAttributes;
        ModuleComponentSelector module;
        AttributeContainer moduleAttributes;
        if (selector instanceof ModuleComponentSelector && !(moduleAttributes = (module = (ModuleComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)moduleAttributes).asImmutable();
            return DefaultModuleComponentSelector.newSelector(module.getModuleIdentifier(), module.getVersionConstraint(), (AttributeContainer)AttributeDesugaring.desugar(attributes, attributesFactory));
        }
        if (selector instanceof DefaultProjectComponentSelector && !(projectAttributes = (project = (DefaultProjectComponentSelector)selector).getAttributes()).isEmpty()) {
            ImmutableAttributes attributes = ((AttributeContainerInternal)projectAttributes).asImmutable();
            return new DefaultProjectComponentSelector(project.getBuildIdentifier(), project.getIdentityPath(), project.projectPath(), project.getProjectName(), AttributeDesugaring.desugar(attributes, attributesFactory));
        }
        return selector;
    }
}

