/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.java.WebApplication;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultWarPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;

public class WarPlugin
implements Plugin<Project> {
    public static final String PROVIDED_COMPILE_CONFIGURATION_NAME = "providedCompile";
    public static final String PROVIDED_RUNTIME_CONFIGURATION_NAME = "providedRuntime";
    public static final String WAR_TASK_NAME = "war";
    public static final String WEB_APP_GROUP = "web application";
    private final ObjectFactory objectFactory;

    @Inject
    public WarPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        final DefaultWarPluginConvention pluginConvention = new DefaultWarPluginConvention(project);
        project.getConvention().getPlugins().put(WAR_TASK_NAME, pluginConvention);
        project.getTasks().withType(War.class).configureEach((Action)new Action<War>(){

            public void execute(War task) {
                task.from(new Object[]{new Callable(){

                    public Object call() throws Exception {
                        return pluginConvention.getWebAppDir();
                    }
                }});
                task.dependsOn(new Object[]{new Callable(){

                    public Object call() throws Exception {
                        return ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
                    }
                }});
                task.classpath(new Callable(){

                    public Object call() throws Exception {
                        FileCollection runtimeClasspath = ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getRuntimeClasspath();
                        Configuration providedRuntime = project.getConfigurations().getByName(WarPlugin.PROVIDED_RUNTIME_CONFIGURATION_NAME);
                        return runtimeClasspath.minus((FileCollection)providedRuntime);
                    }
                });
            }
        });
        TaskProvider war = project.getTasks().register(WAR_TASK_NAME, War.class, (Action)new Action<War>(){

            public void execute(War war) {
                war.setDescription("Generates a war archive with all the compiled classes, the web-app content and the libraries.");
                war.setGroup("build");
            }
        });
        LazyPublishArtifact warArtifact = new LazyPublishArtifact((Provider)war);
        ((DefaultArtifactPublicationSet)project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)warArtifact);
        this.configureConfigurations(project.getConfigurations());
        this.configureComponent(project, (PublishArtifact)warArtifact);
    }

    public void configureConfigurations(ConfigurationContainer configurationContainer) {
        Configuration provideCompileConfiguration = ((Configuration)configurationContainer.create(PROVIDED_COMPILE_CONFIGURATION_NAME)).setVisible(false).setDescription("Additional compile classpath for libraries that should not be part of the WAR archive.");
        Configuration provideRuntimeConfiguration = ((Configuration)configurationContainer.create(PROVIDED_RUNTIME_CONFIGURATION_NAME)).setVisible(false).extendsFrom(new Configuration[]{provideCompileConfiguration}).setDescription("Additional runtime classpath for libraries that should not be part of the WAR archive.");
        configurationContainer.getByName("compile").extendsFrom(new Configuration[]{provideCompileConfiguration});
        configurationContainer.getByName("runtime").extendsFrom(new Configuration[]{provideRuntimeConfiguration});
    }

    private void configureComponent(Project project, PublishArtifact warArtifact) {
        project.getComponents().add(this.objectFactory.newInstance(WebApplication.class, new Object[]{warArtifact, this.objectFactory.named(Usage.class, "master")}));
    }
}

