/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.utils;

public class Converter {
    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)((n & 0xFF) >> 0)};
        return byArray;
    }

    public static void intToByteArray(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)((n2 & 0xFF000000) >> 24);
        byArray[n++] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n++] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n] = (byte)((n2 & 0xFF) >> 0);
    }

    public static int byteArrayToInt(byte[] byArray) {
        return byArray[0] << 24 & 0xFF000000 | byArray[1] << 16 & 0xFF0000 | byArray[2] << 8 & 0xFF00 | byArray[3] & 0xFF;
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        return byArray[n++] << 24 & 0xFF000000 | byArray[n++] << 16 & 0xFF0000 | byArray[n++] << 8 & 0xFF00 | byArray[n] & 0xFF;
    }

    public static void floatToByteArray(byte[] byArray, int n, float f) {
        Converter.intToByteArray(byArray, n, Float.floatToIntBits(f));
    }

    public static float byteArrayToFloat(byte[] byArray, int n) {
        return Float.intBitsToFloat(Converter.byteArrayToInt(byArray, n));
    }

    public static void longToByteArray(byte[] byArray, int n, long l) {
        Converter.intToByteArray(byArray, n, (int)(l >> 32));
        Converter.intToByteArray(byArray, n + 4, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    public static long byteArrayToLong(byte[] byArray, int n) {
        return (long)Converter.byteArrayToInt(byArray, n) << 32 | (long)Converter.byteArrayToInt(byArray, n + 4) & 0xFFFFFFFFL;
    }

    public static String byteArrayToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)byArray[n];
            ++n;
        }
        return new String(cArray);
    }

    public static byte[] stringToByteArray(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        return byArray;
    }
}

