/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.function.BiFunction;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlUtils;

public final class GetCapabilitiesParseHelper {
    public static final String OWS_NS_URL = "http://www.opengis.net/ows/1.1";
    public static final String XLINK_NS_URL = "http://www.w3.org/1999/xlink";
    static final QName QN_OWS_ALLOWED_VALUES = new QName("http://www.opengis.net/ows/1.1", "AllowedValues");
    static final QName QN_OWS_CONSTRAINT = new QName("http://www.opengis.net/ows/1.1", "Constraint");
    static final QName QN_OWS_DCP = new QName("http://www.opengis.net/ows/1.1", "DCP");
    static final QName QN_OWS_GET = new QName("http://www.opengis.net/ows/1.1", "Get");
    static final QName QN_OWS_HTTP = new QName("http://www.opengis.net/ows/1.1", "HTTP");
    static final QName QN_OWS_IDENTIFIER = new QName("http://www.opengis.net/ows/1.1", "Identifier");
    static final QName QN_OWS_OPERATION = new QName("http://www.opengis.net/ows/1.1", "Operation");
    static final QName QN_OWS_OPERATIONS_METADATA = new QName("http://www.opengis.net/ows/1.1", "OperationsMetadata");
    static final QName QN_OWS_SUPPORTED_CRS = new QName("http://www.opengis.net/ows/1.1", "SupportedCRS");
    static final QName QN_OWS_TITLE = new QName("http://www.opengis.net/ows/1.1", "Title");
    static final QName QN_OWS_VALUE = new QName("http://www.opengis.net/ows/1.1", "Value");

    private GetCapabilitiesParseHelper() {
    }

    public static XMLStreamReader getReader(InputStream in) throws XMLStreamException {
        return XmlUtils.newSafeXMLInputFactory().createXMLStreamReader(in);
    }

    public static void moveReaderToEndCurrentTag(XMLStreamReader reader) throws XMLStreamException {
        int level = 0;
        QName tag = reader.getName();
        int event = reader.getEventType();
        while (reader.hasNext()) {
            if (1 == event) {
                ++level;
            } else if (2 == event && --level == 0 && tag.equals(reader.getName())) {
                return;
            }
            if (level < 0) {
                throw new IllegalStateException("WMTS Parser error - moveReaderToEndCurrentTag failed to find closing tag");
            }
            event = reader.next();
        }
        throw new IllegalStateException("WMTS Parser error - moveReaderToEndCurrentTag failed to find closing tag");
    }

    public static String getElementTextWithSubtags(XMLStreamReader reader) throws XMLStreamException {
        StringBuilder ret = new StringBuilder();
        int level = 0;
        QName tag = reader.getName();
        int event = reader.getEventType();
        while (reader.hasNext()) {
            if (1 == event) {
                if (level > 0) {
                    ret.append('<').append(reader.getLocalName()).append('>');
                }
                ++level;
            } else if (2 == event) {
                if (--level == 0 && tag.equals(reader.getName())) {
                    return ret.toString();
                }
                ret.append("</").append(reader.getLocalName()).append('>');
            } else if (4 == event) {
                ret.append(reader.getText());
            }
            if (level < 0) {
                throw new IllegalStateException("WMTS Parser error - moveReaderToEndCurrentTag failed to find closing tag");
            }
            event = reader.next();
        }
        throw new IllegalStateException("WMTS Parser error - moveReaderToEndCurrentTag failed to find closing tag");
    }

    public static boolean moveReaderToTag(XMLStreamReader reader, QName ... tags) throws XMLStreamException {
        return GetCapabilitiesParseHelper.moveReaderToTag(reader, QName::equals, tags);
    }

    public static boolean moveReaderToTag(XMLStreamReader reader, BiFunction<QName, QName, Boolean> equalsFunc, QName ... tags) throws XMLStreamException {
        QName stopTag = reader.getName();
        int currentLevel = 0;
        QName searchTag = tags[currentLevel];
        QName parentTag = null;
        QName skipTag = null;
        int event = 0;
        while (reader.hasNext() && (event != 2 || !equalsFunc.apply(stopTag, reader.getName()).booleanValue())) {
            if (event == 2 && skipTag != null && equalsFunc.apply(skipTag, reader.getName()).booleanValue()) {
                skipTag = null;
            }
            if (skipTag == null) {
                if (event == 1) {
                    if (equalsFunc.apply(searchTag, reader.getName()).booleanValue()) {
                        if (++currentLevel >= tags.length) {
                            return true;
                        }
                        parentTag = searchTag;
                        searchTag = tags[currentLevel];
                    } else {
                        skipTag = reader.getName();
                    }
                }
                if (event == 2 && parentTag != null && equalsFunc.apply(parentTag, reader.getName()).booleanValue()) {
                    searchTag = parentTag;
                    parentTag = --currentLevel >= 0 ? tags[currentLevel] : null;
                }
            }
            event = reader.next();
        }
        return false;
    }

    public static TransferMode getTransferMode(XMLStreamReader reader) throws XMLStreamException {
        QName getQname = QN_OWS_GET;
        Utils.ensure(getQname.equals(reader.getName()), "WMTS Parser state invalid. Expected element %s, got %s", getQname, reader.getName());
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !getQname.equals(reader.getName()))) {
            if (event == 1 && QN_OWS_CONSTRAINT.equals(reader.getName()) && "GetEncoding".equals(reader.getAttributeValue("", "name"))) {
                GetCapabilitiesParseHelper.moveReaderToTag(reader, QN_OWS_ALLOWED_VALUES, QN_OWS_VALUE);
                return TransferMode.fromString(reader.getElementText());
            }
            event = reader.next();
        }
        return null;
    }

    public static String normalizeCapabilitiesUrl(String url) throws MalformedURLException {
        URL inUrl = new URL(url);
        URL ret = new URL(inUrl.getProtocol(), inUrl.getHost(), inUrl.getPort(), inUrl.getFile());
        return ret.toExternalForm();
    }

    public static String crsToCode(String crsIdentifier) {
        if (crsIdentifier.startsWith("urn:ogc:def:crs:")) {
            return crsIdentifier.replaceFirst("urn:ogc:def:crs:([^:]*)(?::.*)?:(.*)$", "$1:$2").toUpperCase(Locale.ENGLISH);
        }
        return crsIdentifier;
    }

    static enum TransferMode {
        KVP("KVP"),
        REST("RESTful");

        private final String typeString;

        private TransferMode(String urlString) {
            this.typeString = urlString;
        }

        private String getTypeString() {
            return this.typeString;
        }

        static TransferMode fromString(String s) {
            for (TransferMode type : TransferMode.values()) {
                if (!type.getTypeString().equals(s)) continue;
                return type;
            }
            return null;
        }
    }
}

