/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;

@JRubyClass(name={"TrueClass", "FalseClass"})
public class RubyBoolean
extends RubyObject
implements Constantizable {
    private final int hashCode;
    private final Object constant;
    static final ByteList FALSE_BYTES = new ByteList(new byte[]{102, 97, 108, 115, 101}, USASCIIEncoding.INSTANCE);
    static final ByteList TRUE_BYTES = new ByteList(new byte[]{116, 114, 117, 101}, USASCIIEncoding.INSTANCE);

    RubyBoolean(Ruby runtime2, boolean value2) {
        super(runtime2, value2 ? runtime2.getTrueClass() : runtime2.getFalseClass(), false);
        if (!value2) {
            this.flags = FALSE_F;
        }
        this.hashCode = RubyInstanceConfig.CONSISTENT_HASHING_ENABLED ? (value2 ? 155 : -48) : System.identityHashCode(this);
        this.constant = OptoFactory.newConstantWrapper(IRubyObject.class, this);
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return (this.flags & FALSE_F) == 0 ? ClassIndex.TRUE : ClassIndex.FALSE;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.TYPE;
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    public static RubyClass createFalseClass(Ruby runtime2) {
        RubyClass falseClass = runtime2.defineClass("FalseClass", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setFalseClass(falseClass);
        falseClass.setClassIndex(ClassIndex.FALSE);
        falseClass.setReifiedClass(RubyBoolean.class);
        falseClass.defineAnnotatedMethods(False.class);
        falseClass.defineAnnotatedMethods(RubyBoolean.class);
        falseClass.getMetaClass().undefineMethod("new");
        return falseClass;
    }

    public static RubyClass createTrueClass(Ruby runtime2) {
        RubyClass trueClass = runtime2.defineClass("TrueClass", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setTrueClass(trueClass);
        trueClass.setClassIndex(ClassIndex.TRUE);
        trueClass.setReifiedClass(RubyBoolean.class);
        trueClass.defineAnnotatedMethods(True.class);
        trueClass.defineAnnotatedMethods(RubyBoolean.class);
        trueClass.getMetaClass().undefineMethod("new");
        return trueClass;
    }

    public static RubyBoolean newBoolean(Ruby runtime2, boolean value2) {
        return value2 ? runtime2.getTrue() : runtime2.getFalse();
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public RubyFixnum id() {
        if ((this.flags & FALSE_F) == 0) {
            return RubyFixnum.newFixnum(this.getRuntime(), 20L);
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }

    public static class True
    extends RubyBoolean {
        True(Ruby runtime2) {
            super(runtime2, true);
            this.flags |= FROZEN_F;
        }

        @JRubyMethod(name={"&"})
        public static IRubyObject true_and(IRubyObject t, IRubyObject oth) {
            return oth.isTrue() ? t : t.getRuntime().getFalse();
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject true_or(IRubyObject t, IRubyObject oth) {
            return t;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject true_xor(IRubyObject t, IRubyObject oth) {
            return oth.isTrue() ? t.getRuntime().getFalse() : t;
        }

        @JRubyMethod(name={"to_s"}, alias={"inspect"})
        public static RubyString true_to_s(IRubyObject t) {
            return RubyString.newStringShared(t.getRuntime(), TRUE_BYTES);
        }

        @Override
        public <T> T toJava(Class<T> target) {
            if (target.isAssignableFrom(Boolean.class) || target == Boolean.TYPE) {
                return (T)Boolean.TRUE;
            }
            return super.toJava(target);
        }
    }

    public static class False
    extends RubyBoolean {
        False(Ruby runtime2) {
            super(runtime2, false);
            this.flags = FALSE_F | FROZEN_F;
        }

        @JRubyMethod(name={"&"})
        public static IRubyObject false_and(IRubyObject f, IRubyObject oth) {
            return f;
        }

        @JRubyMethod(name={"|"})
        public static IRubyObject false_or(IRubyObject f, IRubyObject oth) {
            return oth.isTrue() ? f.getRuntime().getTrue() : f;
        }

        @JRubyMethod(name={"^"})
        public static IRubyObject false_xor(IRubyObject f, IRubyObject oth) {
            return oth.isTrue() ? f.getRuntime().getTrue() : f;
        }

        @JRubyMethod(name={"to_s"}, alias={"inspect"})
        public static RubyString false_to_s(IRubyObject f) {
            return RubyString.newStringShared(f.getRuntime(), FALSE_BYTES);
        }

        @Override
        public <T> T toJava(Class<T> target) {
            if (target.isAssignableFrom(Boolean.class) || target == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return super.toJava(target);
        }
    }
}

