/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.handler;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public abstract class Text
implements DataContentHandler {
    protected DataFlavor flavor;

    protected Text(String mimeType, String description) {
        this.flavor = new ActivationDataFlavor(String.class, mimeType, description);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{this.flavor};
        return flavors;
    }

    public Object getTransferData(DataFlavor flavor, DataSource source) throws UnsupportedFlavorException, IOException {
        if (this.flavor.equals(flavor)) {
            return this.getContent(source);
        }
        return null;
    }

    public Object getContent(DataSource source) throws IOException {
        int len;
        InputStream in = source.getInputStream();
        String mimeType = source.getContentType();
        String charset = Text.getJavaCharset(mimeType);
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buf = new char[4096];
        StringBuffer buffer = new StringBuffer();
        while ((len = reader.read(buf)) > -1) {
            buffer.append(new String(buf, 0, len));
        }
        return buffer.toString();
    }

    public void writeTo(Object object, String mimeType, OutputStream out) throws IOException {
        String text = null;
        text = object instanceof String ? (String)object : (object instanceof byte[] ? new String((byte[])object) : (object instanceof char[] ? new String((char[])object) : object.toString()));
        String charset = Text.getJavaCharset(mimeType);
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(text);
        writer.flush();
    }

    protected static String getJavaCharset(String contentType) {
        String charset = "us-ascii";
        if (contentType != null) {
            try {
                ContentType ct = new ContentType(contentType);
                String ctCharset = ct.getParameter("charset");
                if (ctCharset != null) {
                    charset = ctCharset;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return MimeUtility.javaCharset(charset);
    }
}

