/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectFloatHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.gateway.TransportNodesListGatewayMetaState;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndicesService;

public class Gateway {
    private static final Logger logger = LogManager.getLogger(Gateway.class);
    private final ClusterService clusterService;
    private final TransportNodesListGatewayMetaState listGatewayMetaState;
    private final int minimumMasterNodes;
    private final IndicesService indicesService;

    public Gateway(Settings settings, ClusterService clusterService, TransportNodesListGatewayMetaState listGatewayMetaState, IndicesService indicesService) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.listGatewayMetaState = listGatewayMetaState;
        this.minimumMasterNodes = ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.get(settings);
    }

    public void performStateRecovery(GatewayStateRecoveredListener listener) throws GatewayException {
        Object[] nodesIds = (String[])this.clusterService.state().nodes().getMasterNodes().keys().toArray(String.class);
        logger.trace("performing state recovery from {}", (Object)Arrays.toString(nodesIds));
        TransportNodesListGatewayMetaState.NodesGatewayMetaState nodesState = this.listGatewayMetaState.list((String[])nodesIds, null).actionGet();
        int requiredAllocation = Math.max(1, this.minimumMasterNodes);
        if (nodesState.hasFailures()) {
            for (FailedNodeException failedNodeException : nodesState.failures()) {
                logger.warn("failed to fetch state from node", (Throwable)failedNodeException);
            }
        }
        ObjectFloatHashMap indices = new ObjectFloatHashMap();
        MetaData electedGlobalState = null;
        int found = 0;
        for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
            if (nodeState.metaData() == null) continue;
            ++found;
            if (electedGlobalState == null) {
                electedGlobalState = nodeState.metaData();
            } else if (nodeState.metaData().version() > electedGlobalState.version()) {
                electedGlobalState = nodeState.metaData();
            }
            for (ObjectCursor cursor : nodeState.metaData().indices().values()) {
                indices.addTo((Object)((IndexMetaData)cursor.value).getIndex(), 1.0f);
            }
        }
        if (found < requiredAllocation) {
            listener.onFailure("found [" + found + "] metadata states, required [" + requiredAllocation + "]");
            return;
        }
        MetaData.Builder metaDataBuilder = MetaData.builder(electedGlobalState).removeAllIndices();
        assert (!indices.containsKey(null));
        Object[] keys = indices.keys;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            Index index = (Index)keys[i];
            IndexMetaData electedIndexMetaData = null;
            int indexMetaDataCount = 0;
            for (TransportNodesListGatewayMetaState.NodeGatewayMetaState nodeState : nodesState.getNodes()) {
                IndexMetaData indexMetaData;
                if (nodeState.metaData() == null || (indexMetaData = nodeState.metaData().index(index)) == null) continue;
                if (electedIndexMetaData == null) {
                    electedIndexMetaData = indexMetaData;
                } else if (indexMetaData.getVersion() > electedIndexMetaData.getVersion()) {
                    electedIndexMetaData = indexMetaData;
                }
                ++indexMetaDataCount;
            }
            if (electedIndexMetaData == null) continue;
            if (indexMetaDataCount < requiredAllocation) {
                logger.debug("[{}] found [{}], required [{}], not adding", (Object)index, (Object)indexMetaDataCount, (Object)requiredAllocation);
            }
            try {
                if (electedIndexMetaData.getState() == IndexMetaData.State.OPEN) {
                    this.indicesService.verifyIndexMetadata(electedIndexMetaData, electedIndexMetaData);
                }
            }
            catch (Exception e) {
                Index electedIndex = electedIndexMetaData.getIndex();
                logger.warn(() -> new ParameterizedMessage("recovering index {} failed - recovering as closed", (Object)electedIndex), (Throwable)e);
                electedIndexMetaData = IndexMetaData.builder(electedIndexMetaData).state(IndexMetaData.State.CLOSE).build();
            }
            metaDataBuilder.put(electedIndexMetaData, false);
        }
        ClusterState.Builder builder = this.upgradeAndArchiveUnknownOrInvalidSettings(metaDataBuilder);
        listener.onSuccess(builder.build());
    }

    ClusterState.Builder upgradeAndArchiveUnknownOrInvalidSettings(MetaData.Builder metaDataBuilder) {
        ClusterSettings clusterSettings = this.clusterService.getClusterSettings();
        metaDataBuilder.persistentSettings(clusterSettings.archiveUnknownOrInvalidSettings(clusterSettings.upgradeSettings(metaDataBuilder.persistentSettings()), e -> this.logUnknownSetting("persistent", (Map.Entry<String, String>)e), (e, ex) -> this.logInvalidSetting("persistent", (Map.Entry<String, String>)e, (IllegalArgumentException)ex)));
        metaDataBuilder.transientSettings(clusterSettings.archiveUnknownOrInvalidSettings(clusterSettings.upgradeSettings(metaDataBuilder.transientSettings()), e -> this.logUnknownSetting("transient", (Map.Entry<String, String>)e), (e, ex) -> this.logInvalidSetting("transient", (Map.Entry<String, String>)e, (IllegalArgumentException)ex)));
        ClusterState.Builder builder = this.clusterService.newClusterStateBuilder();
        builder.metaData(metaDataBuilder);
        return builder;
    }

    private void logUnknownSetting(String settingType, Map.Entry<String, String> e) {
        logger.warn("ignoring unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex) {
        logger.warn(() -> new ParameterizedMessage("ignoring invalid {} setting: [{}] with value [{}]; archiving", new Object[]{settingType, e.getKey(), e.getValue()}), (Throwable)ex);
    }

    public static interface GatewayStateRecoveredListener {
        public void onSuccess(ClusterState var1);

        public void onFailure(String var1);
    }
}

