/*
 * Decompiled with CFR 0.152.
 */
package net.iharder.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import net.iharder.dnd.DropListener;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;

    public FileDrop(Component component, DropListener dropListener) {
        this(null, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, dropListener);
    }

    private FileDrop(PrintStream printStream, Component component, DropListener dropListener) {
        this(printStream, component, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, dropListener);
    }

    private FileDrop(PrintStream printStream, Component component, Border border, boolean bl, DropListener dropListener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(this, printStream, component, border, dropListener){
                private /* synthetic */ PrintStream val$out;
                private /* synthetic */ Component val$c;
                private /* synthetic */ Border val$dragBorder;
                private /* synthetic */ DropListener val$listener;
                private /* synthetic */ FileDrop this$0;
                {
                    this.this$0 = fileDrop;
                    this.val$out = printStream;
                    this.val$c = component;
                    this.val$dragBorder = border;
                    this.val$listener = dropListener;
                }

                public final void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    FileDrop.log(this.val$out, "FileDrop: dragEnter event.");
                    if (FileDrop.access$100$741c49b4(this.val$out, dropTargetDragEvent)) {
                        if (this.val$c instanceof JComponent) {
                            JComponent jComponent = (JComponent)this.val$c;
                            this.this$0.normalBorder = jComponent.getBorder();
                            FileDrop.log(this.val$out, "FileDrop: normal border saved.");
                            jComponent.setBorder(this.val$dragBorder);
                            FileDrop.log(this.val$out, "FileDrop: drag border set.");
                        }
                        dropTargetDragEvent.acceptDrag(1);
                        FileDrop.log(this.val$out, "FileDrop: event accepted.");
                        return;
                    }
                    dropTargetDragEvent.rejectDrag();
                    FileDrop.log(this.val$out, "FileDrop: event rejected.");
                }

                public final void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                }

                /*
                 * Loose catch block
                 */
                public final void drop(DropTargetDropEvent dropTargetDropEvent) {
                    block15: {
                        FileDrop.log(this.val$out, "FileDrop: drop event.");
                        try {
                            Object object = dropTargetDropEvent.getTransferable();
                            if (object.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                                dropTargetDropEvent.acceptDrop(1);
                                FileDrop.log(this.val$out, "FileDrop: file list accepted.");
                                Object object2 = object.getTransferData(DataFlavor.javaFileListFlavor);
                                if (object2 instanceof List) {
                                    List list = (List)object2;
                                    File[] fileArray = new File[list.size()];
                                    list.toArray(fileArray);
                                    object = fileArray;
                                    if (this.val$listener != null) {
                                        this.val$listener.filesDropped((File[])object);
                                    }
                                } else {
                                    FileDrop.log(this.val$out, "FileDrop: not a list of files");
                                }
                                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                                FileDrop.log(this.val$out, "FileDrop: drop complete.");
                            } else {
                                DataFlavor[] dataFlavorArray = object.getTransferDataFlavors();
                                boolean bl = false;
                                for (int i = 0; i < dataFlavorArray.length; ++i) {
                                    if (!dataFlavorArray[i].isRepresentationClassReader()) continue;
                                    dropTargetDropEvent.acceptDrop(1);
                                    FileDrop.log(this.val$out, "FileDrop: reader accepted.");
                                    object = dataFlavorArray[i].getReaderForText((Transferable)object);
                                    object = new BufferedReader((Reader)object);
                                    if (this.val$listener != null) {
                                        this.val$listener.filesDropped(FileDrop.createFileArray((BufferedReader)object, this.val$out));
                                    }
                                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                                    FileDrop.log(this.val$out, "FileDrop: drop complete.");
                                    bl = true;
                                    break;
                                }
                                if (!bl) {
                                    FileDrop.log(this.val$out, "FileDrop: not a file list or reader - abort.");
                                    dropTargetDropEvent.rejectDrop();
                                }
                            }
                            if (!(this.val$c instanceof JComponent)) break block15;
                            ((JComponent)this.val$c).setBorder(this.this$0.normalBorder);
                        }
                        catch (IOException iOException) {
                            FileDrop.log(this.val$out, "FileDrop: IOException - abort:");
                            iOException.printStackTrace(this.val$out);
                            dropTargetDropEvent.rejectDrop();
                            return;
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            FileDrop.log(this.val$out, "FileDrop: UnsupportedFlavorException - abort:");
                            unsupportedFlavorException.printStackTrace(this.val$out);
                            dropTargetDropEvent.rejectDrop();
                            return;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (!(this.val$c instanceof JComponent)) break block15;
                            ((JComponent)this.val$c).setBorder(this.this$0.normalBorder);
                            FileDrop.log(this.val$out, "FileDrop: normal border restored.");
                        }
                        FileDrop.log(this.val$out, "FileDrop: normal border restored.");
                        return;
                    }
                }

                public final void dragExit(DropTargetEvent dropTargetEvent) {
                    FileDrop.log(this.val$out, "FileDrop: dragExit event.");
                    if (this.val$c instanceof JComponent) {
                        ((JComponent)this.val$c).setBorder(this.this$0.normalBorder);
                        FileDrop.log(this.val$out, "FileDrop: normal border restored.");
                    }
                }

                public final void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                    FileDrop.log(this.val$out, "FileDrop: dropActionChanged event.");
                    if (FileDrop.access$100$741c49b4(this.val$out, dropTargetDragEvent)) {
                        dropTargetDragEvent.acceptDrag(1);
                        FileDrop.log(this.val$out, "FileDrop: event accepted.");
                        return;
                    }
                    dropTargetDragEvent.rejectDrag();
                    FileDrop.log(this.val$out, "FileDrop: event rejected.");
                }
            };
            this.makeDropTarget(printStream, component, bl);
            return;
        }
        FileDrop.log(printStream, "FileDrop: Drag and drop is not supported with this JVM");
    }

    private static final boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean bl;
            try {
                bl = Class.forName("java.awt.dnd.DnDConstants").getName().equals("java.awt.dnd.DnDConstants");
            }
            catch (Exception exception) {
                bl = false;
            }
            supportsDnD = bl;
        }
        return supportsDnD;
    }

    private static final File[] createFileArray(BufferedReader bufferedReader, PrintStream printStream) {
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while ((object = bufferedReader.readLine()) != null) {
                try {
                    if ("\u0000".equals(object)) continue;
                    object = new File(new URI((String)object));
                    arrayList.add(object);
                }
                catch (URISyntaxException uRISyntaxException) {
                    FileDrop.log(printStream, "FileDrop: URISyntaxException");
                }
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        catch (IOException iOException) {
            FileDrop.log(printStream, "FileDrop: IOException");
            return new File[0];
        }
    }

    private final void makeDropTarget(PrintStream printStream, Component componentArray, boolean bl) {
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
            FileDrop.log(printStream, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        componentArray.addHierarchyListener(new HierarchyListener(this, printStream, (Component)componentArray){
            private /* synthetic */ PrintStream val$out;
            private /* synthetic */ Component val$c;
            private /* synthetic */ FileDrop this$0;
            {
                this.this$0 = fileDrop;
                this.val$out = printStream;
                this.val$c = component;
            }

            public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                FileDrop.log(this.val$out, "FileDrop: Hierarchy changed.");
                if (this.val$c.getParent() == null) {
                    this.val$c.setDropTarget(null);
                    FileDrop.log(this.val$out, "FileDrop: Drop target cleared from component.");
                    return;
                }
                new DropTarget(this.val$c, this.this$0.dropListener);
                FileDrop.log(this.val$out, "FileDrop: Drop target added to component.");
            }
        });
        if (componentArray.getParent() != null) {
            new DropTarget((Component)componentArray, this.dropListener);
        }
        if (bl && componentArray instanceof Container) {
            componentArray = ((Container)componentArray).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.makeDropTarget(printStream, componentArray[i], bl);
            }
        }
    }

    private static void log(PrintStream printStream, String string) {
        if (printStream != null) {
            printStream.println(string);
        }
    }

    public static final void main(String[] object) {
        object = new JFrame("FileDrop");
        JTextArea jTextArea = new JTextArea();
        ((JFrame)object).getContentPane().add((Component)new JScrollPane(jTextArea), "Center");
        new FileDrop(System.out, jTextArea, new DropListener(jTextArea){
            private /* synthetic */ JTextArea val$text;
            {
                this.val$text = jTextArea;
            }

            public final void filesDropped(File[] fileArray) {
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        this.val$text.append(fileArray[i].getCanonicalPath() + "\n");
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        ((Window)object).setBounds(100, 100, 300, 400);
        ((JFrame)object).setDefaultCloseOperation(3);
        ((Window)object).show();
    }

    static /* synthetic */ boolean access$100$741c49b4(PrintStream dataFlavorArray, DropTargetDragEvent dropTargetDragEvent) {
        int n;
        PrintStream printStream = dataFlavorArray;
        dataFlavorArray = dropTargetDragEvent;
        PrintStream printStream2 = printStream;
        boolean bl = false;
        dataFlavorArray = dataFlavorArray.getCurrentDataFlavors();
        for (n = 0; !bl && n < dataFlavorArray.length; ++n) {
            DataFlavor dataFlavor = dataFlavorArray[n];
            if (!dataFlavor.equals(DataFlavor.javaFileListFlavor) && !dataFlavor.isRepresentationClassReader()) continue;
            bl = true;
        }
        if (printStream2 != null) {
            if (dataFlavorArray.length == 0) {
                FileDrop.log(printStream2, "FileDrop: no data flavors.");
            }
            for (n = 0; n < dataFlavorArray.length; ++n) {
                FileDrop.log(printStream2, dataFlavorArray[n].toString());
            }
        }
        return bl;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    }
}

