/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public class DefaultTypedConfigGetter
implements TypedConfigGetter {
    @Override
    public boolean getBoolean(Config config, String section, String subsection, String name2, boolean defaultValue) {
        String n = config.getRawString(section, subsection, name2);
        if (n == null) {
            return defaultValue;
        }
        if (Config.MAGIC_EMPTY_VALUE == n) {
            return true;
        }
        try {
            return StringUtils.toBoolean(n);
        }
        catch (IllegalArgumentException err) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidBooleanValue, section, name2, n));
        }
    }

    @Override
    public <T extends Enum<?>> T getEnum(Config config, T[] all, String section, String subsection, String name2, T defaultValue) {
        String value = config.getString(section, subsection, name2);
        if (value == null) {
            return defaultValue;
        }
        if (all[0] instanceof Config.ConfigEnum) {
            for (T t : all) {
                if (!((Config.ConfigEnum)t).matchConfigValue(value)) continue;
                return t;
            }
        }
        String n = value.replace(' ', '_');
        n = n.replace('-', '_');
        T trueState = null;
        T falseState = null;
        for (T e2 : all) {
            if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), n)) {
                return e2;
            }
            if (StringUtils.equalsIgnoreCase(((Enum)e2).name(), "TRUE")) {
                trueState = e2;
                continue;
            }
            if (!StringUtils.equalsIgnoreCase(((Enum)e2).name(), "FALSE")) continue;
            falseState = e2;
        }
        if (trueState != null && falseState != null) {
            try {
                return StringUtils.toBoolean(n) ? trueState : falseState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (subsection != null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, section, subsection, name2, value));
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, section, name2, value));
    }

    @Override
    public int getInt(Config config, String section, String subsection, String name2, int defaultValue) {
        long val2 = config.getLong(section, subsection, name2, defaultValue);
        if (Integer.MIN_VALUE <= val2 && val2 <= Integer.MAX_VALUE) {
            return (int)val2;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().integerValueOutOfRange, section, name2));
    }

    @Override
    public long getLong(Config config, String section, String subsection, String name2, long defaultValue) {
        String str2 = config.getString(section, subsection, name2);
        if (str2 == null) {
            return defaultValue;
        }
        String n = str2.trim();
        if (n.length() == 0) {
            return defaultValue;
        }
        long mul = 1L;
        switch (StringUtils.toLowerCase(n.charAt(n.length() - 1))) {
            case 'g': {
                mul = 0x40000000L;
                break;
            }
            case 'm': {
                mul = 0x100000L;
                break;
            }
            case 'k': {
                mul = 1024L;
            }
        }
        if (mul > 1L) {
            n = n.substring(0, n.length() - 1).trim();
        }
        if (n.length() == 0) {
            return defaultValue;
        }
        try {
            return mul * Long.parseLong(n);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidIntegerValue, section, name2, str2));
        }
    }

    @Override
    public long getTimeUnit(Config config, String section, String subsection, String name2, long defaultValue, TimeUnit wantUnit) {
        int inputMul;
        TimeUnit inputUnit;
        String valueString = config.getString(section, subsection, name2);
        if (valueString == null) {
            return defaultValue;
        }
        String s = valueString.trim();
        if (s.length() == 0) {
            return defaultValue;
        }
        if (s.startsWith("-")) {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, name2, valueString);
        }
        Matcher m = Pattern.compile("^(0|[1-9][0-9]*)\\s*(.*)$").matcher(valueString);
        if (!m.matches()) {
            return defaultValue;
        }
        String digits = m.group(1);
        String unitName = m.group(2).trim();
        if (unitName.isEmpty()) {
            inputUnit = wantUnit;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "ms", "milliseconds")) {
            inputUnit = TimeUnit.MILLISECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "s", "sec", "second", "seconds")) {
            inputUnit = TimeUnit.SECONDS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "m", "min", "minute", "minutes")) {
            inputUnit = TimeUnit.MINUTES;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "h", "hr", "hour", "hours")) {
            inputUnit = TimeUnit.HOURS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "d", "day", "days")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 1;
        } else if (DefaultTypedConfigGetter.match(unitName, "w", "week", "weeks")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 7;
        } else if (DefaultTypedConfigGetter.match(unitName, "mon", "month", "months")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 30;
        } else if (DefaultTypedConfigGetter.match(unitName, "y", "year", "years")) {
            inputUnit = TimeUnit.DAYS;
            inputMul = 365;
        } else {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, name2, valueString);
        }
        try {
            return wantUnit.convert(Long.parseLong(digits) * (long)inputMul, inputUnit);
        }
        catch (NumberFormatException nfe) {
            throw DefaultTypedConfigGetter.notTimeUnit(section, subsection, unitName, valueString);
        }
    }

    private static boolean match(String a, String ... cases) {
        for (String b : cases) {
            if (b == null || !b.equalsIgnoreCase(a)) continue;
            return true;
        }
        return false;
    }

    private static IllegalArgumentException notTimeUnit(String section, String subsection, String name2, String valueString) {
        if (subsection != null) {
            return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue3, section, subsection, name2, valueString));
        }
        return new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeUnitValue2, section, name2, valueString));
    }

    @Override
    @NonNull
    public List<RefSpec> getRefSpecs(Config config, String section, String subsection, String name2) {
        String[] values = config.getStringList(section, subsection, name2);
        ArrayList<RefSpec> result = new ArrayList<RefSpec>(values.length);
        for (String spec2 : values) {
            result.add(new RefSpec(spec2));
        }
        return result;
    }
}

