/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.PT;
import javajs.util.SB;

public class QS {
    public static final int S = 0;
    public static final int P = 1;
    public static final int SP = 2;
    public static final int DS = 3;
    public static final int DC = 4;
    public static final int FS = 5;
    public static final int FC = 6;
    public static final int GS = 7;
    public static final int GC = 8;
    public static final int HS = 9;
    public static final int HC = 10;
    public static final int IS = 11;
    public static final int IC = 12;
    public static int MAX_TYPE_SUPPORTED = 6;
    private static final int MAXID = 13;
    public static final int[] idSpherical;
    public static final String[] tags;
    public static final String[] tags2;
    public static final String CANONICAL_DC_LIST = "DXX   DYY   DZZ   DXY   DXZ   DYZ";
    public static final String CANONICAL_DS_LIST = "d0    d1+   d1-   d2+   d2-";
    public static final String CANONICAL_FC_LIST = "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ";
    public static final String CANONICAL_FS_LIST = "f0    f1+   f1-   f2+   f2-   f3+   f3-";

    static {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 5;
        nArray[7] = 7;
        nArray[8] = 7;
        nArray[9] = 9;
        nArray[10] = 9;
        nArray[11] = 11;
        nArray[12] = 11;
        idSpherical = nArray;
        tags = new String[]{"S", "P", "SP", "5D", "D", "7F", "F", "9G", "G", "11H", "H", "13I", "I"};
        tags2 = new String[]{"S", "X", "SP", "5D", "XX", "7F", "XXX", "9G", "XXXX", "11H", "XXXXX", "13I", "XXXXXX"};
    }

    public static boolean isQuantumBasisSupported(char c) {
        return "SPLDF".indexOf(Character.toUpperCase(c)) >= 0;
    }

    public static int[][] getNewDfCoefMap() {
        return new int[][]{new int[1], new int[3], new int[4], new int[5], new int[6], new int[7], new int[10], new int[9], new int[15], new int[11], new int[21], new int[13], new int[28]};
    }

    public static int getItem(int n) {
        return n >= 0 && n < 13 ? n : -1;
    }

    public static int getQuantumShellTagID(String string) {
        return string.equals("L") ? 2 : QS.getQuantumShell(string);
    }

    private static int getQuantumShell(String string) {
        int n = 0;
        while (n < 13) {
            if (tags[n].equals(string) || tags2[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static final int getQuantumShellTagIDSpherical(String string) {
        if (string.equals("L")) {
            return 2;
        }
        int n = QS.getQuantumShell(string);
        return n < 0 ? n : idSpherical[n];
    }

    public static final String getQuantumShellTag(int n) {
        return n >= 0 && n < 13 ? tags[n] : "" + n;
    }

    public static final String getMOString(float[] fArray) {
        SB sB = new SB();
        if (fArray.length == 2) {
            return "" + (int)(fArray[0] < 0.0f ? -fArray[1] : fArray[1]);
        }
        sB.appendC('[');
        int n = 0;
        while (n < fArray.length) {
            if (n > 0) {
                sB.append(", ");
            }
            sB.appendF(fArray[n]).append(" ").appendI((int)fArray[n + 1]);
            n += 2;
        }
        sB.appendC(']');
        return sB.toString();
    }

    public static boolean createDFMap(int[] nArray, String string, String string2, int n) {
        String[] stringArray = PT.getTokens(string);
        boolean bl = true;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            String string3 = stringArray[n2];
            if (string3.length() < n || (n3 = string2.indexOf(string3)) < 0) {
                bl = false;
                break;
            }
            nArray[n3 /= 6] = n2 - n3;
            ++n2;
        }
        if (!bl) {
            nArray[0] = Integer.MIN_VALUE;
        }
        return bl;
    }
}

