/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.backport9.buffer.Buffers;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.Constantizable;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

@JRubyClass(name={"Encoding"})
public class RubyEncoding
extends RubyObject
implements Constantizable {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ISO = Charset.forName("ISO-8859-1");
    public static final ByteList LOCALE = ByteList.create("locale");
    public static final ByteList EXTERNAL = ByteList.create("external");
    public static final ByteList FILESYSTEM = ByteList.create("filesystem");
    public static final ByteList INTERNAL = ByteList.create("internal");
    private Encoding encoding;
    private final ByteList name;
    private final boolean isDummy;
    private final Object constant;
    private static final int CHAR_THRESHOLD = 1024;
    private static final ThreadLocal<SoftReference<UTF8Coder>> UTF8_CODER = new ThreadLocal();

    public static RubyClass createEncodingClass(Ruby runtime2) {
        RubyClass encodingc = runtime2.defineClass("Encoding", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setEncoding(encodingc);
        encodingc.setClassIndex(ClassIndex.ENCODING);
        encodingc.setReifiedClass(RubyEncoding.class);
        encodingc.kindOf = new RubyModule.JavaClassKindOf(RubyEncoding.class);
        encodingc.getSingletonClass().undefineMethod("allocate");
        encodingc.defineAnnotatedMethods(RubyEncoding.class);
        return encodingc;
    }

    private RubyEncoding(Ruby runtime2, byte[] name2, int p2, int end2, boolean isDummy) {
        this(runtime2, new ByteList(name2, p2, end2), null, isDummy);
    }

    private RubyEncoding(Ruby runtime2, byte[] name2, Encoding encoding2, boolean isDummy) {
        this(runtime2, new ByteList(name2), encoding2, isDummy);
    }

    private RubyEncoding(Ruby runtime2, ByteList name2, Encoding encoding2, boolean isDummy) {
        super(runtime2, runtime2.getEncoding());
        this.name = name2;
        this.isDummy = isDummy;
        this.encoding = encoding2;
        this.constant = OptoFactory.newConstantWrapper(RubyEncoding.class, this);
    }

    @Override
    public Object constant() {
        return this.constant;
    }

    public static RubyEncoding newEncoding(Ruby runtime2, byte[] name2, int p2, int end2, boolean isDummy) {
        return new RubyEncoding(runtime2, name2, p2, end2, isDummy);
    }

    public final Encoding getEncoding() {
        if (this.encoding == null) {
            this.encoding = this.getRuntime().getEncodingService().loadEncoding(this.name);
        }
        return this.encoding;
    }

    private static Encoding extractEncodingFromObject(IRubyObject obj) {
        if (obj instanceof RubyEncoding) {
            return ((RubyEncoding)obj).getEncoding();
        }
        if (obj instanceof EncodingCapable) {
            return ((EncodingCapable)((Object)obj)).getEncoding();
        }
        return null;
    }

    public static Encoding areCompatible(IRubyObject obj1, IRubyObject obj2) {
        Encoding enc1 = RubyEncoding.extractEncodingFromObject(obj1);
        Encoding enc2 = RubyEncoding.extractEncodingFromObject(obj2);
        if (enc1 == null || enc2 == null) {
            return null;
        }
        if (enc1 == enc2) {
            return enc1;
        }
        if (obj2 instanceof RubyString && ((RubyString)obj2).getByteList().getRealSize() == 0) {
            return enc1;
        }
        if (obj1 instanceof RubyString && ((RubyString)obj1).getByteList().getRealSize() == 0) {
            return enc1.isAsciiCompatible() && obj2 instanceof RubyString && ((RubyString)obj2).isAsciiOnly() ? enc1 : enc2;
        }
        if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
            return null;
        }
        if (!(obj2 instanceof RubyString) && enc2 instanceof USASCIIEncoding) {
            return enc1;
        }
        if (!(obj1 instanceof RubyString) && enc1 instanceof USASCIIEncoding) {
            return enc2;
        }
        if (!(obj1 instanceof RubyString)) {
            IRubyObject objTmp = obj1;
            obj1 = obj2;
            obj2 = objTmp;
            Encoding encTmp = enc1;
            enc1 = enc2;
            enc2 = encTmp;
        }
        if (obj1 instanceof RubyString) {
            int cr1 = ((RubyString)obj1).scanForCodeRange();
            if (obj2 instanceof RubyString) {
                int cr2 = ((RubyString)obj2).scanForCodeRange();
                return RubyEncoding.areCompatible(enc1, cr1, enc2, cr2);
            }
            if (cr1 == 16) {
                return enc2;
            }
        }
        return null;
    }

    public static Encoding areCompatible(Encoding enc1, int cr1, Encoding enc2, int cr2) {
        if (cr1 != cr2) {
            if (cr1 == 16) {
                return enc2;
            }
            if (cr2 == 16) {
                return enc1;
            }
        }
        if (cr2 == 16) {
            return enc1;
        }
        if (cr1 == 16) {
            return enc2;
        }
        return null;
    }

    public static byte[] encodeUTF8(String str) {
        return RubyEncoding.encodeUTF8((CharSequence)str);
    }

    public static byte[] encodeUTF8(CharSequence str) {
        if (str.length() > 1024) {
            return RubyEncoding.getBytes(UTF8.encode(RubyEncoding.toCharBuffer(str)));
        }
        return RubyEncoding.getBytes(RubyEncoding.getUTF8Coder().encode(str));
    }

    static ByteList doEncodeUTF8(String str) {
        if (str.length() > 1024) {
            return RubyEncoding.getByteList(UTF8.encode(CharBuffer.wrap(str)), UTF8Encoding.INSTANCE, false);
        }
        return RubyEncoding.getByteList(RubyEncoding.getUTF8Coder().encode(str), UTF8Encoding.INSTANCE, true);
    }

    static ByteList doEncodeUTF8(CharSequence str) {
        if (str.length() > 1024) {
            return RubyEncoding.getByteList(UTF8.encode(RubyEncoding.toCharBuffer(str)), UTF8Encoding.INSTANCE, false);
        }
        return RubyEncoding.getByteList(RubyEncoding.getUTF8Coder().encode(str), UTF8Encoding.INSTANCE, true);
    }

    private static CharBuffer toCharBuffer(CharSequence str) {
        return str instanceof CharBuffer ? (CharBuffer)str : CharBuffer.wrap(str);
    }

    private static byte[] getBytes(ByteBuffer buffer) {
        byte[] bytes2 = new byte[buffer.limit()];
        buffer.get(bytes2);
        return bytes2;
    }

    private static ByteList getByteList(ByteBuffer buffer, Encoding enc, boolean shared) {
        int off;
        byte[] bytes2;
        if (!shared && buffer.hasArray()) {
            bytes2 = buffer.array();
            off = buffer.arrayOffset();
        } else {
            bytes2 = RubyEncoding.getBytes(buffer);
            off = 0;
        }
        return new ByteList(bytes2, off, off + buffer.limit(), enc, false);
    }

    public static byte[] encodeUTF16(String str) {
        return RubyEncoding.encode(str, UTF16);
    }

    public static byte[] encodeUTF16(CharSequence str) {
        return RubyEncoding.encode(str, UTF16);
    }

    static ByteList doEncodeUTF16(String str) {
        return RubyEncoding.doEncode(str, UTF16, (Encoding)UTF16BEEncoding.INSTANCE);
    }

    static ByteList doEncodeUTF16(CharSequence str) {
        return RubyEncoding.doEncode(str, UTF16, (Encoding)UTF16BEEncoding.INSTANCE);
    }

    public static byte[] encode(CharSequence cs, Charset charset) {
        ByteBuffer buffer = charset.encode(CharBuffer.wrap(cs));
        byte[] bytes2 = new byte[buffer.limit()];
        buffer.get(bytes2);
        return bytes2;
    }

    static ByteList doEncode(String cs, Charset charset, Encoding enc) {
        return RubyEncoding.getByteList(charset.encode(CharBuffer.wrap(cs)), enc, false);
    }

    static ByteList doEncode(CharSequence cs, Charset charset, Encoding enc) {
        return RubyEncoding.getByteList(charset.encode(RubyEncoding.toCharBuffer(cs)), enc, false);
    }

    public static byte[] encode(String str, Charset charset) {
        ByteBuffer buffer = charset.encode(str);
        byte[] bytes2 = new byte[buffer.limit()];
        buffer.get(bytes2);
        return bytes2;
    }

    public static String decodeUTF8(byte[] bytes2, int start2, int length2) {
        if (length2 > 1024) {
            return UTF8.decode(ByteBuffer.wrap(bytes2, start2, length2)).toString();
        }
        return RubyEncoding.getUTF8Coder().decode(bytes2, start2, length2).toString();
    }

    public static String decodeUTF8(byte[] bytes2) {
        return RubyEncoding.decodeUTF8(bytes2, 0, bytes2.length);
    }

    public static String decode(byte[] bytes2, int start2, int length2, Charset charset) {
        return charset.decode(ByteBuffer.wrap(bytes2, start2, length2)).toString();
    }

    public static String decode(byte[] bytes2, Charset charset) {
        return charset.decode(ByteBuffer.wrap(bytes2)).toString();
    }

    private static UTF8Coder getUTF8Coder() {
        UTF8Coder coder;
        SoftReference<UTF8Coder> ref = UTF8_CODER.get();
        if (ref == null || (coder = ref.get()) == null) {
            coder = new UTF8Coder();
            UTF8_CODER.set(new SoftReference<UTF8Coder>(coder));
        }
        return coder;
    }

    @JRubyMethod(name={"list"}, meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        return RubyArray.newArrayMayCopy(runtime2, runtime2.getEncodingService().getEncodingList());
    }

    @JRubyMethod(name={"locale_charmap"}, meta=true)
    public static IRubyObject locale_charmap(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        EncodingService service = runtime2.getEncodingService();
        ByteList name2 = new ByteList(service.getLocaleEncoding().getName());
        return RubyString.newUsAsciiStringNoCopy(runtime2, name2);
    }

    @JRubyMethod(name={"name_list"}, meta=true)
    public static IRubyObject name_list(ThreadContext context, IRubyObject recv2) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
        Ruby runtime2 = context.runtime;
        EncodingService service = runtime2.getEncodingService();
        RubyArray result2 = runtime2.newArray(service.getEncodings().size() + service.getAliases().size());
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getEncodings().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        i2 = service.getAliases().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        result2.append(runtime2.newString(EXTERNAL));
        result2.append(runtime2.newString(LOCALE));
        return result2;
    }

    @JRubyMethod(name={"aliases"}, meta=true)
    public static IRubyObject aliases(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.runtime;
        EncodingService service = runtime2.getEncodingService();
        IRubyObject[] list2 = service.getEncodingList();
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getAliases().entryIterator();
        RubyHash result2 = RubyHash.newHash(runtime2);
        while (i2.hasNext()) {
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            IRubyObject alias = RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context);
            IRubyObject name2 = RubyString.newUsAsciiStringShared(runtime2, ((RubyEncoding)list2[((EncodingDB.Entry)e.value).getIndex()]).name).freeze(context);
            result2.fastASet(alias, name2);
        }
        result2.fastASet(runtime2.newString(EXTERNAL), runtime2.newString(new ByteList(runtime2.getDefaultExternalEncoding().getName())));
        result2.fastASet(runtime2.newString(LOCALE), runtime2.newString(new ByteList(service.getLocaleEncoding().getName())));
        return result2;
    }

    @JRubyMethod(name={"find"}, meta=true)
    public static IRubyObject find(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        Ruby runtime2 = context.runtime;
        if (str instanceof RubyEncoding) {
            return str;
        }
        return runtime2.getEncodingService().rubyEncodingFromObject(str);
    }

    @JRubyMethod(name={"replicate"})
    public IRubyObject replicate(ThreadContext context, IRubyObject arg2) {
        return new RubyEncoding(context.runtime, arg2.convertToString().getBytes(), this.getEncoding(), this.isDummy);
    }

    @JRubyMethod(name={"_dump"})
    public IRubyObject _dump(ThreadContext context, IRubyObject arg2) {
        return this.to_s(context);
    }

    @JRubyMethod(name={"_load"}, meta=true)
    public static IRubyObject _load(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyEncoding.find(context, recv2, str);
    }

    @JRubyMethod(name={"ascii_compatible?"})
    public IRubyObject asciiCompatible_p(ThreadContext context) {
        return context.runtime.newBoolean(this.getEncoding().isAsciiCompatible());
    }

    @JRubyMethod(name={"to_s", "name"})
    public IRubyObject to_s(ThreadContext context) {
        return RubyString.newUsAsciiStringShared(context.runtime, this.name);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        ByteList bytes2 = new ByteList();
        bytes2.append("#<Encoding:".getBytes());
        bytes2.append(this.name);
        if (this.isDummy) {
            bytes2.append(" (dummy)".getBytes());
        }
        bytes2.append(62);
        return RubyString.newUsAsciiStringNoCopy(context.runtime, bytes2);
    }

    @JRubyMethod(name={"names"})
    public IRubyObject names(ThreadContext context) {
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e;
        Ruby runtime2 = context.runtime;
        EncodingService service = runtime2.getEncodingService();
        EncodingDB.Entry entry = service.findEncodingOrAliasEntry(this.name);
        RubyArray result2 = runtime2.newArray();
        CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i2 = service.getEncodings().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            if (e.value != entry) continue;
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        i2 = service.getAliases().entryIterator();
        while (i2.hasNext()) {
            e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)((Hash.HashEntryIterator)i2).next();
            if (e.value != entry) continue;
            result2.append(RubyString.newUsAsciiStringShared(runtime2, e.bytes, e.p, e.end - e.p).freeze(context));
        }
        result2.append(runtime2.newString(EXTERNAL));
        result2.append(runtime2.newString(LOCALE));
        return result2;
    }

    @JRubyMethod(name={"dummy?"})
    public IRubyObject dummy_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isDummy);
    }

    @JRubyMethod(name={"compatible?"}, meta=true)
    public static IRubyObject compatible_p(ThreadContext context, IRubyObject self2, IRubyObject first2, IRubyObject second2) {
        Ruby runtime2 = context.runtime;
        Encoding enc = RubyEncoding.areCompatible(first2, second2);
        return enc == null ? runtime2.getNil() : runtime2.getEncodingService().getEncoding(enc);
    }

    @JRubyMethod(name={"default_external"}, meta=true)
    public static IRubyObject getDefaultExternal(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getEncodingService().getDefaultExternal();
    }

    @JRubyMethod(name={"default_external="}, meta=true)
    public static IRubyObject setDefaultExternal(ThreadContext context, IRubyObject recv2, IRubyObject encoding2) {
        if (context.runtime.isVerbose()) {
            context.runtime.getWarnings().warning("setting Encoding.default_external");
        }
        EncodingUtils.rbEncSetDefaultExternal(context, encoding2);
        return encoding2;
    }

    @JRubyMethod(name={"default_internal"}, meta=true)
    public static IRubyObject getDefaultInternal(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getEncodingService().getDefaultInternal();
    }

    @Deprecated
    public static IRubyObject getDefaultInternal(IRubyObject recv2) {
        return RubyEncoding.getDefaultInternal(recv2.getRuntime().getCurrentContext(), recv2);
    }

    @JRubyMethod(name={"default_internal="}, required=1, meta=true)
    public static IRubyObject setDefaultInternal(ThreadContext context, IRubyObject recv2, IRubyObject encoding2) {
        if (context.runtime.isVerbose()) {
            context.runtime.getWarnings().warning("setting Encoding.default_internal");
        }
        EncodingUtils.rbEncSetDefaultInternal(context, encoding2);
        return encoding2;
    }

    private static class UTF8Coder {
        private final CharsetEncoder encoder = UTF8.newEncoder();
        private final CharsetDecoder decoder = UTF8.newDecoder();
        private static final int BUF_SIZE = 4096;
        private final ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        private final CharBuffer charBuffer = CharBuffer.allocate(4096);

        UTF8Coder() {
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        public final ByteBuffer encode(String str) {
            ByteBuffer buf = this.byteBuffer;
            CharBuffer cbuf = this.charBuffer;
            Buffers.clearBuffer(buf);
            Buffers.clearBuffer(cbuf);
            cbuf.put(str);
            Buffers.flipBuffer(cbuf);
            this.encoder.encode(cbuf, buf, true);
            Buffers.flipBuffer(buf);
            return buf;
        }

        public final ByteBuffer encode(CharSequence str) {
            ByteBuffer buf = this.byteBuffer;
            CharBuffer cbuf = this.charBuffer;
            Buffers.clearBuffer(buf);
            Buffers.clearBuffer(cbuf);
            for (int i2 = 0; i2 < str.length(); ++i2) {
                cbuf.put(str.charAt(i2));
            }
            Buffers.flipBuffer(cbuf);
            this.encoder.encode(cbuf, buf, true);
            Buffers.flipBuffer(buf);
            return buf;
        }

        public final CharBuffer decode(byte[] bytes2, int start2, int length2) {
            CharBuffer cbuf = this.charBuffer;
            ByteBuffer buf = this.byteBuffer;
            Buffers.clearBuffer(cbuf);
            Buffers.clearBuffer(buf);
            buf.put(bytes2, start2, length2);
            Buffers.flipBuffer(buf);
            this.decoder.decode(buf, cbuf, true);
            Buffers.flipBuffer(cbuf);
            return cbuf;
        }
    }
}

