/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.EndpointSelectionType;
import com.zeroc.Ice.Instrumentation.CommunicatorObserver;
import com.zeroc.Ice.Instrumentation.Observer;
import com.zeroc.Ice.Instrumentation.ThreadObserver;
import com.zeroc.Ice.Instrumentation.ThreadState;
import com.zeroc.Ice.LocalException;
import com.zeroc.IceInternal.EndpointI_connectors;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.IPEndpointI;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.NetworkProxy;
import com.zeroc.IceInternal.Util;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class EndpointHostResolver {
    private final Instance _instance;
    private final int _protocol;
    private final boolean _preferIPv6;
    private boolean _destroyed;
    private ThreadObserver _observer;
    private String _threadName;
    private ExecutorService _executor;

    EndpointHostResolver(Instance instance) {
        this._instance = instance;
        this._protocol = instance.protocolSupport();
        this._preferIPv6 = instance.preferIPv6();
        try {
            this._threadName = Util.createThreadName(this._instance.initializationData().properties, "Ice.HostResolver");
            this._executor = Executors.newFixedThreadPool(1, Util.createThreadFactory(this._instance.initializationData().properties, this._threadName));
            this.updateObserver();
        }
        catch (RuntimeException ex) {
            String s = "cannot create thread for endpoint host resolver thread:\n" + Ex.toString(ex);
            this._instance.initializationData().logger.error(s);
            throw ex;
        }
    }

    synchronized void resolve(String host, int port, EndpointSelectionType selType, IPEndpointI endpoint, EndpointI_connectors callback) {
        List<InetSocketAddress> addrs;
        assert (!this._destroyed);
        NetworkProxy networkProxy = this._instance.networkProxy();
        if (networkProxy == null && (addrs = Network.getAddresses(host, port, this._protocol, selType, this._preferIPv6, false)) != null) {
            callback.connectors(endpoint.connectors(addrs, networkProxy));
            return;
        }
        ThreadObserver threadObserver = this._observer;
        Observer observer = this.getObserver(endpoint);
        if (observer != null) {
            observer.attach();
        }
        this._executor.execute(() -> {
            EndpointHostResolver endpointHostResolver = this;
            synchronized (endpointHostResolver) {
                if (this._destroyed) {
                    CommunicatorDestroyedException ex = new CommunicatorDestroyedException();
                    if (observer != null) {
                        observer.failed(ex.ice_id());
                        observer.detach();
                    }
                    callback.exception(ex);
                    return;
                }
            }
            if (threadObserver != null) {
                threadObserver.stateChanged(ThreadState.ThreadStateIdle, ThreadState.ThreadStateInUseForOther);
            }
            Observer obsv = observer;
            try {
                int protocol = this._protocol;
                NetworkProxy np = this._instance.networkProxy();
                if (np != null && (np = np.resolveHost(this._protocol)) != null) {
                    protocol = np.getProtocolSupport();
                }
                List<InetSocketAddress> addresses = Network.getAddresses(host, port, this._protocol, selType, this._preferIPv6, true);
                if (obsv != null) {
                    obsv.detach();
                    obsv = null;
                }
                callback.connectors(endpoint.connectors(addresses, np));
            }
            catch (LocalException ex) {
                if (obsv != null) {
                    obsv.failed(ex.ice_id());
                    obsv.detach();
                }
                callback.exception(ex);
            }
            finally {
                if (threadObserver != null) {
                    threadObserver.stateChanged(ThreadState.ThreadStateInUseForOther, ThreadState.ThreadStateIdle);
                }
            }
        });
    }

    synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._executor.shutdown();
    }

    void joinWithThread() throws InterruptedException {
        try {
            while (!this._executor.isTerminated()) {
                this._executor.awaitTermination(100000L, TimeUnit.SECONDS);
            }
        }
        finally {
            if (this._observer != null) {
                this._observer.detach();
            }
        }
    }

    synchronized void updateObserver() {
        CommunicatorObserver obsv = this._instance.initializationData().observer;
        if (obsv != null) {
            this._observer = obsv.getThreadObserver("Communicator", this._threadName, ThreadState.ThreadStateIdle, this._observer);
            if (this._observer != null) {
                this._observer.attach();
            }
        }
    }

    private Observer getObserver(IPEndpointI endpoint) {
        CommunicatorObserver obsv = this._instance.initializationData().observer;
        if (obsv != null) {
            return obsv.getEndpointLookupObserver(endpoint);
        }
        return null;
    }
}

