/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.filters;

import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.filters.GenericFilter;

public class TextFilter
extends GenericFilter {
    public static final int TYPE_REGEXP = 30;
    private static final String[] NORMALIZED_NOT_READY = new String[0];
    private String[] normalizedValues = NORMALIZED_NOT_READY;
    private transient Pattern[] regexpPatterns;

    public TextFilter() {
        super(null, "", 10);
    }

    public TextFilter(String string, int n, boolean bl) {
        super(null, string, n);
        this.setCaseSensitive(bl);
    }

    public TextFilter(Properties properties, String string) {
        super(properties, string);
    }

    public void copyFrom(TextFilter textFilter) {
        super.copyFrom(textFilter);
        this.normalizedValues = textFilter.normalizedValues;
        this.regexpPatterns = textFilter.regexpPatterns;
    }

    @Override
    public boolean isAll() {
        return this.isEmpty();
    }

    public final void setCaseSensitive(boolean bl) {
        this.normalizedValues = bl || this.getType() == 30 ? null : NORMALIZED_NOT_READY;
    }

    public final boolean isCaseSensitive() {
        return this.normalizedValues == null;
    }

    @Override
    protected void valueChanged() {
        super.valueChanged();
        if (!this.isCaseSensitive()) {
            this.normalizedValues = NORMALIZED_NOT_READY;
        }
        this.regexpPatterns = null;
    }

    @Override
    public boolean passes(String string) {
        if (this.getType() == 30) {
            String[] stringArray = this.getValues();
            if (this.regexpPatterns == null) {
                this.regexpPatterns = new Pattern[stringArray.length];
            }
            for (int i = 0; i < this.regexpPatterns.length; ++i) {
                if (this.regexpPatterns[i] == null) {
                    try {
                        this.regexpPatterns[i] = Pattern.compile(stringArray[i]);
                    }
                    catch (RuntimeException runtimeException) {
                        this.handleInvalidFilter(stringArray[i], runtimeException);
                        this.regexpPatterns[i] = Pattern.compile(".*");
                    }
                }
                if (!this.regexpPatterns[i].matcher(string).matches()) continue;
                return true;
            }
            return false;
        }
        if (this.simplePasses(string)) {
            return true;
        }
        String[] stringArray = this.getValues();
        boolean bl = this.isCaseSensitive();
        if (!bl) {
            string = TextFilter.normalizeString(string);
            if (this.normalizedValues == NORMALIZED_NOT_READY) {
                this.normalizedValues = new String[stringArray.length];
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (!bl) {
                if (this.normalizedValues[i] == null) {
                    this.normalizedValues[i] = TextFilter.normalizeString(stringArray[i]);
                }
                string2 = this.normalizedValues[i];
            } else {
                string2 = stringArray[i];
            }
            if (!string.contains(string2)) continue;
            return this.getType() == 10;
        }
        return this.getType() != 10;
    }

    protected void handleInvalidFilter(String string, RuntimeException runtimeException) {
    }

    private static String normalizeString(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    @Override
    protected boolean valuesEquals(Object object) {
        if (!super.valuesEquals(object)) {
            return false;
        }
        TextFilter textFilter = (TextFilter)object;
        return !(this.normalizedValues == null ? textFilter.normalizedValues != null : textFilter.normalizedValues == null);
    }

    @Override
    protected int valuesHashCode(int n) {
        n = super.valuesHashCode(n);
        if (this.normalizedValues == null) {
            n = 67 * n;
        }
        return n;
    }
}

