/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;

public class CCTFlattener
extends RuntimeCCTNodeProcessor.PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTFlattener.class.getName());
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private ProfilerClient client;
    private Stack<TotalTime> parentStack;
    private Set methodsOnStack;
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private long[] totalTimePM0;
    private long[] totalTimePM1;
    private int nMethods;
    private CCTResultsFilter currentFilter;
    private InstrumentationFilter instrFilter;
    private int cpuProfilingType;
    private boolean twoTimestamps;
    private TimingAdjusterOld timingAdjuster;

    public CCTFlattener(ProfilerClient profilerClient, CCTResultsFilter cCTResultsFilter) {
        this.client = profilerClient;
        this.parentStack = new Stack();
        this.methodsOnStack = new HashSet();
        this.currentFilter = cCTResultsFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        ProfilerEngineSettings profilerEngineSettings = this.client.getSettings();
        this.nMethods = this.getMaxMethodId();
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[profilingSessionStatus.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.totalTimePM0 = new long[this.nMethods];
        this.totalTimePM1 = new long[profilingSessionStatus.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        this.methodsOnStack.clear();
        this.instrFilter = profilerEngineSettings.getInstrumentationFilter();
        this.cpuProfilingType = profilerEngineSettings.getCPUProfilingType();
        this.twoTimestamps = profilingSessionStatus.collectingTwoTimeStamps();
        this.timingAdjuster = TimingAdjusterOld.getInstance(profilingSessionStatus);
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double d = this.timingAdjuster.adjustTime(this.timePM0[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], false);
            if (d < 0.0) {
                d = 0.0;
            }
            this.timePM0[i] = (long)d;
            if (i > 0) {
                l = (long)((double)l + d);
            }
            if (this.twoTimestamps) {
                d = this.timingAdjuster.adjustTime(this.timePM1[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], true);
                if (d < 0.0) {
                    d = 0.0;
                }
                this.timePM1[i] = (long)d;
                if (i > 0) {
                    l2 = (long)((double)l2 + d);
                }
            }
            l3 += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = this.createContainer(this.timePM0, this.timePM1, this.totalTimePM0, this.totalTimePM1, this.invPM, l, l2);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.totalTimePM1 = null;
        this.totalTimePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
        this.methodsOnStack.clear();
        this.instrFilter = null;
    }

    @Override
    public void onNode(MethodCPUCCTNode methodCPUCCTNode) {
        Object object;
        int n;
        String string;
        boolean bl;
        int n2 = methodCPUCCTNode.getMethodId();
        int n3 = methodCPUCCTNode.getFilteredStatus();
        MethodCPUCCTNode methodCPUCCTNode2 = this.parentStack.isEmpty() ? null : this.parentStack.peek().parent;
        boolean bl2 = bl = n3 == 2;
        if (!(bl || this.cpuProfilingType != 2 && n3 != 1 || this.instrFilter.passes(string = this.getInstrMethodClass(n2).replace('.', '/')))) {
            bl = true;
        }
        if (!bl && this.currentFilter != null) {
            bl = !this.currentFilter.passesFilter();
        }
        int n4 = n = methodCPUCCTNode2 != null ? methodCPUCCTNode2.getMethodId() : -1;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Processing runtime node: {0}.{1}; filtered={2}, time={3}, CPU time={4}", new Object[]{this.getInstrMethodClass(n2), this.getInstrMethodName(n2), bl, methodCPUCCTNode.getNetTime0(), methodCPUCCTNode.getNetTime1()});
            object = methodCPUCCTNode2 != null ? this.getInstrMethodClass(n) + "." + this.getInstrMethodName(n) : "none";
            LOGGER.log(Level.FINEST, "Currently used parent: {0}", object);
        }
        if (bl) {
            if (methodCPUCCTNode2 != null && !methodCPUCCTNode2.isRoot()) {
                int n5 = n;
                this.invDiff[n5] = this.invDiff[n5] + methodCPUCCTNode.getNCalls();
                int n6 = n;
                this.timePM0[n6] = this.timePM0[n6] + methodCPUCCTNode.getNetTime0();
                if (this.twoTimestamps) {
                    int n7 = n;
                    this.timePM1[n7] = this.timePM1[n7] + methodCPUCCTNode.getNetTime1();
                }
            }
        } else {
            int n8 = n2;
            this.timePM0[n8] = this.timePM0[n8] + methodCPUCCTNode.getNetTime0();
            if (this.twoTimestamps) {
                int n9 = n2;
                this.timePM1[n9] = this.timePM1[n9] + methodCPUCCTNode.getNetTime1();
            }
            int n10 = n2;
            this.invPM[n10] = this.invPM[n10] + methodCPUCCTNode.getNCalls();
            if (methodCPUCCTNode2 != null && !methodCPUCCTNode2.isRoot()) {
                int n11 = n;
                this.nCalleeInvocations[n11] = this.nCalleeInvocations[n11] + methodCPUCCTNode.getNCalls();
            }
        }
        object = bl ? methodCPUCCTNode2 : methodCPUCCTNode;
        TotalTime totalTime = new TotalTime((MethodCPUCCTNode)object, this.methodsOnStack.contains(n2));
        totalTime.totalTimePM0 = totalTime.totalTimePM0 + methodCPUCCTNode.getNetTime0();
        if (this.twoTimestamps) {
            totalTime.totalTimePM1 = totalTime.totalTimePM1 + methodCPUCCTNode.getNetTime1();
        }
        if (!totalTime.recursive) {
            this.methodsOnStack.add(n2);
        }
        this.parentStack.push(totalTime);
    }

    @Override
    public void onBackout(MethodCPUCCTNode methodCPUCCTNode) {
        TotalTime totalTime = this.parentStack.pop();
        if (!totalTime.recursive) {
            int n = methodCPUCCTNode.getMethodId();
            this.methodsOnStack.remove(n);
            if (n != -1) {
                long l = (long)this.timingAdjuster.adjustTime(totalTime.totalTimePM0, methodCPUCCTNode.getNCalls() + totalTime.outCalls, totalTime.outCalls, false);
                if (l > 0L) {
                    int n2 = n;
                    this.totalTimePM0[n2] = this.totalTimePM0[n2] + l;
                }
                if (this.twoTimestamps && (l = (long)this.timingAdjuster.adjustTime(totalTime.totalTimePM1, methodCPUCCTNode.getNCalls() + totalTime.outCalls, totalTime.outCalls, true)) > 0L) {
                    int n3 = n;
                    this.totalTimePM1[n3] = this.totalTimePM1[n3] + l;
                }
            }
        }
        if (!this.parentStack.isEmpty()) {
            TotalTime totalTime2 = this.parentStack.peek();
            totalTime2.add(totalTime);
            TotalTime totalTime3 = totalTime2;
            totalTime3.outCalls = totalTime3.outCalls + methodCPUCCTNode.getNCalls();
        }
    }

    protected int getMaxMethodId() {
        return this.client.getStatus().getNInstrMethods();
    }

    protected String getInstrMethodClass(int n) {
        return this.client.getStatus().getInstrMethodClasses()[n];
    }

    protected String getInstrMethodName(int n) {
        return this.client.getStatus().getInstrMethodNames()[n];
    }

    protected FlatProfileContainer createContainer(long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, int[] nArray, double d, double d2) {
        return new FlatProfileContainerFree(this.client.getStatus(), lArray, lArray2, lArray3, lArray4, nArray, new char[0], d, d2, nArray.length);
    }

    private static class TotalTime {
        private final MethodCPUCCTNode parent;
        private final boolean recursive;
        private int outCalls;
        private long totalTimePM0;
        private long totalTimePM1;

        TotalTime(MethodCPUCCTNode methodCPUCCTNode, boolean bl) {
            this.parent = methodCPUCCTNode;
            this.recursive = bl;
        }

        private void add(TotalTime totalTime) {
            this.outCalls += totalTime.outCalls;
            this.totalTimePM0 += totalTime.totalTimePM0;
            this.totalTimePM1 += totalTime.totalTimePM1;
        }
    }
}

