//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The IceGrid administrative interface.
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 **/
public interface Admin extends com.zeroc.Ice.Object
{
    /**
     * Add an application to IceGrid.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    void addApplication(ApplicationDescriptor descriptor, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    void syncApplication(ApplicationDescriptor descriptor, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     * @param descriptor The update descriptor.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    void updateApplication(ApplicationUpdateDescriptor descriptor, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The application descriptor.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    void syncApplicationWithoutRestart(ApplicationDescriptor descriptor, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     * @param descriptor The update descriptor.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment
     * failed.
     **/
    void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     * @param name The application name.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if application deployment failed.
     **/
    void removeApplication(String name, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     * @param application The application name.
     * @param node The name of the node where the server will be
     * deployed.
     * @param desc The descriptor of the server instance to deploy.
     * @param current The Current object for the invocation.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws DeploymentException Raised if server instantiation
     * failed.
     **/
    void instantiateServer(String application, String node, ServerInstanceDescriptor desc, com.zeroc.Ice.Current current)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Patch the given application data.
     * @param name The application name.
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     * @throws PatchException Raised if the patch failed.
     **/
    java.util.concurrent.CompletionStage<Void> patchApplicationAsync(String name, boolean shutdown, com.zeroc.Ice.Current current)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Get an application descriptor.
     * @param name The application name.
     * @param current The Current object for the invocation.
     * @return The application descriptor.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     **/
    ApplicationInfo getApplicationInfo(String name, com.zeroc.Ice.Current current)
        throws ApplicationNotExistException;

    /**
     * Get the default application descriptor.
     * @param current The Current object for the invocation.
     * @return The default application descriptor.
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     **/
    ApplicationDescriptor getDefaultApplicationDescriptor(com.zeroc.Ice.Current current)
        throws DeploymentException;

    /**
     * Get all the IceGrid applications currently registered.
     * @param current The Current object for the invocation.
     * @return The application names.
     **/
    String[] getAllApplicationNames(com.zeroc.Ice.Current current);

    /**
     * Get the server information for the server with the given id.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server information.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    ServerInfo getServerInfo(String id, com.zeroc.Ice.Current current)
        throws ServerNotExistException;

    /**
     * Get a server's state.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server state.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    ServerState getServerState(String id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return The server's process id.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    int getServerPid(String id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     * @param current The Current object for the invocation.
     * @return The category for server admin objects.
     **/
    String getServerAdminCategory(com.zeroc.Ice.Current current);

    /**
     * Get a proxy to the server's admin object.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return A proxy to the server's admin object
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    com.zeroc.Ice.ObjectPrx getServerAdmin(String id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     * @param id The server id.
     * @param enabled True to enable the server, false to disable it.
     * @param current The Current object for the invocation.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     **/
    void enableServer(String id, boolean enabled, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return True if the server is enabled.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    boolean isServerEnabled(String id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Start a server and wait for its activation.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     **/
    java.util.concurrent.CompletionStage<Void> startServerAsync(String id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Stop a server.
     * @param id The server id.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     **/
    java.util.concurrent.CompletionStage<Void> stopServerAsync(String id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Patch a server.
     * @param id The server id.
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     * @param current The Current object for the invocation.
     * @return A completion stage that the servant will complete when the invocation completes.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws PatchException Raised if the patch failed.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    java.util.concurrent.CompletionStage<Void> patchServerAsync(String id, boolean shutdown, com.zeroc.Ice.Current current)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     * @param id The server id.
     * @param signal The signal, for example SIGTERM or 15.
     * @param current The Current object for the invocation.
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    void sendSignal(String id, String signal, com.zeroc.Ice.Current current)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get all the server ids registered with IceGrid.
     * @param current The Current object for the invocation.
     * @return The server ids.
     **/
    String[] getAllServerIds(com.zeroc.Ice.Current current);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     **/
    AdapterInfo[] getAdapterInfo(String id, com.zeroc.Ice.Current current)
        throws AdapterNotExistException;

    /**
     * Remove the adapter with the given id.
     * @param id The adapter id.
     * @param current The Current object for the invocation.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     * @throws DeploymentException Raised if application deployment failed.
     **/
    void removeAdapter(String id, com.zeroc.Ice.Current current)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Get all the adapter ids registered with IceGrid.
     * @param current The Current object for the invocation.
     * @return The adapter ids.
     **/
    String[] getAllAdapterIds(com.zeroc.Ice.Current current);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <code>ice_id</code> on the given proxy. The object
     * must be reachable.
     * @param obj The object to be added to the registry.
     * @param current The Current object for the invocation.
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     **/
    void addObject(com.zeroc.Ice.ObjectPrx obj, com.zeroc.Ice.Current current)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     * @param obj The object to be updated to the registry.
     * @param current The Current object for the invocation.
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    void updateObject(com.zeroc.Ice.ObjectPrx obj, com.zeroc.Ice.Current current)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     * @param obj The object to be added to the registry.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @throws DeploymentException Raised if application deployment failed.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     **/
    void addObjectWithType(com.zeroc.Ice.ObjectPrx obj, String type, com.zeroc.Ice.Current current)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     * @param id The identity of the object to be removed from the
     * registry.
     * @param current The Current object for the invocation.
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    void removeObject(com.zeroc.Ice.Identity id, com.zeroc.Ice.Current current)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     * @param id The identity of the object.
     * @param current The Current object for the invocation.
     * @return The object info.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     **/
    ObjectInfo getObjectInfo(com.zeroc.Ice.Identity id, com.zeroc.Ice.Current current)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info of all the registered objects with the
     * given type.
     * @param type The type of the object.
     * @param current The Current object for the invocation.
     * @return The object infos.
     **/
    ObjectInfo[] getObjectInfosByType(String type, com.zeroc.Ice.Current current);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<code>*</code>) character.
     * @param current The Current object for the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     **/
    ObjectInfo[] getAllObjectInfos(String expr, com.zeroc.Ice.Current current);

    /**
     * Ping an IceGrid node to see if it is active.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return true if the node ping succeeded, false otherwise.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     **/
    boolean pingNode(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException;

    /**
     * Get the load averages of the node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node load information.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    LoadInfo getNodeLoad(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node information.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    NodeInfo getNodeInfo(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get a proxy to the IceGrid node's admin object.
     * @param name The IceGrid node name
     * @param current The Current object for the invocation.
     * @return A proxy to the IceGrid node's admin object
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    com.zeroc.Ice.ObjectPrx getNodeAdmin(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    int getNodeProcessorSocketCount(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    void shutdownNode(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     * @param name The node name.
     * @param current The Current object for the invocation.
     * @return The node hostname.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     **/
    String getNodeHostname(String name, com.zeroc.Ice.Current current)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get all the IceGrid nodes currently registered.
     * @param current The Current object for the invocation.
     * @return The node names.
     **/
    String[] getAllNodeNames(com.zeroc.Ice.Current current);

    /**
     * Ping an IceGrid registry to see if it is active.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     **/
    boolean pingRegistry(String name, com.zeroc.Ice.Current current)
        throws RegistryNotExistException;

    /**
     * Get the registry information for the registry with the given name.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @return The registry information.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     **/
    RegistryInfo getRegistryInfo(String name, com.zeroc.Ice.Current current)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get a proxy to the IceGrid registry's admin object.
     * @param name The registry name
     * @param current The Current object for the invocation.
     * @return A proxy to the IceGrid registry's admin object
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     **/
    com.zeroc.Ice.ObjectPrx getRegistryAdmin(String name, com.zeroc.Ice.Current current)
        throws RegistryNotExistException;

    /**
     * Shutdown an IceGrid registry.
     * @param name The registry name.
     * @param current The Current object for the invocation.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     **/
    void shutdownRegistry(String name, com.zeroc.Ice.Current current)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get all the IceGrid registries currently registered.
     * @param current The Current object for the invocation.
     * @return The registry names.
     **/
    String[] getAllRegistryNames(com.zeroc.Ice.Current current);

    /**
     * Shut down the IceGrid registry.
     * @param current The Current object for the invocation.
     **/
    void shutdown(com.zeroc.Ice.Current current);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     * @param current The Current object for the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     **/
    java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::Admin"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::Admin";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_addApplication(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ApplicationDescriptor iceP_descriptor;
        iceP_descriptor = ApplicationDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.addApplication(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_syncApplication(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ApplicationDescriptor iceP_descriptor;
        iceP_descriptor = ApplicationDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.syncApplication(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_updateApplication(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ApplicationUpdateDescriptor iceP_descriptor;
        iceP_descriptor = ApplicationUpdateDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.updateApplication(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_syncApplicationWithoutRestart(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ApplicationDescriptor iceP_descriptor;
        iceP_descriptor = ApplicationDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.syncApplicationWithoutRestart(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_updateApplicationWithoutRestart(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        ApplicationUpdateDescriptor iceP_descriptor;
        iceP_descriptor = ApplicationUpdateDescriptor.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.updateApplicationWithoutRestart(iceP_descriptor, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_removeApplication(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        obj.removeApplication(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_instantiateServer(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_application;
        String iceP_node;
        ServerInstanceDescriptor iceP_desc;
        iceP_application = istr.readString();
        iceP_node = istr.readString();
        iceP_desc = ServerInstanceDescriptor.ice_read(istr);
        inS.endReadParams();
        obj.instantiateServer(iceP_application, iceP_node, iceP_desc, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_patchApplication(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        boolean iceP_shutdown;
        iceP_name = istr.readString();
        iceP_shutdown = istr.readBool();
        inS.endReadParams();
        return inS.setResultFuture(obj.patchApplicationAsync(iceP_name, iceP_shutdown, current));
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getApplicationInfo(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        ApplicationInfo ret = obj.getApplicationInfo(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ApplicationInfo.ice_write(ostr, ret);
        ostr.writePendingValues();
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getDefaultApplicationDescriptor(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ApplicationDescriptor ret = obj.getDefaultApplicationDescriptor(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ApplicationDescriptor.ice_write(ostr, ret);
        ostr.writePendingValues();
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAllApplicationNames(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllApplicationNames(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getServerInfo(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        ServerInfo ret = obj.getServerInfo(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ServerInfo.ice_write(ostr, ret);
        ostr.writePendingValues();
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getServerState(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        ServerState ret = obj.getServerState(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ServerState.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getServerPid(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        int ret = obj.getServerPid(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getServerAdminCategory(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getServerAdminCategory(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getServerAdmin(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getServerAdmin(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_enableServer(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        boolean iceP_enabled;
        iceP_id = istr.readString();
        iceP_enabled = istr.readBool();
        inS.endReadParams();
        obj.enableServer(iceP_id, iceP_enabled, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_isServerEnabled(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        boolean ret = obj.isServerEnabled(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_startServer(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.startServerAsync(iceP_id, current));
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_stopServer(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        return inS.setResultFuture(obj.stopServerAsync(iceP_id, current));
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_patchServer(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        boolean iceP_shutdown;
        iceP_id = istr.readString();
        iceP_shutdown = istr.readBool();
        inS.endReadParams();
        return inS.setResultFuture(obj.patchServerAsync(iceP_id, iceP_shutdown, current));
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_sendSignal(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        String iceP_signal;
        iceP_id = istr.readString();
        iceP_signal = istr.readString();
        inS.endReadParams();
        obj.sendSignal(iceP_id, iceP_signal, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAllServerIds(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllServerIds(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAdapterInfo(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        AdapterInfo[] ret = obj.getAdapterInfo(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        AdapterInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_removeAdapter(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_id;
        iceP_id = istr.readString();
        inS.endReadParams();
        obj.removeAdapter(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAllAdapterIds(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllAdapterIds(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_addObject(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.ObjectPrx iceP_obj;
        iceP_obj = istr.readProxy();
        inS.endReadParams();
        obj.addObject(iceP_obj, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_updateObject(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.ObjectPrx iceP_obj;
        iceP_obj = istr.readProxy();
        inS.endReadParams();
        obj.updateObject(iceP_obj, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_addObjectWithType(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.ObjectPrx iceP_obj;
        String iceP_type;
        iceP_obj = istr.readProxy();
        iceP_type = istr.readString();
        inS.endReadParams();
        obj.addObjectWithType(iceP_obj, iceP_type, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_removeObject(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_id;
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        obj.removeObject(iceP_id, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getObjectInfo(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_id;
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        ObjectInfo ret = obj.getObjectInfo(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ObjectInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getObjectInfosByType(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_type;
        iceP_type = istr.readString();
        inS.endReadParams();
        ObjectInfo[] ret = obj.getObjectInfosByType(iceP_type, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ObjectInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAllObjectInfos(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_expr;
        iceP_expr = istr.readString();
        inS.endReadParams();
        ObjectInfo[] ret = obj.getAllObjectInfos(iceP_expr, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ObjectInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_pingNode(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        boolean ret = obj.pingNode(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getNodeLoad(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        LoadInfo ret = obj.getNodeLoad(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        LoadInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getNodeInfo(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        NodeInfo ret = obj.getNodeInfo(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        NodeInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getNodeAdmin(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getNodeAdmin(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getNodeProcessorSocketCount(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        int ret = obj.getNodeProcessorSocketCount(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_shutdownNode(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        obj.shutdownNode(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getNodeHostname(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        String ret = obj.getNodeHostname(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAllNodeNames(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllNodeNames(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_pingRegistry(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        boolean ret = obj.pingRegistry(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeBool(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getRegistryInfo(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        RegistryInfo ret = obj.getRegistryInfo(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        RegistryInfo.ice_write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getRegistryAdmin(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.getRegistryAdmin(iceP_name, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
     * @throws com.zeroc.Ice.UserException -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_shutdownRegistry(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_name;
        iceP_name = istr.readString();
        inS.endReadParams();
        obj.shutdownRegistry(iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getAllRegistryNames(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String[] ret = obj.getAllRegistryNames(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeStringSeq(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_shutdown(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.shutdown(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_getSliceChecksums(Admin obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        java.util.Map<java.lang.String, java.lang.String> ret = obj.getSliceChecksums(current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        com.zeroc.Ice.SliceChecksumDictHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "addApplication",
        "addObject",
        "addObjectWithType",
        "enableServer",
        "getAdapterInfo",
        "getAllAdapterIds",
        "getAllApplicationNames",
        "getAllNodeNames",
        "getAllObjectInfos",
        "getAllRegistryNames",
        "getAllServerIds",
        "getApplicationInfo",
        "getDefaultApplicationDescriptor",
        "getNodeAdmin",
        "getNodeHostname",
        "getNodeInfo",
        "getNodeLoad",
        "getNodeProcessorSocketCount",
        "getObjectInfo",
        "getObjectInfosByType",
        "getRegistryAdmin",
        "getRegistryInfo",
        "getServerAdmin",
        "getServerAdminCategory",
        "getServerInfo",
        "getServerPid",
        "getServerState",
        "getSliceChecksums",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping",
        "instantiateServer",
        "isServerEnabled",
        "patchApplication",
        "patchServer",
        "pingNode",
        "pingRegistry",
        "removeAdapter",
        "removeApplication",
        "removeObject",
        "sendSignal",
        "shutdown",
        "shutdownNode",
        "shutdownRegistry",
        "startServer",
        "stopServer",
        "syncApplication",
        "syncApplicationWithoutRestart",
        "updateApplication",
        "updateApplicationWithoutRestart",
        "updateObject"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_addApplication(this, in, current);
            }
            case 1:
            {
                return _iceD_addObject(this, in, current);
            }
            case 2:
            {
                return _iceD_addObjectWithType(this, in, current);
            }
            case 3:
            {
                return _iceD_enableServer(this, in, current);
            }
            case 4:
            {
                return _iceD_getAdapterInfo(this, in, current);
            }
            case 5:
            {
                return _iceD_getAllAdapterIds(this, in, current);
            }
            case 6:
            {
                return _iceD_getAllApplicationNames(this, in, current);
            }
            case 7:
            {
                return _iceD_getAllNodeNames(this, in, current);
            }
            case 8:
            {
                return _iceD_getAllObjectInfos(this, in, current);
            }
            case 9:
            {
                return _iceD_getAllRegistryNames(this, in, current);
            }
            case 10:
            {
                return _iceD_getAllServerIds(this, in, current);
            }
            case 11:
            {
                return _iceD_getApplicationInfo(this, in, current);
            }
            case 12:
            {
                return _iceD_getDefaultApplicationDescriptor(this, in, current);
            }
            case 13:
            {
                return _iceD_getNodeAdmin(this, in, current);
            }
            case 14:
            {
                return _iceD_getNodeHostname(this, in, current);
            }
            case 15:
            {
                return _iceD_getNodeInfo(this, in, current);
            }
            case 16:
            {
                return _iceD_getNodeLoad(this, in, current);
            }
            case 17:
            {
                return _iceD_getNodeProcessorSocketCount(this, in, current);
            }
            case 18:
            {
                return _iceD_getObjectInfo(this, in, current);
            }
            case 19:
            {
                return _iceD_getObjectInfosByType(this, in, current);
            }
            case 20:
            {
                return _iceD_getRegistryAdmin(this, in, current);
            }
            case 21:
            {
                return _iceD_getRegistryInfo(this, in, current);
            }
            case 22:
            {
                return _iceD_getServerAdmin(this, in, current);
            }
            case 23:
            {
                return _iceD_getServerAdminCategory(this, in, current);
            }
            case 24:
            {
                return _iceD_getServerInfo(this, in, current);
            }
            case 25:
            {
                return _iceD_getServerPid(this, in, current);
            }
            case 26:
            {
                return _iceD_getServerState(this, in, current);
            }
            case 27:
            {
                return _iceD_getSliceChecksums(this, in, current);
            }
            case 28:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 29:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 30:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 31:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
            case 32:
            {
                return _iceD_instantiateServer(this, in, current);
            }
            case 33:
            {
                return _iceD_isServerEnabled(this, in, current);
            }
            case 34:
            {
                return _iceD_patchApplication(this, in, current);
            }
            case 35:
            {
                return _iceD_patchServer(this, in, current);
            }
            case 36:
            {
                return _iceD_pingNode(this, in, current);
            }
            case 37:
            {
                return _iceD_pingRegistry(this, in, current);
            }
            case 38:
            {
                return _iceD_removeAdapter(this, in, current);
            }
            case 39:
            {
                return _iceD_removeApplication(this, in, current);
            }
            case 40:
            {
                return _iceD_removeObject(this, in, current);
            }
            case 41:
            {
                return _iceD_sendSignal(this, in, current);
            }
            case 42:
            {
                return _iceD_shutdown(this, in, current);
            }
            case 43:
            {
                return _iceD_shutdownNode(this, in, current);
            }
            case 44:
            {
                return _iceD_shutdownRegistry(this, in, current);
            }
            case 45:
            {
                return _iceD_startServer(this, in, current);
            }
            case 46:
            {
                return _iceD_stopServer(this, in, current);
            }
            case 47:
            {
                return _iceD_syncApplication(this, in, current);
            }
            case 48:
            {
                return _iceD_syncApplicationWithoutRestart(this, in, current);
            }
            case 49:
            {
                return _iceD_updateApplication(this, in, current);
            }
            case 50:
            {
                return _iceD_updateApplicationWithoutRestart(this, in, current);
            }
            case 51:
            {
                return _iceD_updateObject(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
