/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.Snapshot;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "snapshots";
    public static final long UNDEFINED_REPOSITORY_STATE_ID = -2L;
    private static final Version REPOSITORY_ID_INTRODUCED_VERSION = Version.V_5_2_0;
    private final List<Entry> entries;
    private static final String REPOSITORY = "repository";
    private static final String SNAPSHOTS = "snapshots";
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String PARTIAL = "partial";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String START_TIME_MILLIS = "start_time_millis";
    private static final String START_TIME = "start_time";
    private static final String REPOSITORY_STATE_ID = "repository_state_id";
    private static final String SHARDS = "shards";
    private static final String INDEX = "index";
    private static final String SHARD = "shard";
    private static final String NODE = "node";

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotsInProgress that = (SnapshotsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static boolean completed(ObjectContainer<ShardSnapshotStatus> shards) {
        for (ObjectCursor status : shards) {
            if (((ShardSnapshotStatus)status.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public SnapshotsInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    public SnapshotsInProgress(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public Entry snapshot(Snapshot snapshot) {
        for (Entry entry : this.entries) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public String getWriteableName() {
        return "snapshots";
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, "snapshots", in);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            Snapshot snapshot = new Snapshot(in);
            boolean includeGlobalState = in.readBoolean();
            boolean partial = in.readBoolean();
            State state = State.fromValue(in.readByte());
            int indices = in.readVInt();
            ArrayList<IndexId> indexBuilder = new ArrayList<IndexId>();
            for (int j = 0; j < indices; ++j) {
                indexBuilder.add(new IndexId(in.readString(), in.readString()));
            }
            long startTime = in.readLong();
            ImmutableOpenMap.Builder<ShardId, ShardSnapshotStatus> builder = ImmutableOpenMap.builder();
            int shards = in.readVInt();
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = ShardId.readShardId(in);
                if (in.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
                    builder.put(shardId, new ShardSnapshotStatus(in));
                    continue;
                }
                String nodeId = in.readOptionalString();
                State shardState = State.fromValue(in.readByte());
                String reason = shardState.failed() ? "" : null;
                builder.put(shardId, new ShardSnapshotStatus(nodeId, shardState, reason));
            }
            long repositoryStateId = -2L;
            if (in.getVersion().onOrAfter(REPOSITORY_ID_INTRODUCED_VERSION)) {
                repositoryStateId = in.readLong();
            }
            String failure = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readOptionalString() : null;
            entries[i] = new Entry(snapshot, includeGlobalState, partial, state, Collections.unmodifiableList(indexBuilder), startTime, repositoryStateId, builder.build(), failure);
        }
        this.entries = Arrays.asList(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries) {
            entry.snapshot().writeTo(out);
            out.writeBoolean(entry.includeGlobalState());
            out.writeBoolean(entry.partial());
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (IndexId indexId : entry.indices()) {
                indexId.writeTo(out);
            }
            out.writeLong(entry.startTime());
            out.writeVInt(entry.shards().size());
            for (ObjectObjectCursor objectObjectCursor : entry.shards()) {
                ((ShardId)objectObjectCursor.key).writeTo(out);
                if (out.getVersion().onOrAfter(Version.V_6_0_0_beta1)) {
                    ((ShardSnapshotStatus)objectObjectCursor.value).writeTo(out);
                    continue;
                }
                out.writeOptionalString(((ShardSnapshotStatus)objectObjectCursor.value).nodeId());
                out.writeByte(((ShardSnapshotStatus)objectObjectCursor.value).state().value());
            }
            if (out.getVersion().onOrAfter(REPOSITORY_ID_INTRODUCED_VERSION)) {
                out.writeLong(entry.repositoryStateId);
            }
            if (!out.getVersion().onOrAfter(Version.V_6_7_0)) continue;
            out.writeOptionalString(entry.failure);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            this.toXContent(entry, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REPOSITORY, entry.snapshot().getRepository());
        builder.field(SNAPSHOT, entry.snapshot().getSnapshotId().getName());
        builder.field(UUID, entry.snapshot().getSnapshotId().getUUID());
        builder.field(INCLUDE_GLOBAL_STATE, entry.includeGlobalState());
        builder.field(PARTIAL, entry.partial());
        builder.field(STATE, (Object)entry.state());
        builder.startArray(INDICES);
        for (IndexId index : entry.indices()) {
            index.toXContent(builder, params);
        }
        builder.endArray();
        builder.humanReadableField(START_TIME_MILLIS, START_TIME, (Object)new TimeValue(entry.startTime()));
        builder.field(REPOSITORY_STATE_ID, entry.getRepositoryStateId());
        builder.startArray(SHARDS);
        for (ObjectObjectCursor shardEntry : entry.shards) {
            ShardId shardId = (ShardId)shardEntry.key;
            ShardSnapshotStatus status = (ShardSnapshotStatus)shardEntry.value;
            builder.startObject();
            builder.field(INDEX, (ToXContent)shardId.getIndex());
            builder.field(SHARD, shardId.getId());
            builder.field(STATE, (Object)status.state());
            builder.field(NODE, status.nodeId());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    public static enum State {
        INIT(0, false, false),
        STARTED(1, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false);

        private byte value;
        private boolean completed;
        private boolean failed;

        private State(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return ABORTED;
                }
                case 5: {
                    return MISSING;
                }
                case 6: {
                    return WAITING;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardSnapshotStatus {
        private final State state;
        private final String nodeId;
        private final String reason;

        public ShardSnapshotStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardSnapshotStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardSnapshotStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            assert (!state.failed() || reason != null);
        }

        public ShardSnapshotStatus(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardSnapshotStatus status = (ShardSnapshotStatus)o;
            if (this.nodeId != null ? !this.nodeId.equals(status.nodeId) : status.nodeId != null) {
                return false;
            }
            if (this.reason != null ? !this.reason.equals(status.reason) : status.reason != null) {
                return false;
            }
            return this.state == status.state;
        }

        public int hashCode() {
            int result = this.state != null ? this.state.hashCode() : 0;
            result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ShardSnapshotStatus[state=" + (Object)((Object)this.state) + ", nodeId=" + this.nodeId + ", reason=" + this.reason + "]";
        }
    }

    public static class Entry {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards;
        private final List<IndexId> indices;
        private final ImmutableOpenMap<String, List<ShardId>> waitingIndices;
        private final long startTime;
        private final long repositoryStateId;
        @Nullable
        private final String failure;

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = indices;
            this.startTime = startTime;
            if (shards == null) {
                this.shards = ImmutableOpenMap.of();
                this.waitingIndices = ImmutableOpenMap.of();
            } else {
                this.shards = shards;
                this.waitingIndices = this.findWaitingIndices(shards);
            }
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
        }

        public Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, List<IndexId> indices, long startTime, long repositoryStateId, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(snapshot, includeGlobalState, partial, state, indices, startTime, repositoryStateId, shards, null);
        }

        public Entry(Entry entry, State state, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, entry.indices, entry.startTime, entry.repositoryStateId, shards, entry.failure);
        }

        public Entry(Entry entry, State state, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards, String failure) {
            this(entry.snapshot, entry.includeGlobalState, entry.partial, state, entry.indices, entry.startTime, entry.repositoryStateId, shards, failure);
        }

        public Entry(Entry entry, ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            this(entry, entry.state, shards, entry.failure);
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<IndexId> indices() {
            return this.indices;
        }

        public ImmutableOpenMap<String, List<ShardId>> waitingIndices() {
            return this.waitingIndices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public long getRepositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (!this.waitingIndices.equals(entry.waitingIndices)) {
                return false;
            }
            return this.repositoryStateId == entry.repositoryStateId;
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + this.waitingIndices.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            return result;
        }

        public String toString() {
            return this.snapshot.toString();
        }

        ImmutableOpenMap<String, List<ShardId>> findWaitingIndices(ImmutableOpenMap<ShardId, ShardSnapshotStatus> shards) {
            HashMap<String, ArrayList<ShardId>> waitingIndicesMap = new HashMap<String, ArrayList<ShardId>>();
            for (ObjectObjectCursor<ShardId, ShardSnapshotStatus> objectObjectCursor : shards) {
                if (((ShardSnapshotStatus)objectObjectCursor.value).state() != State.WAITING) continue;
                String indexName = ((ShardId)objectObjectCursor.key).getIndexName();
                ArrayList<ShardId> waitingShards = (ArrayList<ShardId>)waitingIndicesMap.get(indexName);
                if (waitingShards == null) {
                    waitingShards = new ArrayList<ShardId>();
                    waitingIndicesMap.put(indexName, waitingShards);
                }
                waitingShards.add((ShardId)objectObjectCursor.key);
            }
            if (waitingIndicesMap.isEmpty()) {
                return ImmutableOpenMap.of();
            }
            ImmutableOpenMap.Builder waitingIndicesBuilder = ImmutableOpenMap.builder();
            for (Map.Entry entry : waitingIndicesMap.entrySet()) {
                waitingIndicesBuilder.put((String)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
            }
            return waitingIndicesBuilder.build();
        }
    }
}

