/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampIntegerMap
extends TimestampMap<Integer> {
    private int[] values;

    public TimestampIntegerMap() {
        this.values = new int[0];
    }

    public TimestampIntegerMap(int capacity) {
        super(capacity);
        this.values = new int[capacity];
    }

    public TimestampIntegerMap(double[] keys, int[] vals) {
        super(keys);
        this.values = new int[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public int getInteger(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public int getInteger(double timestamp, int defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Integer.valueOf(max.intValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Integer.valueOf(min.intValue()) : null;
    }

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    public int[] toIntegerArray() {
        return (int[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Integer getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (int[])array;
    }
}

