/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

final class ExceptionUtils {
    private ExceptionUtils() {
    }

    static Throwable getExceptionDetails(ITestContext iTestContext, Object object) {
        Set<ITestResult> set = iTestContext.getFailedConfigurations().getAllResults();
        if (set.isEmpty()) {
            set = iTestContext.getSkippedConfigurations().getAllResults();
        }
        if (set.isEmpty()) {
            return ExceptionUtils.getConfigFailureException(iTestContext);
        }
        for (ITestResult iTestResult : set) {
            if (!ExceptionUtils.sameInstance(iTestResult, object)) continue;
            return iTestResult.getThrowable();
        }
        return set.iterator().next().getThrowable();
    }

    private static boolean sameInstance(ITestResult iTestResult, Object object) {
        return object.equals(iTestResult.getInstance());
    }

    private static Throwable getConfigFailureException(ITestContext iTestContext) {
        for (IInvokedMethod iInvokedMethod : iTestContext.getSuite().getAllInvokedMethods()) {
            ITestNGMethod iTestNGMethod = iInvokedMethod.getTestMethod();
            if (!iTestNGMethod.isBeforeSuiteConfiguration() || iInvokedMethod.getTestResult().isSuccess()) continue;
            return iInvokedMethod.getTestResult().getThrowable();
        }
        return null;
    }
}

