/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.util.Hashtable;
import javajs.util.PT;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.WebPanel;

class PopInJmol
extends WebPanel
implements ChangeListener {
    PopInJmol(Viewer viewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        super(viewer, jFileChooser, webPanelArray, n);
        this.panelName = "pop_in";
        this.listLabel = GT.$("These names will be used as filenames used by JSmol");
    }

    @Override
    JPanel appletParamPanel() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(WebExport.getPopInWidth(), 50, 1000, 25);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(WebExport.getPopInHeight(), 50, 1000, 25);
        this.appletSizeSpinnerW = new JSpinner(spinnerNumberModel);
        this.appletSizeSpinnerW.addChangeListener(this);
        this.appletSizeSpinnerH = new JSpinner(spinnerNumberModel2);
        this.appletSizeSpinnerH.addChangeListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(GT.$("JSmol width:")));
        jPanel.add(this.appletSizeSpinnerW);
        jPanel.add(new JLabel(GT.$("height:")));
        jPanel.add(this.appletSizeSpinnerH);
        return jPanel;
    }

    @Override
    String fixHtml(String string) {
        String string2 = "";
        int n = this.getInstanceList().getModel().getSize();
        int n2 = 0;
        while (n2 < n) {
            String string3 = this.getInstanceList().getModel().getElementAt((int)n2).javaname;
            string2 = String.valueOf(string2) + "   var jmolInfo" + n2 + "=jmolInfo;\n";
            string2 = String.valueOf(string2) + "   jmolInfo" + n2 + ".coverImage=\"" + string3 + ".png\";\n";
            string2 = String.valueOf(string2) + "   jmolInfo" + n2 + ".coverScript=\"javascript revealPopinWidgets(" + n2 + ");\";\n";
            string2 = String.valueOf(string2) + "   jmolInfo" + n2 + ".script=\"load " + string3 + ".spt\";\n";
            string2 = String.valueOf(string2) + "   $(\"#Jmol" + n2 + "\").html(Jmol.getAppletHtml(\"jmolApplet" + n2 + "\",jmolInfo" + n2 + "));\n";
            ++n2;
        }
        string = PT.rep(string, "@APPLETINITIALIZATION@", string2);
        return string;
    }

    @Override
    String getAppletDefs(int n, String string, StringBuilder stringBuilder, JmolInstance jmolInstance) {
        String string2 = n % 2 == 0 ? "floatRight" : "floatLeft";
        String string3 = jmolInstance.name;
        String string4 = jmolInstance.javaname;
        int n2 = jmolInstance.width;
        int n3 = jmolInstance.height;
        String string5 = "";
        if (!jmolInstance.whichWidgets.isEmpty()) {
            string5 = String.valueOf(string5) + "<div id=\"JmolCntl" + n + "\">";
            int n4 = 0;
            while (n4 < this.nWidgets) {
                if (jmolInstance.whichWidgets.get(n4)) {
                    string5 = String.valueOf(string5) + "\n<div class=\"widgetItemPopin\">" + this.theWidgets.widgetList[n4].getJavaScript(n, jmolInstance) + "</div>\n";
                }
                ++n4;
            }
            string5 = String.valueOf(string5) + "</div>";
        }
        String string6 = this.htmlAppletTemplate;
        string6 = PT.rep(string6, "@CLASS@", string2);
        string6 = PT.rep(string6, "@I@", "" + n);
        string6 = PT.rep(string6, "@WIDTH@", "" + n2);
        string6 = PT.rep(string6, "@HEIGHT@", "" + n3);
        string6 = PT.rep(string6, "@NAME@", "&#x201C;" + GT.escapeHTML(string3) + "&#x201D;");
        string6 = PT.rep(string6, "@APPLETNAME@", GT.escapeHTML(string4));
        string6 = PT.rep(string6, "@LEFTWIDGETS@", "");
        string6 = PT.rep(string6, "@RIGHTWIDGETS@", string5);
        stringBuilder.append(string6);
        return string;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.appletSizeSpinnerW || changeEvent.getSource() == this.appletSizeSpinnerH) {
            int n = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
            int n2 = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            WebExport.setPopInDim(n, n2);
            JList<JmolInstance> jList = this.getInstanceList();
            int[] nArray = jList.getSelectedIndices();
            if (nArray.length != 1) {
                return;
            }
            int n3 = jList.getSelectedIndex();
            JmolInstance jmolInstance = jList.getModel().getElementAt(n3);
            jmolInstance.width = n;
            jmolInstance.height = n2;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("fileName", jmolInstance.pictFile);
            hashtable.put("type", "PNG");
            hashtable.put("quality", 2);
            hashtable.put("width", n);
            hashtable.put("height", n2);
            this.vwr.outputToFile(hashtable);
            return;
        }
        if (changeEvent.getSource() == this.appletSizeSpinnerP) {
            int n = ((SpinnerNumberModel)this.appletSizeSpinnerP.getModel()).getNumber().intValue();
            WebExport.setScriptButtonPercent(n);
            return;
        }
    }
}

