/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Optional;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.widgets.SearchTextResultListPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class MenuItemSearchDialog
extends ExtendedDialog {
    private final MenuItemSelector selector;
    private static final MenuItemSearchDialog INSTANCE = new MenuItemSearchDialog(MainApplication.getMenu());

    private MenuItemSearchDialog(MainMenu menu) {
        super((Component)MainApplication.getMainFrame(), I18n.tr("Search menu items", new Object[0]), I18n.tr("Select", new Object[0]), I18n.tr("Cancel", new Object[0]));
        this.selector = new MenuItemSelector(menu);
        this.selector.setDblClickListener(e -> this.buttonAction(0, null));
        this.setContent(this.selector, false);
        this.setPreferredSize(new Dimension(600, 300));
    }

    public static synchronized MenuItemSearchDialog getInstance() {
        return INSTANCE;
    }

    @Override
    public ExtendedDialog showDialog() {
        this.selector.init();
        super.showDialog();
        this.selector.clearSelection();
        return this;
    }

    @Override
    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        super.buttonAction(buttonIndex, evt);
        if (buttonIndex == 0 && this.selector.getSelectedItem() != null && this.selector.getSelectedItem().isEnabled()) {
            this.selector.getSelectedItem().getAction().actionPerformed(evt);
        }
    }

    public static class Action
    extends JosmAction {
        public static final Shortcut SHORTCUT = Shortcut.registerShortcut("help:search-items", "Search menu items", 32, 5006);

        public Action() {
            super(I18n.tr("Search menu items", new Object[0]), "dialogs/search", null, SHORTCUT, true, "dialogs/search-items", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuItemSearchDialog.getInstance().showDialog();
        }
    }

    private static class CellRenderer
    implements ListCellRenderer<JMenuItem> {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JMenuItem> list, JMenuItem value, int index, boolean isSelected, boolean cellHasFocus) {
            JMenuItem item = new JMenuItem(value.getText());
            item.setAction(value.getAction());
            Optional.ofNullable(value.getAction()).filter(JosmAction.class::isInstance).map(JosmAction.class::cast).map(JosmAction::getShortcut).map(Shortcut::getKeyStroke).ifPresent(item::setAccelerator);
            item.setArmed(isSelected);
            if (isSelected) {
                item.setBackground(list.getSelectionBackground());
                item.setForeground(list.getSelectionForeground());
            } else {
                item.setBackground(list.getBackground());
                item.setForeground(list.getForeground());
            }
            return item;
        }
    }

    private static class MenuItemSelector
    extends SearchTextResultListPanel<JMenuItem> {
        private final MainMenu menu;

        MenuItemSelector(MainMenu menu) {
            this.menu = menu;
            this.lsResult.setCellRenderer(new CellRenderer());
        }

        public JMenuItem getSelectedItem() {
            JMenuItem selected = (JMenuItem)this.lsResult.getSelectedValue();
            if (selected != null) {
                return selected;
            }
            if (!this.lsResultModel.isEmpty()) {
                return (JMenuItem)this.lsResultModel.getElementAt(0);
            }
            return null;
        }

        @Override
        protected void filterItems() {
            this.lsResultModel.setItems(this.menu.findMenuItems(this.edSearchText.getText(), true));
        }
    }
}

